/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CoverPageSupplement14V14.PHS398CoverPageSupplement14Document;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CoverPageSupplementBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CoverPageSupplementV1_4Generator")
public class PHS398CoverPageSupplementV1_4Generator
extends PHS398CoverPageSupplementBaseGenerator<PHS398CoverPageSupplement14Document> {
    private List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/PHS398_CoverPageSupplement_1_4-V1.4")
    private String namespace;
    @Value(value="PHS398_CoverPageSupplement_1_4")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CoverPageSupplement-V1.4.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="158")
    private int sortIndex;

    private PHS398CoverPageSupplement14Document getCoverPageSupplement() {
        PHS398CoverPageSupplement14Document coverPageSupplementDocument = (PHS398CoverPageSupplement14Document)PHS398CoverPageSupplement14Document.Factory.newInstance();
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14 coverPageSupplement = (PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14)PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.Factory.newInstance();
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        coverPageSupplement.setFormVersion(FormVersion.v1_4.getVersion());
        coverPageSupplement.setPDPI(this.getPDPI());
        coverPageSupplement.setClinicalTrial(this.getClinicalTrial());
        coverPageSupplement.setContactPersonInfo(this.getContactPersonInfo());
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        coverPageSupplementDocument.setPHS398CoverPageSupplement14(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.PDPI getPDPI() {
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.PDPI pdpi = (PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.PDPI)PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.PDPI.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        pdpi.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        return pdpi;
    }

    private PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ClinicalTrial getClinicalTrial() {
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ClinicalTrial clinicalTrial = (PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ClinicalTrial)PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ClinicalTrial.Factory.newInstance();
        String answer = this.getAnswer(IS_CLINICAL_TRIAL, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            if (YnqConstant.YES.code().equals(answer)) {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(PHASE_III_CLINICAL_TRIAL, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.Y_YES);
                    } else {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.N_NO);
                    }
                } else {
                    clinicalTrial.setIsPhaseIIIClinicalTrial(null);
                }
            } else {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.N_NO);
            }
        }
        return clinicalTrial;
    }

    private PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ContactPersonInfo getContactPersonInfo() {
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ContactPersonInfo contactPersonInfo = (PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ContactPersonInfo)PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.ContactPersonInfo.Factory.newInstance();
        DepartmentalPersonDto person = this.departmentalPersonService.getContactPerson(this.pdDoc);
        contactPersonInfo.setContactName(this.globLibV20Generator.getHumanNameDataType(person));
        contactPersonInfo.setContactPhone(person.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)person.getFaxNumber())) {
            contactPersonInfo.setContactFax(person.getFaxNumber());
        }
        if (person.getEmailAddress() != null && !person.getEmailAddress().equals("")) {
            contactPersonInfo.setContactEmail(person.getEmailAddress());
        }
        if (person.getPrimaryTitle() != null) {
            contactPersonInfo.setContactTitle(StringUtils.substring((String)person.getPrimaryTitle(), (int)0, (int)45));
        }
        contactPersonInfo.setContactAddress(this.globLibV20Generator.getAddressDataType(person));
        return contactPersonInfo;
    }

    private PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.StemCells getStemCells() {
        PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.StemCells stemCells = (PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.StemCells)PHS398CoverPageSupplement14Document.PHS398CoverPageSupplement14.StemCells.Factory.newInstance();
        String childAnswer = null;
        String answer = this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            YesNoDataType.Enum answers;
            YesNoDataType.Enum enum_ = answers = YnqConstant.YES.code().equals(this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders)) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            if (YnqConstant.YES.code().equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(SPECIFIC_STEM_CELL_LINE, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
                        childAnswer = this.getAnswers(REGISTRATION_NUMBER, this.answerHeaders);
                    } else {
                        stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
                    }
                }
                if (childAnswer != null) {
                    if ("Unknown".equalsIgnoreCase(childAnswer)) {
                        stemCells.setStemCellsIndicator(answers);
                    } else {
                        List<String> cellLines = this.getCellLines(childAnswer);
                        if (cellLines.size() > 0) {
                            stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                        }
                    }
                }
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
            }
        }
        return stemCells;
    }

    @Override
    public PHS398CoverPageSupplement14Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398CoverPageSupplement14Document> factory() {
        return PHS398CoverPageSupplement14Document.Factory;
    }
}

