/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398TrainingBudgetV10.PHS398TrainingBudgetDocument;
import gov.grants.apply.forms.phs398TrainingSubawardBudgetV10.PHS398TrainingSubawardBudgetDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="PHS398TrainingSubAwardBudgetV1_0Generator")
public class PHS398TrainingSubAwardBudgetV1_0Generator
extends S2SAdobeFormAttachmentBaseGenerator<PHS398TrainingSubawardBudgetDocument> {
    private static final String PHS398_TRAINING_BUDGET_10_NAMESPACE_URI = "http://apply.grants.gov/forms/PHS398_TrainingBudget-V1.0";
    @Value(value="http://apply.grants.gov/forms/PHS398_TrainingSubawardBudget-V1.0")
    private String namespace;
    @Value(value="PHS398_TrainingSubawardBudget-V1.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_TrainingSubawardBudget-V1.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="162")
    private int sortIndex;

    private PHS398TrainingSubawardBudgetDocument getPHS398TrainingSubawardBudget() throws S2SException {
        PHS398TrainingSubawardBudgetDocument phs398TrainingSubawardBudgetDocument = (PHS398TrainingSubawardBudgetDocument)PHS398TrainingSubawardBudgetDocument.Factory.newInstance();
        PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget phs398TrainingSubawardBudget = (PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget)PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget.Factory.newInstance();
        PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget.BudgetAttachments budgetAttachments = (PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget.BudgetAttachments)PHS398TrainingSubawardBudgetDocument.PHS398TrainingSubawardBudget.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, PHS398_TRAINING_BUDGET_10_NAMESPACE_URI, true);
        PHS398TrainingBudgetDocument.PHS398TrainingBudget[] budgetList = new PHS398TrainingBudgetDocument.PHS398TrainingBudget[budgetSubAwardsList.size()];
        phs398TrainingSubawardBudget.setFormVersion(FormVersion.v1_0.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            switch (attCount) {
                case 1: {
                    phs398TrainingSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList[0] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 2: {
                    phs398TrainingSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList[1] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 3: {
                    phs398TrainingSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList[2] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 4: {
                    phs398TrainingSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList[3] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 5: {
                    phs398TrainingSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList[4] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 6: {
                    phs398TrainingSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList[5] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 7: {
                    phs398TrainingSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList[6] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 8: {
                    phs398TrainingSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList[7] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 9: {
                    phs398TrainingSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList[8] = this.getPHS398TrainingBudget(budgetSubAwards);
                    break;
                }
                case 10: {
                    phs398TrainingSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList[9] = this.getPHS398TrainingBudget(budgetSubAwards);
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setPHS398TrainingBudgetArray(budgetList);
        phs398TrainingSubawardBudget.setBudgetAttachments(budgetAttachments);
        phs398TrainingSubawardBudgetDocument.setPHS398TrainingSubawardBudget(phs398TrainingSubawardBudget);
        return phs398TrainingSubawardBudgetDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PHS398TrainingBudgetDocument.PHS398TrainingBudget getPHS398TrainingBudget(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        Document subAwdFormsDoc;
        PHS398TrainingBudgetDocument.PHS398TrainingBudget rrBudget = (PHS398TrainingBudgetDocument.PHS398TrainingBudget)PHS398TrainingBudgetDocument.PHS398TrainingBudget.Factory.newInstance();
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        try {
            subAwdFormsDoc = this.stringToDom(subAwdXML);
        }
        catch (S2SException e1) {
            return rrBudget;
        }
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(PHS398_TRAINING_BUDGET_10_NAMESPACE_URI, "PHS398_TrainingBudget");
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        byte[] subAwdNodeBytes = null;
        InputStream bgtIS = null;
        try {
            subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            PHS398TrainingBudgetDocument rrBudgetDocument = (PHS398TrainingBudgetDocument)PHS398TrainingBudgetDocument.Factory.parse(bgtIS);
            rrBudget = rrBudgetDocument.getPHS398TrainingBudget();
        }
        catch (IOException | XmlException | S2SException e) {
            PHS398TrainingBudgetDocument.PHS398TrainingBudget pHS398TrainingBudget = rrBudget;
            return pHS398TrainingBudget;
        }
        finally {
            if (bgtIS != null) {
                try {
                    bgtIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rrBudget;
    }

    @Override
    public PHS398TrainingSubawardBudgetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398TrainingSubawardBudget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public DocumentFactory<PHS398TrainingSubawardBudgetDocument> factory() {
        return PHS398TrainingSubawardBudgetDocument.Factory;
    }
}

