/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.coeus.personProfile.PersonProfileListDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.UnitRepositoryService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.attachment.ProposalPersonBiographyContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.kuali.coeus.s2sgen.impl.print.GenericPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public abstract class RRKeyPersonBase<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    private static final Logger LOG = LogManager.getLogger(RRKeyPersonBase.class);
    protected List<ProposalPersonContract> extraPersons = null;
    protected List<NarrativeContract> addedNarratives = new ArrayList<NarrativeContract>();
    protected static final int BIOSKETCH_DOC_TYPE = 16;
    protected static final int CURRENTPENDING_DOC_TYPE = 17;
    protected static final String BIOSKETCH_TYPE = "1";
    protected static final String CURRENT_PENDING_TYPE = "2";
    private static final String COMMENT = "Auto generated document for ";
    private static final String BIOSKETCH_COMMENT = "BIOSKETCH";
    private static final String CURRENT_PENDING_COMMENT = "CURRENTPENDING";
    protected static final String PROFILE_COMMENT = "PROFILE";
    protected static final int PROFILE_TYPE = 18;
    protected static final String NIH_CO_INVESTIGATOR = "Co-Investigator";
    protected static final String ERROR_ERA_COMMON_USER_NAME = "eRA Commons User Name is missing for ";
    protected static final int DEPARTMENT_NAME_MAX_LENGTH = 30;
    protected static final int MAX_KEY_PERSON_COUNT = 8;
    protected static final int DIRECTORY_TITLE_MAX_LENGTH = 45;
    protected static final int ROLE_DESCRIPTION_MAX_LENGTH = 40;
    protected String pIPersonOrRolodexId = null;
    @Autowired
    @Qualifier(value="unitRepositoryService")
    private UnitRepositoryService unitRepositoryService;
    @Autowired
    @Qualifier(value="s2SPrintingService")
    private S2SPrintingService s2SPrintingService;
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    protected S2SProposalPersonService s2SProposalPersonService;
    @Autowired
    @Qualifier(value="s2sDivisionService")
    private S2sDivisionService s2sDivisionService;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/additionalkeypersonprofiles.xsl")
    private Resource additionalkeypersonprofilesStyleSheet;

    protected void saveKeyPersonAttachmentsToProposal() {
        if (this.extraPersons != null && !this.extraPersons.isEmpty()) {
            this.saveKeyPersonAttachments();
            this.saveKeypersonProfileObject();
        }
    }

    private void saveKeyPersonAttachments() {
        ArrayList<String> bioSketchBookMarks = new ArrayList<String>();
        ArrayList<String> curPendBookMarks = new ArrayList<String>();
        ArrayList<byte[]> bioSketchDataList = new ArrayList<byte[]>();
        ArrayList<byte[]> curPendDataList = new ArrayList<byte[]>();
        for (ProposalPersonContract proposalPerson : this.extraPersons) {
            this.setBookMarkAndData(bioSketchBookMarks, bioSketchDataList, proposalPerson, BIOSKETCH_TYPE);
            this.setBookMarkAndData(curPendBookMarks, curPendDataList, proposalPerson, CURRENT_PENDING_TYPE);
        }
        try {
            NarrativeContract narrativeContract;
            byte[] bioSketchData = this.s2SPrintingService.mergePdfBytes(bioSketchDataList, bioSketchBookMarks, true);
            byte[] curPendData = this.s2SPrintingService.mergePdfBytes(curPendDataList, curPendBookMarks, true);
            String fileName = null;
            if (bioSketchData != null && bioSketchData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_BIOSKETCH.pdf";
                narrativeContract = this.saveNarrative(bioSketchData, "16", fileName, "Auto generated document for BIOSKETCH");
                this.getAddedNarratives().add(narrativeContract);
            }
            if (curPendData != null && curPendData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_CURRENTPENDING.pdf";
                narrativeContract = this.saveNarrative(curPendData, "17", fileName, "Auto generated document for CURRENTPENDING");
                this.getAddedNarratives().add(narrativeContract);
            }
        }
        catch (S2SException e) {
            LOG.error("Auto generation of Biosketch/Currend Pending report for extra Keypersons is failed", (Throwable)e);
        }
    }

    private void setBookMarkAndData(List<String> bookMarksList, List<byte[]> dataList, ProposalPersonContract proposalPerson, String docType) {
        Object personId = proposalPerson.getPersonId() != null && proposalPerson.getPersonId().length() > 0 ? proposalPerson.getPersonId() : "" + proposalPerson.getRolodexId();
        for (ProposalPersonBiographyContract personBiography : this.getPernonnelAttachments(this.pdDoc, proposalPerson, docType)) {
            byte[] content = personBiography.getPersonnelAttachment().getData();
            if (content == null || content.length <= 0) continue;
            dataList.add(content);
            bookMarksList.add((String)personId);
        }
    }

    private List<ProposalPersonBiographyContract> getPernonnelAttachments(ProposalDevelopmentDocumentContract pdDoc, ProposalPersonContract proposalPerson, String documentType) {
        ArrayList<ProposalPersonBiographyContract> result = new ArrayList<ProposalPersonBiographyContract>();
        for (ProposalPersonBiographyContract proposalPersonBiography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
            String personId = proposalPerson.getPersonId();
            Integer rolodexId = proposalPerson.getRolodexId();
            if (personId != null && proposalPersonBiography.getPersonId() != null && proposalPersonBiography.getPersonId().equals(personId) && documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) {
                result.add(proposalPersonBiography);
                continue;
            }
            if (rolodexId == null || proposalPersonBiography.getRolodexId() == null || !proposalPersonBiography.getRolodexId().toString().equals(rolodexId.toString()) || !documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) continue;
            result.add(proposalPersonBiography);
        }
        return result;
    }

    protected PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[] getExtraKeyPersons() {
        ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson> extraPersonList = new ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson>();
        for (ProposalPersonContract proposalPerson : this.extraPersons) {
            AttachedFileDataType curPendingAttachment;
            AttachedFileDataType bioSketchAttachment;
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Factory.newInstance();
            extraPerson.setName(this.getExtraPersonName(proposalPerson));
            extraPerson.setAddress(this.getExtraPersonAddress(proposalPerson));
            if (proposalPerson.getPrimaryTitle() != null && proposalPerson.getPrimaryTitle().length() > 45) {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle().substring(0, 45));
            } else {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle());
            }
            if (proposalPerson.getProposalPersonRoleId() != null) {
                if (proposalPerson.isPrincipalInvestigator()) {
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.PD_PI);
                } else if (proposalPerson.isCoInvestigator()) {
                    if (this.isSponsorNIH(this.pdDoc)) {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                        extraPerson.setOtherProjectRoleCategory(NIH_CO_INVESTIGATOR);
                    } else {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.CO_PD_PI);
                    }
                } else {
                    String otherRole = proposalPerson.getProjectRole() != null && proposalPerson.getProjectRole().length() > 40 ? proposalPerson.getProjectRole().substring(0, 40) : proposalPerson.getProjectRole();
                    extraPerson.setOtherProjectRoleCategory(otherRole);
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                }
            }
            if (proposalPerson.getEraCommonsUserName() != null) {
                extraPerson.setCredential(proposalPerson.getEraCommonsUserName());
            }
            this.setDepartmentName(extraPerson);
            this.setDivisionName(extraPerson);
            if (proposalPerson.getEmailAddress() != null) {
                extraPerson.setEmail(proposalPerson.getEmailAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)proposalPerson.getFaxNumber())) {
                extraPerson.setFax(proposalPerson.getFaxNumber());
            }
            if (proposalPerson.getHomeUnit() != null) {
                UnitContract unit = this.unitRepositoryService.findUnitByUnitNumber(proposalPerson.getHomeUnit());
                extraPerson.setDepartmentName(StringUtils.substring((String)unit.getUnitName(), (int)0, (int)30));
            } else if (proposalPerson.getRolodexId() != null && proposalPerson.getDirectoryDepartment() != null) {
                extraPerson.setDepartmentName(StringUtils.substring((String)proposalPerson.getDirectoryDepartment(), (int)0, (int)30));
            } else {
                extraPerson.setDepartmentName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName(), (int)0, (int)30));
            }
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                extraPerson.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
            }
            if (proposalPerson.getOfficePhone() != null) {
                extraPerson.setPhone(proposalPerson.getOfficePhone());
            }
            if (proposalPerson.getDegree() != null) {
                extraPerson.setDegreeType(proposalPerson.getDegree());
            }
            if (proposalPerson.getYearGraduated() != null) {
                extraPerson.setDegreeYear(proposalPerson.getYearGraduated());
            }
            if ((bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), BIOSKETCH_TYPE)) != null) {
                extraPerson.setBioSketchAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.BioSketchAttached.YES);
            }
            if ((curPendingAttachment = this.getPersonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), CURRENT_PENDING_TYPE)) != null) {
                extraPerson.setSupportsAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.SupportsAttached.YES);
            }
            extraPersonList.add(extraPerson);
        }
        return extraPersonList.toArray(new PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[0]);
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address getExtraPersonAddress(ProposalPersonContract proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address address = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Factory.newInstance();
        if (proposalPerson.getAddressLine1() != null) {
            if (proposalPerson.getAddressLine1().length() > 55) {
                address.setStreet1(proposalPerson.getAddressLine1().substring(0, 55));
            } else {
                address.setStreet1(proposalPerson.getAddressLine1());
            }
        }
        if (proposalPerson.getAddressLine2() != null) {
            if (proposalPerson.getAddressLine2().length() > 55) {
                address.setStreet2(proposalPerson.getAddressLine2().substring(0, 55));
            } else {
                address.setStreet2(proposalPerson.getAddressLine2());
            }
        }
        if (proposalPerson.getCity() != null) {
            address.setCity(proposalPerson.getCity());
        }
        if (proposalPerson.getCounty() != null) {
            address.setCounty(proposalPerson.getCounty());
        }
        if (proposalPerson.getPostalCode() != null) {
            address.setZipCode(proposalPerson.getPostalCode());
        }
        if (proposalPerson.getCountryCode() != null) {
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum county = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum.forString(proposalPerson.getCountryCode());
            address.setCountry(county);
        }
        if (proposalPerson.getState() != null) {
            address.setState(proposalPerson.getState());
        }
        return address;
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name getExtraPersonName(ProposalPersonContract proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name name = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name.Factory.newInstance();
        if (proposalPerson.getFirstName() != null) {
            name.setFirstName(proposalPerson.getFirstName());
        }
        if (proposalPerson.getMiddleName() != null) {
            name.setMiddleName(proposalPerson.getMiddleName());
        }
        if (proposalPerson.getLastName() != null) {
            name.setLastName(proposalPerson.getLastName());
        }
        return name;
    }

    private void setDivisionName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson) {
        extraPerson.setDivisionName("");
    }

    private void setDepartmentName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson) {
        extraPerson.setDepartmentName("");
    }

    private void saveKeypersonProfileObject() {
        if (this.extraPersons != null && !this.extraPersons.isEmpty()) {
            PersonProfileListDocument.PersonProfileList extraPersonProfileList = (PersonProfileListDocument.PersonProfileList)PersonProfileListDocument.PersonProfileList.Factory.newInstance();
            extraPersonProfileList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraPersonProfileList.setExtraKeyPersonArray(this.getExtraKeyPersons());
            PersonProfileListDocument extraPersonDoc = (PersonProfileListDocument)PersonProfileListDocument.Factory.newInstance();
            extraPersonDoc.setPersonProfileList(extraPersonProfileList);
            String xmlData = extraPersonDoc.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.additionalkeypersonprofilesStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_PROFILE.pdf";
                NarrativeContract narrativeContract = this.saveNarrative(printData.getData(), "18", fileName, "Auto generated document for PROFILE");
                this.getAddedNarratives().add(narrativeContract);
            }
            catch (S2SException e) {
                LOG.error("Auto generation of Profile attachment for extra Keypersons failed", (Throwable)e);
            }
        }
    }

    public UnitRepositoryService getUnitRepositoryService() {
        return this.unitRepositoryService;
    }

    public void setUnitRepositoryService(UnitRepositoryService unitRepositoryService) {
        this.unitRepositoryService = unitRepositoryService;
    }

    public S2SPrintingService getS2SPrintingService() {
        return this.s2SPrintingService;
    }

    public void setS2SPrintingService(S2SPrintingService s2SPrintingService) {
        this.s2SPrintingService = s2SPrintingService;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    public S2sDivisionService getS2sDivisionService() {
        return this.s2sDivisionService;
    }

    public void setS2sDivisionService(S2sDivisionService s2sDivisionService) {
        this.s2sDivisionService = s2sDivisionService;
    }

    public Resource getAdditionalkeypersonprofilesStyleSheet() {
        return this.additionalkeypersonprofilesStyleSheet;
    }

    public void setAdditionalkeypersonprofilesStyleSheet(Resource additionalkeypersonprofilesStyleSheet) {
        this.additionalkeypersonprofilesStyleSheet = additionalkeypersonprofilesStyleSheet;
    }

    public List<NarrativeContract> getAddedNarratives() {
        return this.addedNarratives;
    }

    public void setAddedNarratives(List<NarrativeContract> addedNarratives) {
        this.addedNarratives = addedNarratives;
    }
}

