/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget13V13.RRBudget13Document;
import gov.grants.apply.forms.rrSubawardBudget13V13.RRSubawardBudget13Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRSubAwardBudget1_3V1_3Generator")
public class RRSubAwardBudget1_3V1_3Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget13Document>
implements S2SFormGeneratorPdfFillable<RRSubawardBudget13Document> {
    private static final String RR_BUDGET1_3_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget_1_3-V1.3";
    private static final String RR_BUDGET1_3_LOCAL_NAME = "RR_Budget_1_3";
    @Value(value="http://apply.grants.gov/forms/RR_SubawardBudget_1_3-V1.3")
    private String namespace;
    @Value(value="RR_SubawardBudget_1_3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget-V1.3.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SubawardBudget_1_3-V1.3.pdf")
    private Resource pdfForm;
    @Value(value="177")
    private int sortIndex;

    private RRSubawardBudget13Document getRRSubawardBudgetDocument() throws S2SException {
        RRSubawardBudget13Document rrSubawardBudgetDocument = (RRSubawardBudget13Document)RRSubawardBudget13Document.Factory.newInstance();
        RRSubawardBudget13Document.RRSubawardBudget13 rrSubawardBudget = (RRSubawardBudget13Document.RRSubawardBudget13)RRSubawardBudget13Document.RRSubawardBudget13.Factory.newInstance();
        RRSubawardBudget13Document.RRSubawardBudget13.BudgetAttachments budgetAttachments = (RRSubawardBudget13Document.RRSubawardBudget13.BudgetAttachments)RRSubawardBudget13Document.RRSubawardBudget13.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, RR_BUDGET1_3_NAMESPACE_URI, false);
        ArrayList<RRBudget13Document.RRBudget13> budgetList = new ArrayList<RRBudget13Document.RRBudget13>();
        rrSubawardBudget.setFormVersion(FormVersion.v1_3.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRBudget13Document rrBudgetDocument = this.getRRBudget10(budgetSubAwards);
            if (rrBudgetDocument == null) continue;
            RRBudget13Document.RRBudget13 rrBudget = rrBudgetDocument.getRRBudget13();
            switch (attCount) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList.add(0, rrBudget);
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList.add(1, rrBudget);
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList.add(2, rrBudget);
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList.add(3, rrBudget);
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList.add(4, rrBudget);
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList.add(5, rrBudget);
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList.add(6, rrBudget);
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList.add(7, rrBudget);
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList.add(8, rrBudget);
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList.add(9, rrBudget);
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setRRBudget13Array(budgetList.toArray(new RRBudget13Document.RRBudget13[0]));
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget13(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget13Document getRRBudget10(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = this.stringToDom(subAwdXML);
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET1_3_NAMESPACE_URI, RR_BUDGET1_3_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        try {
            byte[] subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            ByteArrayInputStream bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            return (RRBudget13Document)RRBudget13Document.Factory.parse((InputStream)bgtIS);
        }
        catch (IOException | XmlException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RRSubawardBudget13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRSubawardBudget13Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRSubawardBudget13Document> factory() {
        return RRSubawardBudget13Document.Factory;
    }
}

