/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudgetV11.RRBudgetDocument;
import gov.grants.apply.forms.rrSubawardBudgetV12.RRSubawardBudgetDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRSubAwardBudgetV1_2Generator")
public class RRSubAwardBudgetV1_2Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudgetDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_SubawardBudget-V1.2")
    private String namespace;
    @Value(value="RR_SubawardBudget-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="177")
    private int sortIndex;

    private RRSubawardBudgetDocument getRRSubawardBudgetDocument() throws S2SException {
        RRSubawardBudgetDocument rrSubawardBudgetDocument = (RRSubawardBudgetDocument)RRSubawardBudgetDocument.Factory.newInstance();
        RRSubawardBudgetDocument.RRSubawardBudget rrSubawardBudget = (RRSubawardBudgetDocument.RRSubawardBudget)RRSubawardBudgetDocument.RRSubawardBudget.Factory.newInstance();
        RRSubawardBudgetDocument.RRSubawardBudget.BudgetAttachments budgetAttachments = (RRSubawardBudgetDocument.RRSubawardBudget.BudgetAttachments)RRSubawardBudgetDocument.RRSubawardBudget.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, "http://apply.grants.gov/forms/RR_Budget-V1.1", true);
        ArrayList<RRBudgetDocument.RRBudget> budgetList = new ArrayList<RRBudgetDocument.RRBudget>();
        rrSubawardBudget.setFormVersion(FormVersion.v1_2.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRBudgetDocument rrBudgetDocument = this.getRRBudget(budgetSubAwards);
            if (rrBudgetDocument == null) continue;
            RRBudgetDocument.RRBudget rrBudget = rrBudgetDocument.getRRBudget();
            switch (attCount) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList.add(0, rrBudget);
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList.add(1, rrBudget);
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList.add(2, rrBudget);
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList.add(3, rrBudget);
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList.add(4, rrBudget);
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList.add(5, rrBudget);
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList.add(6, rrBudget);
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList.add(7, rrBudget);
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList.add(8, rrBudget);
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList.add(9, rrBudget);
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setRRBudgetArray(budgetList.toArray(new RRBudgetDocument.RRBudget[0]));
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudgetDocument getRRBudget(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = this.stringToDom(subAwdXML);
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS("http://apply.grants.gov/forms/RR_Budget-V1.1", "RR_Budget");
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        try {
            byte[] subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            ByteArrayInputStream bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            return (RRBudgetDocument)RRBudgetDocument.Factory.parse((InputStream)bgtIS);
        }
        catch (IOException | XmlException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RRSubawardBudgetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public DocumentFactory<RRSubawardBudgetDocument> factory() {
        return RRSubawardBudgetDocument.Factory;
    }
}

