/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.ArrayList;
import org.aopalliance.aop.Advice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class KSBHttpInvokerProxyFactoryBean
extends HttpInvokerProxyFactoryBean {
    private static final Logger LOG = LogManager.getLogger(KSBHttpInvokerProxyFactoryBean.class);
    private Object serviceProxy;
    private JavaServiceConfiguration serviceConfiguration;

    public JavaServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public void setServiceConfiguration(JavaServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void afterPropertiesSet() {
        ProxyFactory proxyFactory = new ProxyFactory((Class[])this.getServiceInterfaces());
        proxyFactory.addAdvice((Advice)this);
        LOG.debug("Http proxying service " + String.valueOf(this.getServiceConfiguration()));
        this.serviceProxy = proxyFactory.getProxy();
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        Object o = this.getObject();
        return o != null ? this.getObject().getClass() : null;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?>[] getServiceInterfaces() {
        ArrayList serviceInterfaces = new ArrayList();
        try {
            for (String interfaceName : this.getServiceConfiguration().getServiceInterfaces()) {
                Class<?> clazz = Class.forName(interfaceName, true, ClassLoaderUtils.getDefaultClassLoader());
                LOG.debug("Adding service interface '" + String.valueOf(clazz) + "' to proxy object for service " + String.valueOf(this.getServiceConfiguration()));
                serviceInterfaces.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return serviceInterfaces.toArray(new Class[0]);
    }
}

