/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class ManualBufferSource
implements BufferSource {
    private final BufferSource parent;
    private final long maxCapacity;
    private long usage = 0L;
    private int created = 0;
    private int allocated = 0;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private int fails = 0;
    private int failedAllocation = 0;
    private final ArrayList<BufferWrapper> pool = new ArrayList();

    public ManualBufferSource(long maxCapacity) {
        this.parent = null;
        this.maxCapacity = maxCapacity;
    }

    public ManualBufferSource(BufferSource parent, long maxCapacity) {
        this.parent = parent;
        this.maxCapacity = maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getBuffer(int size) {
        ByteBuffer base;
        if (this.min > size) {
            this.min = size;
        }
        if (this.max < size) {
            this.max = size;
        }
        if ((long)size + this.usage > this.maxCapacity) {
            ++this.fails;
            return null;
        }
        ByteBuffer byteBuffer = base = this.parent != null ? this.parent.getBuffer(size) : null;
        if (base == null) {
            base = this.performAllocation(size);
            if (base == null) {
                ++this.failedAllocation;
            } else {
                this.allocated += base.capacity();
                ++this.created;
            }
        }
        if (base != null) {
            base.clear();
            if (base.remaining() != size) {
                base.limit(size);
            }
            ArrayList<BufferWrapper> arrayList = this.pool;
            synchronized (arrayList) {
                BufferWrapper wrap = new BufferWrapper(base);
                assert (!this.pool.contains(wrap));
                this.pool.add(wrap);
                this.usage += (long)base.capacity();
            }
        }
        return base;
    }

    protected abstract ByteBuffer performAllocation(int var1);

    @Override
    public void reclaim() {
        if (this.parent != null) {
            this.parent.reclaim();
        }
    }

    private long calculateUsage() {
        long val = 0L;
        for (BufferWrapper buffer : this.pool) {
            val += (long)buffer.capacity();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.hasArray()) {
            return;
        }
        ArrayList<BufferWrapper> arrayList = this.pool;
        synchronized (arrayList) {
            if (this.pool.remove(new BufferWrapper(buffer))) {
                this.usage -= (long)buffer.capacity();
                assert (this.usage == this.calculateUsage());
            } else if (this.parent != null) {
                this.parent.returnBuffer(buffer);
            }
        }
    }

    public String toString() {
        return "buffer pool created: " + this.created + " bytes held: " + this.usage + " capacity: " + this.maxCapacity + " min: " + this.min + " max: " + this.max + " overcommit: " + this.fails + " allocated: " + this.allocated + " failedAlloc: " + this.failedAllocation + " size: " + this.pool.size();
    }

    static class BufferWrapper {
        private final ByteBuffer check;

        BufferWrapper(ByteBuffer eq) {
            this.check = eq;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BufferWrapper) {
                return ((BufferWrapper)obj).check == this.check;
            }
            return super.equals(obj);
        }

        public int capacity() {
            return this.check.capacity();
        }
    }
}

