/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.SimpleBufferSource;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerIndex
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkerIndex.class);
    private final BufferSource source;
    private LongBuffer jumpIndex;
    private ByteBuffer returnBuffer;
    private volatile int cacheCount = 0;

    public MarkerIndex(BufferSource source) {
        if (source == null) {
            source = new SimpleBufferSource();
        }
        this.source = source;
    }

    public long position(int index) {
        if (this.jumpIndex == null) {
            return 0L;
        }
        return this.jumpIndex.get(2 * index);
    }

    public long mark(int index) {
        if (this.cacheCount > 0) {
            return this.jumpIndex.get(2 * index + 1);
        }
        return Long.MIN_VALUE;
    }

    public int size() {
        if (this.jumpIndex == null) {
            return 0;
        }
        return this.jumpIndex.position() / 2;
    }

    public void cache(int index, long mark) {
        ++this.cacheCount;
        this.jumpIndex.put(2 * index + 1, mark);
    }

    public final void append(long[] adding) {
        this.expand(adding.length);
        long[] lArray = adding;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long pos = lArray[i];
            this.jumpIndex.put(pos);
            this.jumpIndex.put(0L);
        }
    }

    public final void append(Collection<Long> adding) {
        this.expand(adding.size());
        for (Long pos : adding) {
            this.jumpIndex.put(pos);
            this.jumpIndex.put(0L);
        }
    }

    private void expand(int size) {
        ByteBuffer oldReturn = this.returnBuffer;
        if (this.jumpIndex == null || this.jumpIndex.remaining() < 2 * size) {
            LongBuffer newspace;
            int cap = 2 * size;
            if (this.jumpIndex != null) {
                cap += this.jumpIndex.position();
            }
            LOGGER.debug("expanding index to " + cap * 8);
            if (cap < 256) {
                this.returnBuffer = this.source.getBuffer(cap * 8);
                newspace = this.returnBuffer.asLongBuffer();
            } else {
                if (cap < 131072) {
                    cap = 131072;
                }
                LOGGER.debug("not using buffer source");
                try {
                    newspace = ByteBuffer.allocateDirect(cap * 8).asLongBuffer();
                }
                catch (OutOfMemoryError oome) {
                    newspace = ByteBuffer.allocate(cap * 8).asLongBuffer();
                }
                this.returnBuffer = null;
            }
            if (this.jumpIndex != null) {
                this.jumpIndex.flip();
                newspace.put(this.jumpIndex);
            }
            this.jumpIndex = newspace;
            if (oldReturn != null) {
                this.source.returnBuffer(oldReturn);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.source.returnBuffer(this.returnBuffer);
    }

    public String toString() {
        return "MarkerIndex{source=" + this.jumpIndex + ", cacheCount=" + this.cacheCount + '}';
    }
}

