/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectComplete;
import org.kuali.rice.kim.api.role.RoleContract;
import org.w3c.dom.Element;

@XmlRootElement(name="role")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoleType", propOrder={"id", "name", "namespaceCode", "description", "kimTypeId", "active", "versionNumber", "objectId", "_futureElements"})
public final class Role
extends AbstractDataTransferObject
implements RoleContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="description")
    private final String description;
    @XmlElement(name="kimTypeId", required=true)
    private final String kimTypeId;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber")
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Role() {
        this.id = null;
        this.name = null;
        this.namespaceCode = null;
        this.description = null;
        this.kimTypeId = null;
        this.active = false;
        this.objectId = null;
        this.versionNumber = null;
    }

    private Role(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespaceCode = builder.getNamespaceCode();
        this.description = builder.getDescription();
        this.kimTypeId = builder.getKimTypeId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public static final class Builder
    implements RoleContract,
    ModelBuilder,
    ModelObjectComplete {
        private String id;
        private String name;
        private String namespaceCode;
        private String description;
        private String kimTypeId;
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String id, String name, String namespaceCode, String description, String kimTypeId) {
            Builder b = new Builder();
            b.setId(id);
            b.setName(name);
            b.setNamespaceCode(namespaceCode);
            b.setDescription(description);
            b.setKimTypeId(kimTypeId);
            b.setActive(true);
            return b;
        }

        public static Builder create(RoleContract roleContract) {
            Builder b = new Builder();
            b.setId(roleContract.getId());
            b.setName(roleContract.getName());
            b.setNamespaceCode(roleContract.getNamespaceCode());
            b.setDescription(roleContract.getDescription());
            b.setKimTypeId(roleContract.getKimTypeId());
            b.setActive(roleContract.isActive());
            b.setVersionNumber(roleContract.getVersionNumber());
            b.setObjectId(roleContract.getObjectId());
            return b;
        }

        public Role build() {
            return new Role(this);
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id cannot be blank");
            }
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode cannot be blank or null");
            }
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name cannot be blank or null");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setKimTypeId(String kimTypeId) {
            if (StringUtils.isBlank((String)kimTypeId)) {
                throw new IllegalArgumentException("kimTypeId cannot be blank or null");
            }
            this.kimTypeId = kimTypeId;
        }

        @Override
        public String getKimTypeId() {
            return this.kimTypeId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/RoleType";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "role";
        static final String TYPE_NAME = "RoleType";

        Constants() {
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String ACTIVE = "active";

        Elements() {
        }
    }
}

