/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.subphase.highlight.AbstractHighlighterBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class HighlightBuilder
extends AbstractHighlighterBuilder<HighlightBuilder> {
    public static final boolean DEFAULT_FORCE_SOURCE = false;
    public static final boolean DEFAULT_REQUIRE_FIELD_MATCH = true;
    public static final Integer DEFAULT_MAX_ANALYZED_OFFSET = null;
    public static final boolean DEFAULT_HIGHLIGHT_FILTER = false;
    public static final boolean DEFAULT_SCORE_ORDERED = false;
    public static final String DEFAULT_ENCODER = "default";
    public static final int DEFAULT_PHRASE_LIMIT = 256;
    public static final int DEFAULT_NO_MATCH_SIZE = 0;
    public static final int DEFAULT_NUMBER_OF_FRAGMENTS = 5;
    public static final int DEFAULT_FRAGMENT_CHAR_SIZE = 100;
    static final String[] DEFAULT_PRE_TAGS = new String[]{"<em>"};
    static final String[] DEFAULT_POST_TAGS = new String[]{"</em>"};
    public static final String[] DEFAULT_STYLED_PRE_TAG = new String[]{"<em class=\"hlt1\">", "<em class=\"hlt2\">", "<em class=\"hlt3\">", "<em class=\"hlt4\">", "<em class=\"hlt5\">", "<em class=\"hlt6\">", "<em class=\"hlt7\">", "<em class=\"hlt8\">", "<em class=\"hlt9\">", "<em class=\"hlt10\">"};
    public static final String[] DEFAULT_STYLED_POST_TAGS = new String[]{"</em>"};
    static final SearchHighlightContext.FieldOptions defaultOptions = new SearchHighlightContext.FieldOptions.Builder().preTags(DEFAULT_PRE_TAGS).postTags(DEFAULT_POST_TAGS).scoreOrdered(false).highlightFilter(false).requireFieldMatch(true).maxAnalyzedOffset(DEFAULT_MAX_ANALYZED_OFFSET).forceSource(false).fragmentCharSize(100).numberOfFragments(5).encoder("default").boundaryMaxScan(20).boundaryChars(SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS).boundaryScannerLocale(Locale.ROOT).noMatchSize(0).phraseLimit(256).build();
    private final List<Field> fields;
    private String encoder;
    private boolean useExplicitFieldOrder = false;
    private static final BiFunction<XContentParser, HighlightBuilder, HighlightBuilder> PARSER;

    public HighlightBuilder() {
        this.fields = new ArrayList<Field>();
    }

    public HighlightBuilder(HighlightBuilder template, QueryBuilder highlightQuery, List<Field> fields) {
        super(template, highlightQuery);
        this.encoder = template.encoder;
        this.useExplicitFieldOrder = template.useExplicitFieldOrder;
        this.fields = fields;
    }

    public HighlightBuilder(StreamInput in) throws IOException {
        super(in);
        this.encoder(in.readOptionalString());
        this.useExplicitFieldOrder(in.readBoolean());
        this.fields = in.readList(Field::new);
        assert (this.equals(new HighlightBuilder(this, this.highlightQuery, this.fields))) : "copy constructor is broken";
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.encoder);
        out.writeBoolean(this.useExplicitFieldOrder);
        out.writeList(this.fields);
    }

    public HighlightBuilder field(String name) {
        return this.field(new Field(name));
    }

    public HighlightBuilder field(String name, int fragmentSize) {
        return this.field((Field)new Field(name).fragmentSize(fragmentSize));
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments) {
        return this.field((Field)((Field)new Field(name).fragmentSize(fragmentSize)).numOfFragments(numberOfFragments));
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        return this.field(((Field)((Field)new Field(name).fragmentSize(fragmentSize)).numOfFragments(numberOfFragments)).fragmentOffset(fragmentOffset));
    }

    public HighlightBuilder field(Field field) {
        this.fields.add(field);
        return this;
    }

    void fields(List<Field> fields) {
        this.fields.addAll(fields);
    }

    public List<Field> fields() {
        return this.fields;
    }

    public HighlightBuilder tagsSchema(String schemaName) {
        switch (schemaName) {
            case "default": {
                this.preTags(DEFAULT_PRE_TAGS);
                this.postTags(DEFAULT_POST_TAGS);
                break;
            }
            case "styled": {
                this.preTags(DEFAULT_STYLED_PRE_TAG);
                this.postTags(DEFAULT_STYLED_POST_TAGS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tag schema [" + schemaName + "]");
            }
        }
        return this;
    }

    public HighlightBuilder encoder(String encoder) {
        this.encoder = encoder;
        return this;
    }

    public String encoder() {
        return this.encoder;
    }

    public HighlightBuilder useExplicitFieldOrder(boolean useExplicitFieldOrder) {
        this.useExplicitFieldOrder = useExplicitFieldOrder;
        return this;
    }

    public Boolean useExplicitFieldOrder() {
        return this.useExplicitFieldOrder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXContent(builder);
        builder.endObject();
        return builder;
    }

    public static HighlightBuilder fromXContent(XContentParser p) {
        return PARSER.apply(p, new HighlightBuilder());
    }

    public SearchHighlightContext build(SearchExecutionContext context) throws IOException {
        SearchHighlightContext.FieldOptions.Builder globalOptionsBuilder = new SearchHighlightContext.FieldOptions.Builder();
        globalOptionsBuilder.encoder(this.encoder);
        HighlightBuilder.transferOptions(this, globalOptionsBuilder, context);
        globalOptionsBuilder.merge(defaultOptions);
        ArrayList<SearchHighlightContext.Field> fieldOptions = new ArrayList<SearchHighlightContext.Field>();
        for (Field field : this.fields) {
            SearchHighlightContext.FieldOptions.Builder fieldOptionsBuilder = new SearchHighlightContext.FieldOptions.Builder();
            fieldOptionsBuilder.fragmentOffset(field.fragmentOffset);
            if (field.matchedFields != null) {
                HashSet<String> matchedFields = new HashSet<String>(field.matchedFields.length);
                Collections.addAll(matchedFields, field.matchedFields);
                fieldOptionsBuilder.matchedFields(matchedFields);
            }
            HighlightBuilder.transferOptions(field, fieldOptionsBuilder, context);
            fieldOptions.add(new SearchHighlightContext.Field(field.name(), fieldOptionsBuilder.merge(globalOptionsBuilder.build()).build()));
        }
        return new SearchHighlightContext(fieldOptions);
    }

    private static void transferOptions(AbstractHighlighterBuilder highlighterBuilder, SearchHighlightContext.FieldOptions.Builder targetOptionsBuilder, SearchExecutionContext context) throws IOException {
        if (highlighterBuilder.preTags != null) {
            targetOptionsBuilder.preTags(highlighterBuilder.preTags);
        }
        if (highlighterBuilder.postTags != null) {
            targetOptionsBuilder.postTags(highlighterBuilder.postTags);
        }
        if (highlighterBuilder.order != null) {
            targetOptionsBuilder.scoreOrdered(highlighterBuilder.order == Order.SCORE);
        }
        if (highlighterBuilder.highlightFilter != null) {
            targetOptionsBuilder.highlightFilter(highlighterBuilder.highlightFilter);
        }
        if (highlighterBuilder.fragmentSize != null) {
            targetOptionsBuilder.fragmentCharSize(highlighterBuilder.fragmentSize);
        }
        if (highlighterBuilder.numOfFragments != null) {
            targetOptionsBuilder.numberOfFragments(highlighterBuilder.numOfFragments);
        }
        if (highlighterBuilder.requireFieldMatch != null) {
            targetOptionsBuilder.requireFieldMatch(highlighterBuilder.requireFieldMatch);
        }
        if (highlighterBuilder.maxAnalyzedOffset != null) {
            targetOptionsBuilder.maxAnalyzedOffset(highlighterBuilder.maxAnalyzedOffset);
        }
        if (highlighterBuilder.boundaryScannerType != null) {
            targetOptionsBuilder.boundaryScannerType(highlighterBuilder.boundaryScannerType);
        }
        if (highlighterBuilder.boundaryMaxScan != null) {
            targetOptionsBuilder.boundaryMaxScan(highlighterBuilder.boundaryMaxScan);
        }
        if (highlighterBuilder.boundaryChars != null) {
            targetOptionsBuilder.boundaryChars(HighlightBuilder.convertCharArray(highlighterBuilder.boundaryChars));
        }
        if (highlighterBuilder.boundaryScannerLocale != null) {
            targetOptionsBuilder.boundaryScannerLocale(highlighterBuilder.boundaryScannerLocale);
        }
        if (highlighterBuilder.highlighterType != null) {
            targetOptionsBuilder.highlighterType(highlighterBuilder.highlighterType);
        }
        if (highlighterBuilder.fragmenter != null) {
            targetOptionsBuilder.fragmenter(highlighterBuilder.fragmenter);
        }
        if (highlighterBuilder.noMatchSize != null) {
            targetOptionsBuilder.noMatchSize(highlighterBuilder.noMatchSize);
        }
        if (highlighterBuilder.forceSource != null) {
            targetOptionsBuilder.forceSource(highlighterBuilder.forceSource);
        }
        if (highlighterBuilder.phraseLimit != null) {
            targetOptionsBuilder.phraseLimit(highlighterBuilder.phraseLimit);
        }
        if (highlighterBuilder.options != null) {
            targetOptionsBuilder.options(highlighterBuilder.options);
        }
        if (highlighterBuilder.highlightQuery != null) {
            targetOptionsBuilder.highlightQuery(highlighterBuilder.highlightQuery.toQuery(context));
        }
    }

    static Character[] convertCharArray(char[] array) {
        if (array == null) {
            return null;
        }
        Character[] charArray = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            charArray[i] = Character.valueOf(array[i]);
        }
        return charArray;
    }

    @Override
    public void innerXContent(XContentBuilder builder) throws IOException {
        this.commonOptionsToXContent(builder);
        if (this.encoder != null) {
            builder.field(ENCODER_FIELD.getPreferredName(), this.encoder);
        }
        if (this.fields.size() > 0) {
            if (this.useExplicitFieldOrder) {
                builder.startArray(FIELDS_FIELD.getPreferredName());
            } else {
                builder.startObject(FIELDS_FIELD.getPreferredName());
            }
            for (Field field : this.fields) {
                if (this.useExplicitFieldOrder) {
                    builder.startObject();
                }
                field.innerXContent(builder);
                if (!this.useExplicitFieldOrder) continue;
                builder.endObject();
            }
            if (this.useExplicitFieldOrder) {
                builder.endArray();
            } else {
                builder.endObject();
            }
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.encoder, this.useExplicitFieldOrder, this.fields);
    }

    @Override
    protected boolean doEquals(HighlightBuilder other) {
        return Objects.equals(this.encoder, other.encoder) && Objects.equals(this.useExplicitFieldOrder, other.useExplicitFieldOrder) && Objects.equals(this.fields, other.fields);
    }

    @Override
    public HighlightBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryBuilder highlightQuery = this.highlightQuery;
        if (highlightQuery != null) {
            highlightQuery = this.highlightQuery.rewrite(ctx);
        }
        List<Field> fields = Rewriteable.rewrite(this.fields, ctx);
        if (highlightQuery == this.highlightQuery && fields == this.fields) {
            return this;
        }
        return new HighlightBuilder(this, highlightQuery, fields);
    }

    static {
        ObjectParser parser = new ObjectParser("highlight");
        parser.declareString(HighlightBuilder::tagsSchema, new ParseField("tags_schema", new String[0]));
        parser.declareString(HighlightBuilder::encoder, ENCODER_FIELD);
        parser.declareNamedObjects(HighlightBuilder::fields, Field.PARSER, hb -> hb.useExplicitFieldOrder(true), FIELDS_FIELD);
        PARSER = HighlightBuilder.setupParser(parser);
    }

    public static class Field
    extends AbstractHighlighterBuilder<Field> {
        static final ObjectParser.NamedObjectParser<Field, Void> PARSER;
        private final String name;
        int fragmentOffset = -1;
        String[] matchedFields;

        public Field(String name) {
            this.name = name;
        }

        private Field(Field template, QueryBuilder builder) {
            super(template, builder);
            this.name = template.name;
            this.fragmentOffset = template.fragmentOffset;
            this.matchedFields = template.matchedFields;
        }

        public Field(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.fragmentOffset(in.readVInt());
            this.matchedFields(in.readOptionalStringArray());
            assert (this.equals(new Field(this, this.highlightQuery))) : "copy constructor is broken";
        }

        @Override
        protected void doWriteTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVInt(this.fragmentOffset);
            out.writeOptionalStringArray(this.matchedFields);
        }

        public String name() {
            return this.name;
        }

        public Field fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Field matchedFields(String ... matchedFields) {
            this.matchedFields = matchedFields;
            return this;
        }

        @Override
        public void innerXContent(XContentBuilder builder) throws IOException {
            builder.startObject(this.name);
            this.commonOptionsToXContent(builder);
            if (this.fragmentOffset != -1) {
                builder.field(FRAGMENT_OFFSET_FIELD.getPreferredName(), this.fragmentOffset);
            }
            if (this.matchedFields != null) {
                builder.array(MATCHED_FIELDS_FIELD.getPreferredName(), this.matchedFields);
            }
            builder.endObject();
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(this.name, this.fragmentOffset, Arrays.hashCode(this.matchedFields));
        }

        @Override
        protected boolean doEquals(Field other) {
            return Objects.equals(this.name, other.name) && Objects.equals(this.fragmentOffset, other.fragmentOffset) && Arrays.equals(this.matchedFields, other.matchedFields);
        }

        @Override
        public Field rewrite(QueryRewriteContext ctx) throws IOException {
            QueryBuilder rewrite;
            if (this.highlightQuery != null && (rewrite = this.highlightQuery.rewrite(ctx)) != this.highlightQuery) {
                return new Field(this, rewrite);
            }
            return this;
        }

        static {
            ObjectParser parser = new ObjectParser("highlight_field");
            parser.declareInt(Field::fragmentOffset, FRAGMENT_OFFSET_FIELD);
            parser.declareStringArray(ObjectParser.fromList(String.class, Field::matchedFields), MATCHED_FIELDS_FIELD);
            BiFunction decoratedParser = Field.setupParser(parser);
            PARSER = (p, c, name) -> (Field)decoratedParser.apply(p, new Field(name));
        }
    }

    public static enum Order implements Writeable
    {
        NONE,
        SCORE;


        public static Order readFromStream(StreamInput in) throws IOException {
            return in.readEnum(Order.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public static Order fromString(String order) {
            if (order.toUpperCase(Locale.ROOT).equals(SCORE.name())) {
                return SCORE;
            }
            return NONE;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum BoundaryScannerType implements Writeable
    {
        CHARS,
        WORD,
        SENTENCE;


        public static BoundaryScannerType readFromStream(StreamInput in) throws IOException {
            return in.readEnum(BoundaryScannerType.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public static BoundaryScannerType fromString(String boundaryScannerType) {
            return BoundaryScannerType.valueOf(boundaryScannerType.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

