<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0"
                xmlns:ED_GEPA427="http://apply.grants.gov/forms/ED_GEPA427_2_0-V2.0"
>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.5in"
                                   margin-right="0.5in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.5in"/>
                <fo:region-after extent=".5in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="ED_GEPA427:ED_GEPA427_2_0">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-after">
                    <fo:block>
                        <fo:inline font-size="6px" font-weight="bold">
                            Tracking Number:
                            <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                        </fo:inline>
                    </fo:block>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <fo:block>

                        <fo:table padding="0" width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column/>
                            <fo:table-column column-width="20pt"/>
                            <fo:table-column/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" text-align="right" padding-start="3pt"
                                                   padding-end="3pt" padding-before="3pt" padding-after="3pt"
                                                   display-align="center" border-style="solid" border-width="1pt"
                                                   border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="6px">OMB Control No. 1894-0005 (Exp. 02/28/2026)
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" text-align="center" padding-start="3pt"
                                                   padding-end="3pt" padding-before="3pt" padding-after="3pt"
                                                   display-align="center" border-style="solid" border-width="1pt"
                                                   border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="12px" font-weight="bold">NOTICE TO ALL APPLICANTS:
                                                EQUITY FOR STUDENTS, EDUCATORS, AND OTHER PROGRAM
                                                BENEFICIARIES
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell display-align="before" text-align="justify" padding-start="3pt"
                                                   padding-end="3pt" padding-before="3pt" padding-after="3pt"
                                                   border-style="solid" border-width="1pt" border-color="white"
                                                   number-columns-spanned="3">
                                        <fo:block>
                                            <fo:inline>Section 427 of the General Education Provisions
                                                Act (GEPA) (20 U.S.C. 1228a) applies to applicants for grant
                                                awards under this program.
                                            </fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline font-weight="bold">
                                                ALL APPLICANTS FOR NEW GRANT AWARDS MUST INCLUDE THE FOLLOWING
                                                INFORMATION IN
                                                THEIR APPLICATIONS TO ADDRESS THIS PROVISION IN ORDER TO RECEIVE FUNDING
                                                UNDER THIS
                                                PROGRAM.
                                            </fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline>
                                                Please respond to the following requests for information. Responses are
                                                limited to 4,000 characters.
                                            </fo:inline>

                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-before="3pt" padding-after="3pt">
                                        <fo:block>
                                            <fo:inline>
                                                1. Describe how your entity’s existing mission, policies, or commitments
                                                ensure equitable access to, and equitable
                                                participation in, the proposed project or activity.
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell hyphenate="true" language="EN" border-width="1pt"
                                                   border-color="black" padding-start="3pt" padding-end="3pt"
                                                   padding-after="3pt" padding-before="3pt" border-style="solid"
                                                   number-columns-spanned="3">
                                        <fo:block wrap-option="wrap" hyphenate="true">
                                            <xsl:value-of select="ED_GEPA427:EnsureEquitableAccess"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-before="3pt" padding-after="3pt">
                                        <fo:block>
                                            <fo:inline>
                                                2. Based on your proposed project or activity, what barriers may impede
                                                equitable access and participation of
                                                students, educators, or other beneficiaries?
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell hyphenate="true" language="EN" border-width="1pt"
                                                   border-color="black" padding-start="3pt" padding-end="3pt"
                                                   padding-after="3pt" padding-before="3pt" border-style="solid"
                                                   number-columns-spanned="3">
                                        <fo:block wrap-option="wrap" hyphenate="true">
                                            <xsl:value-of select="ED_GEPA427:Barriers"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-before="3pt" padding-after="3pt">
                                        <fo:block>
                                            <fo:inline>
                                                3. Based on the barriers identified, what steps will you take to address
                                                such barriers to equitable access and
                                                participation in the proposed project or activity?
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell hyphenate="true" language="EN" border-width="1pt"
                                                   border-color="black" padding-start="3pt" padding-end="3pt"
                                                   padding-after="3pt" padding-before="3pt" border-style="solid"
                                                   number-columns-spanned="3">
                                        <fo:block wrap-option="wrap" hyphenate="true">
                                            <xsl:value-of select="ED_GEPA427:Steps"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" padding-before="3pt" padding-after="3pt">
                                        <fo:block>
                                            <fo:inline>
                                                4. What is your timeline, including targeted milestones, for addressing
                                                these identified barriers?
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell hyphenate="true" language="EN" border-width="1pt"
                                                   border-color="black" padding-start="3pt" padding-end="3pt"
                                                   padding-after="3pt" padding-before="3pt" border-style="solid"
                                                   number-columns-spanned="3">
                                        <fo:block wrap-option="wrap" hyphenate="true">
                                            <xsl:value-of select="ED_GEPA427:Timeline"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3" text-align="justify" padding-start="3pt"
                                                   padding-end="3pt" padding-before="3pt" padding-after="3pt"
                                                   display-align="center" border-style="solid" border-width="1pt"
                                                   border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="12px" font-weight="bold">Notes:</fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline>
                                                1. Applicants are not required to have mission statements or policies
                                                that align with equity in order to
                                                submit an application.
                                            </fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline>
                                                2. Applicants may identify any barriers that may impede equitable access
                                                and participation in the
                                                proposed project or activity, including, but not limited to, barriers
                                                based on economic disadvantage,
                                                gender, race, ethnicity, color, national origin, disability, age,
                                                language, migrant status, rural status,
                                                homeless status or housing insecurity, pregnancy, parenting, or
                                                caregiving status, and sexual orientation.
                                            </fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline>
                                                3. Applicants may have already included some or all of this required
                                                information in the narrative sections
                                                of their applications or their State Plans. In responding to this
                                                requirement, for each question, applicants
                                                may provide a cross-reference to the section(s) and page number(s) in
                                                their applications or State Plans
                                                that includes the information responsive to that question on this form
                                                or may restate that information on
                                                this form.
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell border-width="1pt" border-color="black" padding-start="3pt"
                                                   padding-end="3pt" padding-after="3pt" padding-before="3pt"
                                                   border-style="solid" number-columns-spanned="3">
                                        <fo:block>
                                            <fo:inline font-size="12px" font-weight="bold">Paperwork Burden Statement
                                            </fo:inline>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline>
                                                According to the Paperwork Reduction Act of 1995, no persons are
                                                required to respond to a collection of
                                                information unless such collection displays a valid OMB control number.
                                                The valid OMB control number
                                                for this information collection is 1894-0005. Public reporting burden
                                                for this collection of information is
                                                estimated to average 3 hours per response, including time for reviewing
                                                instructions, searching existing
                                                data sources, gathering, and maintaining the data needed, and completing
                                                and reviewing the collection of
                                                information. The obligation to respond to this collection is required to
                                                obtain or retain a benefit. If you have
                                                any comments concerning the accuracy of the time estimate or suggestions
                                                for improving this individual
                                                collection, send your comments to ICDocketMgr@ed.gov and reference OMB
                                                Control Number
                                                1894-0005. All other comments or concerns regarding the status of your
                                                individual form may be
                                                addressed to either (a) the person listed in the FOR FURTHER INFORMATION
                                                CONTACT section in the
                                                competition Notice Inviting Applications, or (b) your assigned program
                                                officer.
                                            </fo:inline>

                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
</xsl:stylesheet>
