/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.var;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SetVarNode
implements SimpleNode {
    private static final Logger LOG = LogManager.getLogger(SetVarNode.class);

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        LOG.debug("processing");
        DocumentBuilder db = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder();
        String contentFragment = context.getNodeInstance().getRouteNode().getContentFragment();
        LOG.debug("contentFragment=" + contentFragment);
        Document d = db.parse(new InputSource(new StringReader(contentFragment)));
        Element e = d.getDocumentElement();
        String name = e.getElementsByTagName("name").item(0).getTextContent();
        if (name == null) {
            throw new XmlException("SetVar node required 'name' attribute to be specified");
        }
        String valueRef = e.getElementsByTagName("value").item(0).getTextContent();
        Object retrievedVal = PropertiesUtil.retrieveProperty(valueRef, PropertyScheme.LITERAL_SCHEME, context);
        LOG.debug("retrieved value '" + String.valueOf(retrievedVal) + " for value '" + valueRef);
        String stringVal = null;
        if (retrievedVal != null && (stringVal = retrievedVal.toString()).length() > 255) {
            stringVal = stringVal.substring(0, 255);
        }
        LOG.debug("setting value '" + stringVal + "' for variable " + name);
        KEWServiceLocator.getBranchService().setScopedVariableValue(context.getNodeInstance().getBranch(), "var::" + name, stringVal);
        return new SimpleResult(true);
    }
}

