/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorizer;

import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizerBase;
import org.kuali.kra.award.budget.document.authorizer.BudgetTask;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;

public abstract class BudgetAuthorizer
extends TaskAuthorizerBase {
    private KcAuthorizationService kraAuthorizationService;
    private boolean requiresWritableDoc = false;

    @Override
    public boolean isAuthorized(String userId, Task task) {
        BudgetTask budgetTask = (BudgetTask)task;
        if (this.isRequiresWritableDoc() && budgetTask.getBudget().isViewOnly().booleanValue()) {
            return false;
        }
        return this.isAuthorized(userId, budgetTask);
    }

    public boolean isAuthorized(String userId, BudgetTask task) {
        return true;
    }

    public final void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public boolean isRequiresWritableDoc() {
        return this.requiresWritableDoc;
    }

    public void setRequiresWritableDoc(boolean requiresWritableDoc) {
        this.requiresWritableDoc = requiresWritableDoc;
    }
}

