/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.kra.award.cgb.AwardCgbConstants;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.external.award.AwardDTO;
import org.kuali.kra.external.award.ProposalDTO;
import org.kuali.kra.external.awardpayment.AwardMethodOfPaymentDTO;
import org.kuali.kra.external.frequency.FrequencyDto;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.kra.external.service.KcDtoServiceBase;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardDtoService
extends KcDtoServiceBase<AwardDTO, Award> {
    public static final String FUND_MANAGER_TYPE_CODE_PARAM = "FIN_SYS_UNIT_ADMIN_TYPE_FUND_MANAGER";
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private KcDtoService<ProposalDTO, InstitutionalProposal> proposalDtoService;
    private KcDtoService<SponsorDTO, Sponsor> sponsorDtoService;
    private KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> awardMethodOfPaymentDtoService;
    private KcDtoService<FrequencyDto, Frequency> frequencyDtoService;

    @Override
    public AwardDTO buildDto(Award award) {
        if (award != null) {
            AwardDTO dto = new AwardDTO();
            dto.setAwardId(award.getAwardId());
            dto.setAwardNumber(award.getAwardNumber());
            dto.setAwardStartDate(award.getBeginDate());
            dto.setAwardEndDate(award.getLastAwardAmountInfo().getFinalExpirationDate());
            dto.setAwardTotalAmount(award.getLastAwardAmountInfo().getObliDistributableAmount().bigDecimalValue());
            dto.setAwardDocumentNumber(award.getDocumentKey());
            dto.setAwardLastUpdateDate(award.getUpdateTimestamp());
            dto.setAwardDirectCostAmount(award.getLastAwardAmountInfo().getObligatedTotalDirect().bigDecimalValue());
            dto.setAwardIndirectCostAmount(award.getLastAwardAmountInfo().getObligatedTotalIndirect().bigDecimalValue());
            dto.setProposalAwardTypeCode(award.getAwardTypeCode().toString());
            dto.setAwardStatusCode(award.getStatusCode().toString());
            dto.setSponsorCode(award.getSponsorCode());
            dto.setTitle(award.getTitle());
            dto.setUnitNumber(award.getLeadUnitNumber());
            dto.setAwardCommentText(award.getAwardGeneralComments().getComments());
            dto.setPrincipalInvestigatorId(award.getPrincipalInvestigator().getPersonId());
            dto.setAdditionalFormsRequired(award.getAwardCgb().isAdditionalFormsRequired());
            dto.setAutoApproveInvoice(award.getAwardCgb().isAutoApproveInvoice());
            dto.setStopWork(award.getAwardCgb().isStopWork());
            dto.setInvoicingOption(award.getAwardCgb().getInvoicingOption());
            dto.setInvoicingOptionDescription(AwardCgbConstants.InvoicingOptions.Types.get(award.getAwardCgb().getInvoicingOption()));
            dto.setDunningCampaignId(award.getAwardCgb().getDunningCampaignId());
            dto.setAdditionalFormsDescription(award.getAdditionalFormsDescriptionComment().getComments());
            dto.setStopWorkReason(award.getStopWorkReasonComment().getComments());
            dto.setMinInvoiceAmount(award.getAwardCgb().getMinInvoiceAmount() != null ? award.getAwardCgb().getMinInvoiceAmount().bigDecimalValue() : null);
            dto.setExcludedFromInvoicing(award.getAwardCgb().isSuspendInvoicing());
            dto.setExcludedFromInvoicingReason(award.getSuspendInvoicingComment().getComments());
            dto.setMethodOfPayment(this.awardMethodOfPaymentDtoService.buildDto(award.getAwardMethodOfPayment()));
            if (award.getFundingProposals() != null && !award.getFundingProposals().isEmpty()) {
                InstitutionalProposal instProp = (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)award.getFundingProposals().get(0).getProposalId());
                dto.setProposal(this.proposalDtoService.buildDto(instProp));
            }
            if (award.getSponsor() == null) {
                return null;
            }
            dto.setSponsor(this.sponsorDtoService.buildDto(award.getSponsor()));
            String fundManagerTypeCode = this.getParameterService().getParameterValueAsString(Award.class, FUND_MANAGER_TYPE_CODE_PARAM);
            for (AwardUnitContact contact : award.getAwardUnitContacts()) {
                if (!StringUtils.equals((CharSequence)contact.getUnitAdministratorTypeCode(), (CharSequence)fundManagerTypeCode)) continue;
                dto.setFundManagerId(contact.getPersonId());
            }
            String invoiceReportDesc = this.getParameterService().getParameterValueAsString(Award.class, "FIN_SYS_INVOICE_REPORT_DESC");
            for (AwardReportTerm reportItem : award.getAwardReportTermItems()) {
                if (!StringUtils.equals((CharSequence)invoiceReportDesc, (CharSequence)reportItem.getReport().getDescription())) continue;
                dto.setInvoiceBillingFrequency(this.frequencyDtoService.buildDto(reportItem.getFrequency()));
            }
            return dto;
        }
        return null;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected KcDtoService<ProposalDTO, InstitutionalProposal> getProposalDtoService() {
        return this.proposalDtoService;
    }

    public void setProposalDtoService(KcDtoService<ProposalDTO, InstitutionalProposal> proposalDtoService) {
        this.proposalDtoService = proposalDtoService;
    }

    protected KcDtoService<SponsorDTO, Sponsor> getSponsorDtoService() {
        return this.sponsorDtoService;
    }

    public void setSponsorDtoService(KcDtoService<SponsorDTO, Sponsor> sponsorDtoService) {
        this.sponsorDtoService = sponsorDtoService;
    }

    protected KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> getAwardMethodOfPaymentDtoService() {
        return this.awardMethodOfPaymentDtoService;
    }

    public void setAwardMethodOfPaymentDtoService(KcDtoService<AwardMethodOfPaymentDTO, AwardMethodOfPayment> awardMethodOfPaymentDtoService) {
        this.awardMethodOfPaymentDtoService = awardMethodOfPaymentDtoService;
    }

    public KcDtoService<FrequencyDto, Frequency> getFrequencyDtoService() {
        return this.frequencyDtoService;
    }

    public void setFrequencyDtoService(KcDtoService<FrequencyDto, Frequency> frequencyDtoService) {
        this.frequencyDtoService = frequencyDtoService;
    }
}

