/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.jpa.JpaMetadataProvider;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectCollection;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeRelationshipImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectCollectionImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectMetadataImpl;
import org.kuali.rice.krad.data.metadata.impl.DataObjectRelationshipImpl;
import org.kuali.rice.krad.data.provider.annotation.ExtensionFor;
import org.kuali.rice.krad.data.provider.impl.MetadataProviderBase;

public abstract class JpaMetadataProviderImpl
extends MetadataProviderBase
implements JpaMetadataProvider {
    private static final Logger LOG = LogManager.getLogger(JpaMetadataProviderImpl.class);
    protected EntityManager entityManager;

    protected abstract void populateImplementationSpecificEntityLevelMetadata(DataObjectMetadataImpl var1, EntityType<?> var2);

    protected abstract void populateImplementationSpecificAttributeLevelMetadata(DataObjectAttributeImpl var1, SingularAttribute<?, ?> var2);

    protected abstract void populateImplementationSpecificCollectionLevelMetadata(DataObjectCollectionImpl var1, PluralAttribute<?, ?, ?> var2);

    protected abstract void populateImplementationSpecificRelationshipLevelMetadata(DataObjectRelationshipImpl var1, SingularAttribute<?, ?> var2);

    @Override
    public abstract DataObjectRelationship addExtensionRelationship(Class<?> var1, String var2, Class<?> var3);

    @Override
    protected synchronized void initializeMetadata(Collection<Class<?>> types) {
        LOG.info("Initializing JPA Metadata from " + String.valueOf(this.entityManager));
        this.masterMetadataMap.clear();
        for (IdentifiableType identifiableType : this.entityManager.getMetamodel().getEntities()) {
            if (!(identifiableType instanceof EntityType)) continue;
            EntityType type = (EntityType)identifiableType;
            try {
                this.masterMetadataMap.put(type.getBindableJavaType(), this.getMetadataForClass(type.getBindableJavaType()));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Added Metadata For: " + String.valueOf(type.getBindableJavaType()));
            }
            catch (Exception ex) {
                LOG.error("Error obtaining JPA metadata for type: " + String.valueOf(type.getJavaType()), (Throwable)ex);
            }
        }
    }

    public DataObjectMetadata getMetadataForClass(Class<?> persistableClass) {
        EntityType entityType2;
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        HashMap extensionMap = new HashMap();
        for (EntityType entityType2 : this.getEntityManager().getMetamodel().getEntities()) {
            ExtensionFor extensionFor;
            if (!entityType2.getJavaType().isAnnotationPresent(ExtensionFor.class) || !(extensionFor = entityType2.getJavaType().getAnnotation(ExtensionFor.class)).value().equals(persistableClass)) continue;
            DataObjectRelationship relationship = this.addExtensionRelationship(persistableClass, extensionFor.extensionPropertyName(), entityType2.getJavaType());
            relationships.add(relationship);
        }
        DataObjectMetadataImpl metadata = new DataObjectMetadataImpl();
        entityType2 = this.entityManager.getMetamodel().entity(persistableClass);
        metadata.setProviderName(this.getClass().getSimpleName());
        metadata.setType(persistableClass);
        metadata.setName(persistableClass.getSimpleName());
        metadata.setReadOnly(false);
        metadata.setSupportsOptimisticLocking(entityType2.hasVersionAttribute());
        this.populateImplementationSpecificEntityLevelMetadata(metadata, entityType2);
        try {
            metadata.setPrimaryKeyAttributeNames(this.getPrimaryKeyAttributeNames(entityType2));
        }
        catch (RuntimeException ex) {
            LOG.error("Error processing PK metadata for " + entityType2.getBindableJavaType().getName());
            throw new RuntimeException("Error processing PK metadata for " + entityType2.getBindableJavaType().getName(), ex);
        }
        try {
            List<DataObjectAttribute> attributes = this.getSingularAttributes(persistableClass, entityType2.getSingularAttributes(), metadata.getPrimaryKeyAttributeNames());
            for (DataObjectAttribute attr : attributes) {
                metadata.getOrderedAttributeList().add(attr.getName());
            }
            metadata.setAttributes(attributes);
        }
        catch (RuntimeException ex) {
            LOG.error("Error processing attribute metadata for " + entityType2.getBindableJavaType().getName());
            throw ex;
        }
        try {
            metadata.setCollections(this.getCollectionsFromMetadata(entityType2.getPluralAttributes()));
        }
        catch (RuntimeException ex) {
            LOG.error("Error processing collection metadata for " + entityType2.getBindableJavaType().getName());
            throw ex;
        }
        try {
            relationships.addAll(this.getRelationships(entityType2.getSingularAttributes()));
            metadata.setRelationships(relationships);
        }
        catch (RuntimeException ex) {
            LOG.error("Error processing relationship metadata for " + entityType2.getBindableJavaType().getName());
            throw ex;
        }
        return metadata;
    }

    protected List<String> getPrimaryKeyAttributeNames(EntityType<?> entityType) {
        ArrayList<String> primaryKeyAttributeNames = new ArrayList<String>();
        if (entityType.getIdType() instanceof EmbeddableType) {
            for (Field pkField : entityType.getIdType().getJavaType().getDeclaredFields()) {
                primaryKeyAttributeNames.add(pkField.getName());
            }
        } else {
            ArrayList<String> unsortedPkFields = new ArrayList<String>();
            for (SingularAttribute attr : entityType.getSingularAttributes()) {
                if (!attr.isId()) continue;
                unsortedPkFields.add(attr.getName());
            }
            this.getPrimaryKeyNamesInOrder(primaryKeyAttributeNames, unsortedPkFields, entityType.getJavaType().getDeclaredFields(), entityType.getJavaType());
        }
        return primaryKeyAttributeNames;
    }

    private void getPrimaryKeyNamesInOrder(List<String> pkFieldNames, List<String> unsortedPks, Field[] fields, Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            if (!unsortedPks.contains(field.getName())) continue;
            pkFieldNames.add(field.getName());
        }
        if (pkFieldNames.isEmpty() && type.getSuperclass() != null) {
            this.getPrimaryKeyNamesInOrder(pkFieldNames, unsortedPks, type.getSuperclass().getDeclaredFields(), type.getSuperclass());
        }
    }

    protected List<DataObjectAttribute> getSingularAttributes(Class<?> persistableClass, Collection<?> fields, List<String> primaryKeyAttributes) {
        if (fields == null) {
            fields = Collections.emptySet();
        }
        HashMap<String, SingularAttribute> attrs = new HashMap<String, SingularAttribute>(fields.size());
        for (SingularAttribute attr : fields) {
            if (attr.isAssociation()) continue;
            attrs.put(attr.getName(), attr);
        }
        ArrayList<DataObjectAttribute> attributes = new ArrayList<DataObjectAttribute>(fields.size());
        for (Field f : persistableClass.getDeclaredFields()) {
            SingularAttribute attr = (SingularAttribute)attrs.get(f.getName());
            if (attr == null) continue;
            attributes.add(this.getAttributeMetadata(persistableClass, attr, primaryKeyAttributes));
            attrs.remove(f.getName());
        }
        for (SingularAttribute attr : attrs.values()) {
            attributes.add(this.getAttributeMetadata(persistableClass, attr, primaryKeyAttributes));
        }
        return attributes;
    }

    protected DataObjectAttribute getAttributeMetadata(Class<?> persistableClass, SingularAttribute<?, ?> attr, List<String> primaryKeyAttributes) {
        DataObjectAttributeImpl attribute = new DataObjectAttributeImpl();
        attribute.setOwningType(persistableClass);
        attribute.setName(attr.getName());
        Class propertyType = attr.getJavaType();
        attribute.setType(propertyType);
        DataType dataType = DataType.getDataTypeFromClass((Class)propertyType);
        if (dataType == null) {
            dataType = DataType.STRING;
        }
        attribute.setDataType(dataType);
        attribute.setRequired(!attr.isOptional() && !attr.isId() && !primaryKeyAttributes.contains(attr.getName()));
        this.populateImplementationSpecificAttributeLevelMetadata(attribute, attr);
        return attribute;
    }

    protected List<DataObjectCollection> getCollectionsFromMetadata(Set<PluralAttribute> collections) {
        ArrayList<DataObjectCollection> colls = new ArrayList<DataObjectCollection>(collections.size());
        for (PluralAttribute cd : collections) {
            colls.add(this.getCollectionMetadataFromCollectionAttribute(cd));
        }
        return colls;
    }

    protected DataObjectCollection getCollectionMetadataFromCollectionAttribute(PluralAttribute cd) {
        try {
            DataObjectCollectionImpl collection = new DataObjectCollectionImpl();
            Class collectionElementClass = cd.getElementType().getJavaType();
            EntityType elementEntityType = this.entityManager.getMetamodel().entity(collectionElementClass);
            collection.setName(cd.getName());
            collection.setRelatedType(collectionElementClass);
            this.populateImplementationSpecificCollectionLevelMetadata(collection, cd);
            Attribute.PersistentAttributeType persistentAttributeType = cd.getPersistentAttributeType();
            if (persistentAttributeType == Attribute.PersistentAttributeType.ONE_TO_MANY) {
                if (collection.getAttributeRelationships().isEmpty()) {
                    List<String> pkFields = this.getPrimaryKeyAttributeNames((EntityType)cd.getDeclaringType());
                    List<String> fkFields = this.getPrimaryKeyAttributeNames(elementEntityType);
                    ArrayList<DataObjectAttributeRelationship> attributeRelationships = new ArrayList<DataObjectAttributeRelationship>();
                    for (int i = 0; i < pkFields.size(); ++i) {
                        attributeRelationships.add(new DataObjectAttributeRelationshipImpl(pkFields.get(i), fkFields.get(i)));
                    }
                    collection.setAttributeRelationships(attributeRelationships);
                }
            } else if (persistentAttributeType == Attribute.PersistentAttributeType.MANY_TO_MANY) {
                collection.setIndirectCollection(true);
                collection.setAttributeRelationships(null);
            }
            return collection;
        }
        catch (RuntimeException ex) {
            LOG.error("Unable to process Collection metadata: " + String.valueOf(cd));
            throw ex;
        }
    }

    protected List<DataObjectRelationship> getRelationships(Set<?> references) {
        ArrayList<DataObjectRelationship> rels = new ArrayList<DataObjectRelationship>(references.size());
        for (SingularAttribute rd : references) {
            if (!rd.isAssociation()) continue;
            rels.add(this.getRelationshipMetadata(rd));
        }
        return rels;
    }

    protected DataObjectRelationship getRelationshipMetadata(SingularAttribute rd) {
        try {
            DataObjectRelationshipImpl relationship = new DataObjectRelationshipImpl();
            Class referencedClass = rd.getBindableJavaType();
            EntityType referencedEntityType = this.entityManager.getMetamodel().entity(referencedClass);
            relationship.setName(rd.getName());
            relationship.setRelatedType(referencedClass);
            this.populateImplementationSpecificRelationshipLevelMetadata(relationship, rd);
            return relationship;
        }
        catch (RuntimeException ex) {
            LOG.error("Unable to process Relationship metadata: " + String.valueOf(rd));
            throw ex;
        }
    }

    @Override
    public boolean isClassPersistable(Class<?> type) {
        return this.handles(type);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

