/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.agenda;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.w3c.dom.Element;

@XmlRootElement(name="AgendaItemDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AgendaItemType", propOrder={"id", "agendaId", "ruleId", "subAgendaId", "whenTrueId", "whenFalseId", "alwaysId", "rule", "subAgenda", "whenTrue", "whenFalse", "always", "versionNumber", "_futureElements"})
public final class AgendaItemDefinition
extends AbstractDataTransferObject
implements AgendaItemDefinitionContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="agendaId", required=true)
    private String agendaId;
    @XmlElement(name="ruleId", required=false)
    private String ruleId;
    @XmlElement(name="subAgendaId", required=false)
    private String subAgendaId;
    @XmlElement(name="whenTrueId", required=false)
    private String whenTrueId;
    @XmlElement(name="whenFalseId", required=false)
    private String whenFalseId;
    @XmlElement(name="alwaysId", required=false)
    private String alwaysId;
    @XmlElement(name="rule", required=false)
    private RuleDefinition rule;
    @XmlElement(name="subAgenda", required=false)
    private AgendaDefinition subAgenda;
    @XmlElement(name="whenTrue", required=false)
    private AgendaItemDefinition whenTrue;
    @XmlElement(name="whenFalse", required=false)
    private AgendaItemDefinition whenFalse;
    @XmlElement(name="always", required=false)
    private AgendaItemDefinition always;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private AgendaItemDefinition() {
        this.id = null;
        this.agendaId = null;
        this.ruleId = null;
        this.subAgendaId = null;
        this.whenTrueId = null;
        this.whenFalseId = null;
        this.alwaysId = null;
        this.rule = null;
        this.subAgenda = null;
        this.whenTrue = null;
        this.whenFalse = null;
        this.always = null;
        this.versionNumber = null;
    }

    private AgendaItemDefinition(Builder builder) {
        this.id = builder.getId();
        this.agendaId = builder.getAgendaId();
        this.ruleId = builder.getRuleId();
        this.subAgendaId = builder.getSubAgendaId();
        this.whenTrueId = builder.getWhenTrueId();
        this.whenFalseId = builder.getWhenFalseId();
        this.alwaysId = builder.getAlwaysId();
        this.versionNumber = builder.getVersionNumber();
        if (builder.getRule() != null) {
            this.rule = builder.getRule().build();
        }
        if (builder.getSubAgenda() != null) {
            this.subAgenda = builder.getSubAgenda().build();
        }
        if (builder.getWhenTrue() != null) {
            this.whenTrue = builder.getWhenTrue().build();
        }
        if (builder.getWhenFalse() != null) {
            this.whenFalse = builder.getWhenFalse().build();
        }
        if (builder.getAlways() != null) {
            this.always = builder.getAlways().build();
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getAgendaId() {
        return this.agendaId;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public String getSubAgendaId() {
        return this.subAgendaId;
    }

    @Override
    public String getWhenTrueId() {
        return this.whenTrueId;
    }

    @Override
    public String getWhenFalseId() {
        return this.whenFalseId;
    }

    @Override
    public String getAlwaysId() {
        return this.alwaysId;
    }

    @Override
    public RuleDefinition getRule() {
        return this.rule;
    }

    @Override
    public AgendaDefinition getSubAgenda() {
        return this.subAgenda;
    }

    @Override
    public AgendaItemDefinition getWhenTrue() {
        return this.whenTrue;
    }

    @Override
    public AgendaItemDefinition getWhenFalse() {
        return this.whenFalse;
    }

    @Override
    public AgendaItemDefinition getAlways() {
        return this.always;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements AgendaItemDefinitionContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String agendaId;
        private String ruleId;
        private String subAgendaId;
        private String whenTrueId;
        private String whenFalseId;
        private String alwaysId;
        private Long versionNumber;
        private RuleDefinition.Builder rule;
        private AgendaDefinition.Builder subAgenda;
        private Builder whenTrue;
        private Builder whenFalse;
        private Builder always;

        private Builder(String id, String agendaId) {
            this.setId(id);
            this.setAgendaId(agendaId);
            this.setVersionNumber(0L);
        }

        public static Builder create(String id, String agendaId) {
            return new Builder(id, agendaId);
        }

        public static Builder create(AgendaItemDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getAgendaId());
            builder.setRuleId(contract.getRuleId());
            builder.setSubAgendaId(contract.getSubAgendaId());
            builder.setWhenTrueId(contract.getWhenTrueId());
            builder.setWhenFalseId(contract.getWhenFalseId());
            builder.setAlwaysId(contract.getAlwaysId());
            if (contract.getRule() != null) {
                builder.setRule(RuleDefinition.Builder.create(contract.getRule()));
            }
            if (contract.getSubAgenda() != null) {
                builder.setSubAgenda(AgendaDefinition.Builder.create(contract.getSubAgenda()));
            }
            if (contract.getWhenTrue() != null) {
                builder.setWhenTrue(Builder.create(contract.getWhenTrue()));
            }
            if (contract.getWhenFalse() != null) {
                builder.setWhenFalse(Builder.create(contract.getWhenFalse()));
            }
            if (contract.getAlways() != null) {
                builder.setAlways(Builder.create(contract.getAlways()));
            }
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String agendaItemId) {
            if (agendaItemId != null && StringUtils.isBlank((String)agendaItemId)) {
                throw new IllegalArgumentException("agendaItemId must be null or non-blank");
            }
            this.id = agendaItemId;
        }

        public void setAgendaId(String agendaId) {
            if (StringUtils.isBlank((String)agendaId)) {
                throw new IllegalArgumentException("agendaId is blank");
            }
            this.agendaId = agendaId;
        }

        public void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public void setSubAgendaId(String subAgendaId) {
            this.subAgendaId = subAgendaId;
        }

        public void setWhenTrueId(String whenTrueId) {
            this.whenTrueId = whenTrueId;
        }

        public void setWhenFalseId(String whenFalseId) {
            this.whenFalseId = whenFalseId;
        }

        public void setAlwaysId(String alwaysId) {
            this.alwaysId = alwaysId;
        }

        public void setRule(RuleDefinition.Builder rule) {
            this.rule = rule;
        }

        public void setSubAgenda(AgendaDefinition.Builder subAgenda) {
            this.subAgenda = subAgenda;
        }

        public void setWhenTrue(Builder whenTrue) {
            this.whenTrue = whenTrue;
            this.whenTrueId = whenTrue != null ? whenTrue.getId() : null;
        }

        public void setWhenFalse(Builder whenFalse) {
            this.whenFalse = whenFalse;
            this.whenFalseId = whenFalse != null ? whenFalse.getId() : null;
        }

        public void setAlways(Builder always) {
            this.always = always;
            this.alwaysId = always != null ? always.getId() : null;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getAgendaId() {
            return this.agendaId;
        }

        @Override
        public String getRuleId() {
            return this.ruleId;
        }

        @Override
        public String getSubAgendaId() {
            return this.subAgendaId;
        }

        @Override
        public String getWhenTrueId() {
            return this.whenTrueId;
        }

        @Override
        public String getWhenFalseId() {
            return this.whenFalseId;
        }

        @Override
        public String getAlwaysId() {
            return this.alwaysId;
        }

        @Override
        public RuleDefinition.Builder getRule() {
            return this.rule;
        }

        @Override
        public AgendaDefinition.Builder getSubAgenda() {
            return this.subAgenda;
        }

        @Override
        public Builder getWhenTrue() {
            return this.whenTrue;
        }

        @Override
        public Builder getWhenFalse() {
            return this.whenFalse;
        }

        @Override
        public Builder getAlways() {
            return this.always;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public AgendaItemDefinition build() {
            return new AgendaItemDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/AgendaItemType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String AGENDA_ID = "agendaId";
        static final String RULE_ID = "ruleId";
        static final String SUB_AGENDA_ID = "subAgendaId";
        static final String WHEN_TRUE_ID = "whenTrueId";
        static final String WHEN_FALSE_ID = "whenFalseId";
        static final String ALWAYS_ID = "alwaysId";
        static final String RULE = "rule";
        static final String SUB_AGENDA = "subAgenda";
        static final String WHEN_TRUE = "whenTrue";
        static final String WHEN_FALSE = "whenFalse";
        static final String ALWAYS = "always";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "AgendaItemDefinition";
        static final String TYPE_NAME = "AgendaItemType";

        Constants() {
        }
    }
}

