/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.store;

import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.core.spi.store.Store;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.serialization.Serializer;

public class StoreConfigurationImpl<K, V>
implements Store.Configuration<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final ClassLoader classLoader;
    private final ExpiryPolicy<? super K, ? super V> expiry;
    private final ResourcePools resourcePools;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final int dispatcherConcurrency;
    private final boolean operationStatisticsEnabled;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final boolean useLoaderInAtomics;

    public StoreConfigurationImpl(CacheConfiguration<K, V> cacheConfig, int dispatcherConcurrency, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(cacheConfig.getKeyType(), cacheConfig.getValueType(), cacheConfig.getEvictionAdvisor(), cacheConfig.getClassLoader(), cacheConfig.getExpiryPolicy(), cacheConfig.getResourcePools(), dispatcherConcurrency, true, keySerializer, valueSerializer, null, false);
    }

    public StoreConfigurationImpl(CacheConfiguration<K, V> cacheConfig, int dispatcherConcurrency, boolean operationStatisticsEnabled, Serializer<K> keySerializer, Serializer<V> valueSerializer, CacheLoaderWriter<? super K, V> cacheLoaderWriter, boolean useLoaderInAtomics) {
        this(cacheConfig.getKeyType(), cacheConfig.getValueType(), cacheConfig.getEvictionAdvisor(), cacheConfig.getClassLoader(), cacheConfig.getExpiryPolicy(), cacheConfig.getResourcePools(), dispatcherConcurrency, operationStatisticsEnabled, keySerializer, valueSerializer, cacheLoaderWriter, useLoaderInAtomics);
    }

    public StoreConfigurationImpl(Class<K> keyType, Class<V> valueType, EvictionAdvisor<? super K, ? super V> evictionAdvisor, ClassLoader classLoader, ExpiryPolicy<? super K, ? super V> expiry, ResourcePools resourcePools, int dispatcherConcurrency, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(keyType, valueType, evictionAdvisor, classLoader, expiry, resourcePools, dispatcherConcurrency, true, keySerializer, valueSerializer, null, false);
    }

    public StoreConfigurationImpl(Class<K> keyType, Class<V> valueType, EvictionAdvisor<? super K, ? super V> evictionAdvisor, ClassLoader classLoader, ExpiryPolicy<? super K, ? super V> expiry, ResourcePools resourcePools, int dispatcherConcurrency, Serializer<K> keySerializer, Serializer<V> valueSerializer, CacheLoaderWriter<? super K, V> cacheLoaderWriter) {
        this(keyType, valueType, evictionAdvisor, classLoader, expiry, resourcePools, dispatcherConcurrency, true, keySerializer, valueSerializer, cacheLoaderWriter, false);
    }

    public StoreConfigurationImpl(Class<K> keyType, Class<V> valueType, ClassLoader classLoader, int dispatcherConcurrency, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(keyType, valueType, null, classLoader, null, null, dispatcherConcurrency, true, keySerializer, valueSerializer, null, false);
    }

    public StoreConfigurationImpl(Class<K> keyType, Class<V> valueType, EvictionAdvisor<? super K, ? super V> evictionAdvisor, ClassLoader classLoader, ExpiryPolicy<? super K, ? super V> expiry, ResourcePools resourcePools, int dispatcherConcurrency, boolean operationStatisticsEnabled, Serializer<K> keySerializer, Serializer<V> valueSerializer, CacheLoaderWriter<? super K, V> cacheLoaderWriter, boolean useLoaderInAtomics) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.evictionAdvisor = evictionAdvisor;
        this.classLoader = classLoader;
        this.expiry = expiry;
        this.resourcePools = resourcePools;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.dispatcherConcurrency = dispatcherConcurrency;
        this.operationStatisticsEnabled = operationStatisticsEnabled;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.useLoaderInAtomics = useLoaderInAtomics;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor() {
        return this.evictionAdvisor;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ExpiryPolicy<? super K, ? super V> getExpiry() {
        return this.expiry;
    }

    @Override
    public ResourcePools getResourcePools() {
        return this.resourcePools;
    }

    @Override
    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public int getDispatcherConcurrency() {
        return this.dispatcherConcurrency;
    }

    @Override
    public boolean isOperationStatisticsEnabled() {
        return this.operationStatisticsEnabled;
    }

    @Override
    public CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    @Override
    public boolean useLoaderInAtomics() {
        return this.useLoaderInAtomics;
    }
}

