/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.UserSession;

public class AttachmentServlet
extends HttpServlet {
    private static final long serialVersionUID = -1918858512573502697L;
    public static final String ATTACHMENT_ID_KEY = "attachmentId";
    private static final Logger LOG = LogManager.getLogger(AttachmentServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block21: {
            String attachmentId = request.getParameter(ATTACHMENT_ID_KEY);
            if (attachmentId == null) {
                throw new ServletException("No 'attachmentId' was specified.");
            }
            boolean secureChecks = false;
            String secureAttachmentsParam = null;
            try {
                secureAttachmentsParam = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "All", "SECURED_ATTACHMENT_SERVLET");
            }
            catch (Exception e) {
                LOG.info("Attempted to retrieve parameter value, but could not. Defaulting to unsecured attachment retrieval. " + e.getMessage());
            }
            if (secureAttachmentsParam != null && secureAttachmentsParam.equals("Y")) {
                secureChecks = true;
            }
            try {
                UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
                if (userSession != null) {
                    NoteService noteService = KEWServiceLocator.getNoteService();
                    Attachment attachment = noteService.findAttachment(attachmentId);
                    byte[] file = noteService.findAttachmentFile(attachment);
                    DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(noteService.getNoteByNoteId(attachment.getNoteId()).getDocumentId());
                    if (!secureChecks || routeHeader != null) {
                        boolean authorized = KEWServiceLocator.getDocumentSecurityService().routeLogAuthorized(userSession.getPrincipalId(), routeHeader, new SecuritySession(userSession.getPrincipalId()));
                        boolean customAttributeAuthorized = false;
                        if (routeHeader.getCustomNoteAttribute() != null) {
                            routeHeader.getCustomNoteAttribute().setUserSession(userSession);
                            customAttributeAuthorized = routeHeader.getCustomNoteAttribute().isAuthorizedToRetrieveAttachments();
                        }
                        if (!secureChecks || authorized && customAttributeAuthorized) {
                            response.setContentLength(file.length);
                            response.setContentType(attachment.getMimeType());
                            response.setHeader("Content-disposition", "attachment; filename=\"" + attachment.getFileName() + "\"");
                            try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(file));
                                 BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                                int c;
                                while ((c = inputStream.read()) != -1) {
                                    ((OutputStream)outputStream).write(c);
                                }
                                break block21;
                            }
                        }
                        LOG.error("Attempt to access attachmentId:" + attachmentId + " from documentId:" + routeHeader.getDocumentId() + " from unauthorized user: " + userSession.getPrincipalId());
                        response.sendError(403);
                        return;
                    }
                    LOG.error("Caught Null Pointer trying to determine routeHeader for requested attachmentId:" + attachmentId);
                    response.sendError(404);
                    return;
                }
                LOG.error("Attempt to access attachmentId:" + attachmentId + " with invalid UserSession");
                response.sendError(400);
                return;
            }
            catch (Exception e) {
                LOG.error("Problem retrieving requested attachmentId:" + attachmentId, (Throwable)e);
                throw new WorkflowRuntimeException((Throwable)e);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

