/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.document;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.krad.UserSession;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ElasticsearchIndexJob
extends QuartzJobBean {
    private static final Logger LOG = LogManager.getLogger(ElasticsearchIndexJob.class);
    private String user;
    private ElasticsearchIndexService elasticsearchIndexService;
    private GlobalVariableService globalVariableService;
    private KewDocHeaderDao kewDocHeaderDao;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.globalVariableService.doInNewGlobalVariables(new UserSession(this.user), () -> this.elasticsearchIndexService.bulkIndex(this.kewDocHeaderDao.getAllDocumentIds()));
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setElasticsearchIndexService(ElasticsearchIndexService elasticsearchIndexService) {
        this.elasticsearchIndexService = elasticsearchIndexService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public void setKewDocHeaderDao(KewDocHeaderDao kewDocHeaderDao) {
        this.kewDocHeaderDao = kewDocHeaderDao;
    }
}

