/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.StringUtils;
import org.kuali.coeus.sys.framework.auth.CategoryDto;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.impl.auth.CoreStreamingService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="coreGroupsService")
public class CoreGroupsServiceImpl
implements CoreGroupsService {
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="coreStreamingService")
    private CoreStreamingService coreStreamingService;

    @Override
    public String getCategoriesApiUrl() {
        return this.configurationService.getPropertyValueAsString("core.categories.url") + "/";
    }

    @Override
    public String getGroupsApiUrl() {
        return this.configurationService.getPropertyValueAsString("core.groups.url") + "/";
    }

    @Override
    public Stream<GroupDto> getAllGroups() {
        return this.getCoreStreamingService().streamAll(this.getGroupsApiUrl(), Collections.emptyMap(), GroupDto.class);
    }

    @Override
    public Stream<CategoryDto> getAllCategories() {
        return this.getCoreStreamingService().streamAll(this.getCategoriesApiUrl(), Collections.emptyMap(), CategoryDto.class);
    }

    @Override
    public String getUnitNumberForGroup(GroupDto group) {
        return group.getFields().stream().filter(f -> StringUtils.equals((CharSequence)f.getId(), (CharSequence)"UNIT_NUMBER")).map(GroupDto.GroupFields::getValue).findFirst().orElse(null);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public CoreStreamingService getCoreStreamingService() {
        return this.coreStreamingService;
    }

    public void setCoreStreamingService(CoreStreamingService coreStreamingService) {
        this.coreStreamingService = coreStreamingService;
    }
}

