/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.datetime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.stereotype.Component;

@Component(value="s2SDateTimeService")
public class S2SDateTimeServiceImpl
implements S2SDateTimeService {
    @Override
    public ScaleTwoDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        ScaleTwoDecimal monthCount = ScaleTwoDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return ScaleTwoDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BigDecimal startMonthFraction = BigDecimal.valueOf(++startMonthDays).setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(startMonthMaxDays).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP);
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BigDecimal endMonthFraction = BigDecimal.valueOf(endMonthDays).setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(endMonthMaxDays).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP);
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)monthCount.add((AbstractDecimal)new ScaleTwoDecimal(--fullMonthCount))).add((AbstractDecimal)new ScaleTwoDecimal(startMonthFraction))).add((AbstractDecimal)new ScaleTwoDecimal(endMonthFraction));
        return monthCount;
    }

    @Override
    public String removeTimezoneFactor(String applicationXmlText) {
        return this.removeTimezoneFactor(applicationXmlText, Calendar.getInstance());
    }

    public String removeTimezoneFactor(String applicationXmlText, Calendar cal) {
        int zoneOffsetMilli = cal.get(15);
        int zoneOffsetNow = zoneOffsetMilli / 3600000;
        int zoneOffsetDST = zoneOffsetMilli / 3600000 + 1;
        String timezoneIdNowOffset = StringUtils.right((String)StringUtils.remove((String)TimeZone.getTimeZone("GMT" + zoneOffsetNow).getID(), (String)"GMT"), (int)6);
        String timezoneIdDstOffset = StringUtils.right((String)StringUtils.remove((String)TimeZone.getTimeZone("GMT" + zoneOffsetDST).getID(), (String)"GMT"), (int)6);
        if (StringUtils.isNotBlank((CharSequence)timezoneIdNowOffset) && timezoneIdNowOffset.contains(":")) {
            applicationXmlText = StringUtils.remove((String)applicationXmlText, (String)timezoneIdNowOffset);
        }
        if (StringUtils.isNotBlank((CharSequence)timezoneIdDstOffset) && timezoneIdDstOffset.contains(":")) {
            applicationXmlText = StringUtils.remove((String)applicationXmlText, (String)timezoneIdDstOffset);
        }
        return applicationXmlText;
    }

    @Override
    public Calendar convertDateStringToCalendar(String dateStr) {
        Calendar calendar = null;
        if (dateStr != null) {
            calendar = Calendar.getInstance();
            calendar.set(Integer.parseInt(dateStr.substring(6, 10)), Integer.parseInt(dateStr.substring(0, 2)) - 1, Integer.parseInt(dateStr.substring(3, 5)));
        }
        return calendar;
    }

    @Override
    public Calendar convertDateToCalendar(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.clear(15);
            calendar.clear(16);
        }
        return calendar;
    }
}

