/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.cd511V11.CD511Document;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="CD511V1_1Generator")
public class CD511V1_1Generator
extends S2SBaseFormGenerator<CD511Document>
implements S2SFormGeneratorPdfFillable<CD511Document> {
    @Value(value="http://apply.grants.gov/forms/CD511-V1.1")
    private String namespace;
    @Value(value="CD511-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/CD511-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/CD511-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    private DepartmentalPersonService departmentalPersonService;
    private DepartmentalPersonDto aorInfo;

    private CD511Document getcd511Document() {
        String title;
        CD511Document cd511Document = (CD511Document)CD511Document.Factory.newInstance();
        CD511Document.CD511 cd511 = (CD511Document.CD511)CD511Document.CD511.Factory.newInstance();
        cd511.setFormVersion(FormVersion.v1_1.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            cd511.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
        if (this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber() != null && !this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber().equals("")) {
            cd511.setAwardNumber(this.pdDoc.getDevelopmentProposal().getCurrentAwardNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getTitle() != null && !this.pdDoc.getDevelopmentProposal().getTitle().equals("")) {
            title = StringUtils.left((String)this.pdDoc.getDevelopmentProposal().getTitle(), (int)60);
            cd511.setProjectName(title);
        }
        title = "";
        cd511.setContactName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null && !this.aorInfo.getPrimaryTitle().equals("")) {
            title = StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45);
        }
        cd511.setTitle(title);
        cd511.setSignature(this.aorInfo.getFullName());
        cd511.setSubmittedDate(this.aorInfo.getSubmittedDate());
        cd511Document.setCD511(cd511);
        return cd511Document;
    }

    @Override
    public CD511Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getcd511Document();
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(CD511Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<CD511Document> factory() {
        return CD511Document.Factory;
    }
}

