/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrOtherProjectInfo13V13.RROtherProjectInfo13Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RROtherProjectInfoBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RROtherProjectInfo_1_3V1_3Generator")
public class RROtherProjectInfo_1_3V1_3Generator
extends RROtherProjectInfoBaseGenerator<RROtherProjectInfo13Document>
implements S2SFormGeneratorPdfFillable<RROtherProjectInfo13Document> {
    private static final Integer HISTORIC_DESTIONATION_YNQ = 125;
    List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/RR_OtherProjectInfo_1_3-V1.3")
    private String namespace;
    @Value(value="RR_OtherProjectInfo_1_3-V1.3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_OtherProjectInfo_1_3-V1.3.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_OtherProjectInfo_1_3-V1.3.pdf")
    private Resource pdfForm;
    @Value(value="140")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    private RROtherProjectInfo13Document getRROtherProjectInfo() {
        RROtherProjectInfo13Document rrOtherProjectInfoDocument = (RROtherProjectInfo13Document)RROtherProjectInfo13Document.Factory.newInstance();
        RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo = (RROtherProjectInfo13Document.RROtherProjectInfo13)RROtherProjectInfo13Document.RROtherProjectInfo13.Factory.newInstance();
        rrOtherProjectInfo.setFormVersion(FormVersion.v1_3.getVersion());
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        this.setHumanSubjAndVertebrateAnimals(rrOtherProjectInfo, organization);
        this.setProprietaryInformationIndicator(rrOtherProjectInfo);
        this.setEnvironmentalImpactDetails(rrOtherProjectInfo);
        this.setHistoricDestionation(rrOtherProjectInfo);
        this.setInternationalActivities(rrOtherProjectInfo);
        this.setAttachments(rrOtherProjectInfo);
        rrOtherProjectInfoDocument.setRROtherProjectInfo13(rrOtherProjectInfo);
        return rrOtherProjectInfoDocument;
    }

    private void setHistoricDestionation(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        String historicDestinationAnswer = this.getAnswer(HISTORIC_DESTIONATION_YNQ, this.answerHeaders);
        if (historicDestinationAnswer != null && !historicDestinationAnswer.equals("No")) {
            YesNoDataType.Enum answer = YnqConstant.YES.code().equals(historicDestinationAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            String answerExplanation = this.getChildQuestionAnswer(HISTORIC_DESTIONATION_YNQ, EXPLANATION, this.answerHeaders);
            rrOtherProjectInfo.setHistoricDesignation(answer);
            if (answerExplanation != null) {
                if (answerExplanation.trim().length() > 55) {
                    rrOtherProjectInfo.setHistoricDesignationExplanation(answerExplanation.trim().substring(0, 55));
                } else {
                    rrOtherProjectInfo.setHistoricDesignationExplanation(answerExplanation.trim());
                }
            } else if (YnqConstant.YES.code().equals(historicDestinationAnswer)) {
                rrOtherProjectInfo.setHistoricDesignationExplanation(null);
            }
        } else {
            rrOtherProjectInfo.setHistoricDesignation(null);
        }
    }

    private void setProprietaryInformationIndicator(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        String propertyInformationAnswer = this.getAnswer(PROPRIETARY_INFORMATION_INDICATOR, this.answerHeaders);
        if (propertyInformationAnswer != null && !propertyInformationAnswer.equals("No")) {
            YesNoDataType.Enum answer = YnqConstant.YES.code().equals(propertyInformationAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            rrOtherProjectInfo.setProprietaryInformationIndicator(answer);
        } else {
            rrOtherProjectInfo.setProprietaryInformationIndicator(null);
        }
    }

    private void setEnvironmentalImpactDetails(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact environmentalImpact = (RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact)RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact.Factory.newInstance();
        this.setEnvironmentalImpactIndicatorAndExplanation(environmentalImpact);
        this.setEnvironmentalExemption(environmentalImpact);
        rrOtherProjectInfo.setEnvironmentalImpact(environmentalImpact);
    }

    private void setEnvironmentalImpactIndicatorAndExplanation(RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact environmentalImpact) {
        String environmentalImpactAnswer = this.getAnswer(ENVIRONMENTAL_IMPACT_YNQ, this.answerHeaders);
        if (environmentalImpactAnswer != null && !environmentalImpactAnswer.equals("No")) {
            YesNoDataType.Enum answer = YnqConstant.YES.code().equals(environmentalImpactAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            String answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_IMPACT_YNQ, EXPLANATION, this.answerHeaders);
            environmentalImpact.setEnvironmentalImpactIndicator(answer);
            if (answerExplanation != null) {
                if (answerExplanation.trim().length() > 55) {
                    environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation.trim().substring(0, 55));
                } else {
                    environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation.trim());
                }
            } else if (YnqConstant.YES.code().equals(environmentalImpactAnswer)) {
                environmentalImpact.setEnvironmentalImpactExplanation(null);
            }
        } else {
            environmentalImpact.setEnvironmentalImpactIndicator(null);
        }
    }

    private void setHumanSubjAndVertebrateAnimals(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo, OrganizationContract organization) {
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
        this.pdDoc.getDevelopmentProposal().getPropSpecialReviews().stream().filter(proposalSpecialReview -> proposalSpecialReview.getSpecialReviewType() != null).forEach(proposalSpecialReview -> {
            if ("1".equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
                this.setHumaSubjectSupplementDetails(rrOtherProjectInfo, organization, (ProposalSpecialReviewContract)proposalSpecialReview);
            } else if ("2".equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
                this.setVertebrateAnimalsSupplementDetails(rrOtherProjectInfo, organization, (ProposalSpecialReviewContract)proposalSpecialReview);
            }
        });
    }

    private void setEnvironmentalExemption(RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact environmentalImpact) {
        String answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, EXPLANATION, this.answerHeaders);
        String ynqAnswer = this.getAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, this.answerHeaders);
        YesNoDataType.Enum answer = YnqConstant.YES.code().equals(ynqAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact.EnvironmentalExemption environmentalExemption = (RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact.EnvironmentalExemption)RROtherProjectInfo13Document.RROtherProjectInfo13.EnvironmentalImpact.EnvironmentalExemption.Factory.newInstance();
        if (ynqAnswer != null && !ynqAnswer.equals("No")) {
            if (!YnqConstant.NA.code().equals(ynqAnswer)) {
                environmentalExemption.setEnvironmentalExemptionIndicator(answer);
                if (answerExplanation != null) {
                    if (answerExplanation.trim().length() > 55) {
                        environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation.trim().substring(0, 55));
                    } else {
                        environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation.trim());
                    }
                } else if (YnqConstant.YES.code().equals(ynqAnswer)) {
                    environmentalExemption.setEnvironmentalExemptionExplanation(null);
                }
                environmentalImpact.setEnvironmentalExemption(environmentalExemption);
            }
        } else {
            environmentalExemption.setEnvironmentalExemptionIndicator(null);
        }
    }

    private void setInternationalActivities(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        RROtherProjectInfo13Document.RROtherProjectInfo13.InternationalActivities internationalActivities = (RROtherProjectInfo13Document.RROtherProjectInfo13.InternationalActivities)RROtherProjectInfo13Document.RROtherProjectInfo13.InternationalActivities.Factory.newInstance();
        String internationalActivitiesAnswer = this.getAnswer(INTERNATIONAL_ACTIVITIES_YNQ, this.answerHeaders);
        if (internationalActivitiesAnswer != null && !internationalActivitiesAnswer.equals("No")) {
            YesNoDataType.Enum answer = YnqConstant.YES.code().equals(internationalActivitiesAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            String answerExplanation = this.getAnswer(INTERNATIONAL_ACTIVITIES_EXPL, this.answerHeaders);
            internationalActivities.setInternationalActivitiesIndicator(answer);
            if (answerExplanation != null && !answerExplanation.equals("No")) {
                if (answerExplanation.trim().length() > 55) {
                    internationalActivities.setActivitiesPartnershipsCountries(answerExplanation.trim().substring(0, 55));
                } else {
                    internationalActivities.setActivitiesPartnershipsCountries(answerExplanation.trim());
                }
                if (this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders) != null) {
                    internationalActivities.setInternationalActivitiesExplanation(this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders));
                }
            } else if (YnqConstant.YES.code().equals(internationalActivitiesAnswer)) {
                internationalActivities.setActivitiesPartnershipsCountries(answerExplanation);
            }
        } else {
            internationalActivities.setInternationalActivitiesIndicator(null);
        }
        rrOtherProjectInfo.setInternationalActivities(internationalActivities);
    }

    private void setVertebrateAnimalsSupplementDetails(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo, OrganizationContract organization, ProposalSpecialReviewContract proposalSpecialReview) {
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.Y_YES);
        RROtherProjectInfo13Document.RROtherProjectInfo13.VertebrateAnimalsSupplement vertebrateAnimalsSupplement = (RROtherProjectInfo13Document.RROtherProjectInfo13.VertebrateAnimalsSupplement)RROtherProjectInfo13Document.RROtherProjectInfo13.VertebrateAnimalsSupplement.Factory.newInstance();
        this.setVertebrateAnimalsIACUCReviewDetails(proposalSpecialReview, vertebrateAnimalsSupplement);
        if (organization != null && organization.getAnimalWelfareAssurance() != null) {
            vertebrateAnimalsSupplement.setAssuranceNumber(organization.getAnimalWelfareAssurance());
        }
        rrOtherProjectInfo.setVertebrateAnimalsSupplement(vertebrateAnimalsSupplement);
    }

    private void setHumaSubjectSupplementDetails(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo, OrganizationContract organization, ProposalSpecialReviewContract proposalSpecialReview) {
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.Y_YES);
        RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement humanSubjectsSupplement = (RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement)RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.Factory.newInstance();
        RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers = (RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers)RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers.Factory.newInstance();
        if (proposalSpecialReview.getApprovalType() != null) {
            this.setExemptions(proposalSpecialReview, humanSubjectsSupplement, exemptionNumbers);
            this.setHumanSubjectIRBReviewIndicator(proposalSpecialReview, humanSubjectsSupplement);
        }
        if (organization != null && organization.getHumanSubAssurance() != null) {
            humanSubjectsSupplement.setHumanSubjectAssuranceNumber(organization.getHumanSubAssurance().substring(3));
        }
        if (humanSubjectsSupplement != null) {
            rrOtherProjectInfo.setHumanSubjectsSupplement(humanSubjectsSupplement);
        }
    }

    private void setVertebrateAnimalsIACUCReviewDetails(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo13Document.RROtherProjectInfo13.VertebrateAnimalsSupplement vertebrateAnimalsSupplement) {
        if ("1".equals(proposalSpecialReview.getApprovalType().getCode())) {
            vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.Y_YES);
        } else {
            vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.N_NO);
            if (proposalSpecialReview.getApprovalDate() != null) {
                vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCApprovalDateReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
            }
        }
    }

    private void setExemptions(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement humanSubjectsSupplement, RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers) {
        if (Integer.parseInt(proposalSpecialReview.getApprovalType().getCode()) == 4) {
            if (proposalSpecialReview.getSpecialReviewExemptions() != null) {
                exemptionNumbers.setExemptionNumberArray((RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[])proposalSpecialReview.getSpecialReviewExemptions().stream().filter(Objects::nonNull).map(e -> e.getExemptionType().getCode()).map(Integer::parseInt).filter(c -> c > 0 && c < 7).map(RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum::forInt).toArray(RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[]::new));
                humanSubjectsSupplement.setExemptionNumbers(exemptionNumbers);
            }
            humanSubjectsSupplement.setExemptFedReg(YesNoDataType.Y_YES);
        } else {
            humanSubjectsSupplement.setExemptFedReg(YesNoDataType.N_NO);
        }
    }

    private void setHumanSubjectIRBReviewIndicator(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo13Document.RROtherProjectInfo13.HumanSubjectsSupplement humanSubjectsSupplement) {
        if ("1".equals(proposalSpecialReview.getApprovalType().getCode()) || "3".equals(proposalSpecialReview.getApprovalType().getCode())) {
            humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.Y_YES);
        } else {
            humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.N_NO);
            if (proposalSpecialReview.getApprovalDate() != null) {
                humanSubjectsSupplement.setHumanSubjectIRBReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
            }
        }
    }

    private void setAttachments(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        Boolean isOtherAttachmentsExists = false;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null) continue;
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case 3: {
                    AttachedFileDataType equipmentFileDataType = this.addAttachedFileType(narrative);
                    if (equipmentFileDataType == null) break;
                    RROtherProjectInfo13Document.RROtherProjectInfo13.EquipmentAttachments equipmentAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.EquipmentAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.EquipmentAttachments.Factory.newInstance();
                    equipmentAttachments.setEquipmentAttachment(equipmentFileDataType);
                    rrOtherProjectInfo.setEquipmentAttachments(equipmentAttachments);
                    break;
                }
                case 2: {
                    AttachedFileDataType facilitiesFileDataType = this.addAttachedFileType(narrative);
                    if (facilitiesFileDataType == null) break;
                    RROtherProjectInfo13Document.RROtherProjectInfo13.FacilitiesAttachments facilitiesAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.FacilitiesAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.FacilitiesAttachments.Factory.newInstance();
                    facilitiesAttachments.setFacilitiesAttachment(facilitiesFileDataType);
                    rrOtherProjectInfo.setFacilitiesAttachments(facilitiesAttachments);
                    break;
                }
                case 1: {
                    AttachedFileDataType projectNarrativeFileDataType = this.addAttachedFileType(narrative);
                    if (projectNarrativeFileDataType == null) break;
                    RROtherProjectInfo13Document.RROtherProjectInfo13.ProjectNarrativeAttachments projectNarrativeAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.ProjectNarrativeAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.ProjectNarrativeAttachments.Factory.newInstance();
                    projectNarrativeAttachments.setProjectNarrativeAttachment(projectNarrativeFileDataType);
                    rrOtherProjectInfo.setProjectNarrativeAttachments(projectNarrativeAttachments);
                    break;
                }
                case 4: {
                    AttachedFileDataType bibliographyFileDataType = this.addAttachedFileType(narrative);
                    if (bibliographyFileDataType == null) break;
                    RROtherProjectInfo13Document.RROtherProjectInfo13.BibliographyAttachments bibliographyAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.BibliographyAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.BibliographyAttachments.Factory.newInstance();
                    bibliographyAttachments.setBibliographyAttachment(bibliographyFileDataType);
                    rrOtherProjectInfo.setBibliographyAttachments(bibliographyAttachments);
                    break;
                }
                case 5: {
                    AttachedFileDataType abstractFileDataType = this.addAttachedFileType(narrative);
                    if (abstractFileDataType == null) break;
                    RROtherProjectInfo13Document.RROtherProjectInfo13.AbstractAttachments abstractAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.AbstractAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.AbstractAttachments.Factory.newInstance();
                    abstractAttachments.setAbstractAttachment(abstractFileDataType);
                    rrOtherProjectInfo.setAbstractAttachments(abstractAttachments);
                    break;
                }
                case 8: {
                    isOtherAttachmentsExists = true;
                }
            }
        }
        if (isOtherAttachmentsExists.booleanValue()) {
            this.setOtherAttachments(rrOtherProjectInfo);
        }
    }

    private void setOtherAttachments(RROtherProjectInfo13Document.RROtherProjectInfo13 rrOtherProjectInfo) {
        RROtherProjectInfo13Document.RROtherProjectInfo13.OtherAttachments otherAttachments = (RROtherProjectInfo13Document.RROtherProjectInfo13.OtherAttachments)RROtherProjectInfo13Document.RROtherProjectInfo13.OtherAttachments.Factory.newInstance();
        otherAttachments.setOtherAttachmentArray(this.getAttachedFileDataTypes());
        rrOtherProjectInfo.setOtherAttachments(otherAttachments);
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        for (NarrativeContract narrative : developmentProposal.getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 8 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public RROtherProjectInfo13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRROtherProjectInfo();
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RROtherProjectInfo13Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            RROtherProjectInfo13Document.RROtherProjectInfo13.AbstractAttachments abstractAttachments = form.getRROtherProjectInfo13().getAbstractAttachments();
            if (abstractAttachments != null && abstractAttachments.getAbstractAttachment() != null && a.getContentId().equals(abstractAttachments.getAbstractAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.mandatoryFile0", a);
            }
            RROtherProjectInfo13Document.RROtherProjectInfo13.ProjectNarrativeAttachments projectNarrativeAttachments = form.getRROtherProjectInfo13().getProjectNarrativeAttachments();
            if (projectNarrativeAttachments != null && projectNarrativeAttachments.getProjectNarrativeAttachment() != null && a.getContentId().equals(projectNarrativeAttachments.getProjectNarrativeAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.mandatoryFile1", a);
            }
            RROtherProjectInfo13Document.RROtherProjectInfo13.BibliographyAttachments bibliographyAttachments = form.getRROtherProjectInfo13().getBibliographyAttachments();
            if (bibliographyAttachments != null && bibliographyAttachments.getBibliographyAttachment() != null && a.getContentId().equals(bibliographyAttachments.getBibliographyAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.optionalFile0", a);
            }
            RROtherProjectInfo13Document.RROtherProjectInfo13.FacilitiesAttachments facilitiesAttachments = form.getRROtherProjectInfo13().getFacilitiesAttachments();
            if (facilitiesAttachments != null && facilitiesAttachments.getFacilitiesAttachment() != null && a.getContentId().equals(facilitiesAttachments.getFacilitiesAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.optionalFile1", a);
            }
            RROtherProjectInfo13Document.RROtherProjectInfo13.EquipmentAttachments equipmentAttachments = form.getRROtherProjectInfo13().getEquipmentAttachments();
            if (equipmentAttachments != null && equipmentAttachments.getEquipmentAttachment() != null && a.getContentId().equals(equipmentAttachments.getEquipmentAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.optionalFile2", a);
            }
            RROtherProjectInfo13Document.RROtherProjectInfo13.OtherAttachments otherAttachments = form.getRROtherProjectInfo13().getOtherAttachments();
            if (otherAttachments != null && otherAttachments.getOtherAttachmentList() != null) {
                List<AttachedFileDataType> atts = otherAttachments.getOtherAttachmentList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_OtherProjectInfo_1_3_P1.optionalFile3_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RROtherProjectInfo13Document> factory() {
        return RROtherProjectInfo13Document.Factory;
    }
}

