/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrSF424V11.AORInfoType;
import gov.grants.apply.forms.rrSF424V11.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V11.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF424V11.RRSF424Document;
import gov.grants.apply.forms.rrSF424V11.RevisionTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V11.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF424V11.SubmissionTypeDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.OrganizationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.RRSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRSF424V1_1Generator")
public class RRSF424V1_1Generator
extends RRSF424BaseGenerator<RRSF424Document> {
    private static final Logger LOG = LogManager.getLogger(RRSF424V1_1Generator.class);
    private DepartmentalPersonDto departmentalPerson;
    private List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/RR_SF424-V1.1")
    private String namespace;
    @Value(value="RR_SF424-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SF424-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="120")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private RRSF424Document getRRSF424() {
        String cfdaNumber;
        String federalId;
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        DevelopmentProposalContract devProp = this.pdDoc.getDevelopmentProposal();
        RRSF424Document rrSF424Document = (RRSF424Document)RRSF424Document.Factory.newInstance();
        RRSF424Document.RRSF424 rrsf424 = (RRSF424Document.RRSF424)RRSF424Document.RRSF424.Factory.newInstance();
        rrsf424.setFormVersion(FormVersion.v1_1.getVersion());
        S2sOpportunityContract s2sOpportunity = devProp.getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionType() != null) {
            rrsf424.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forString(devProp.getS2sOpportunity().getS2sSubmissionType().getDescription()));
        }
        rrsf424.setSubmittedDate(this.departmentalPerson.getSubmittedDate());
        ProposalSiteContract applicantOrganization = devProp.getApplicantOrganization();
        if (applicantOrganization != null && applicantOrganization.getState() != null) {
            String state = applicantOrganization.getState();
            rrsf424.setStateID(state);
        }
        if (StringUtils.isNotBlank((CharSequence)(federalId = this.getFederalId()))) {
            rrsf424.setFederalID(federalId);
        }
        rrsf424.setApplicantInfo(this.getApplicationInfo());
        rrsf424.setApplicantType(this.getApplicantType());
        rrsf424.setApplicationType(this.getApplicationType());
        rrsf424.setEmployerID(this.getEmployerId());
        SponsorContract sponsor = devProp.getSponsor();
        if (sponsor != null) {
            rrsf424.setFederalAgencyName(sponsor.getSponsorName());
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            rrsf424.setCFDANumber(cfdaNumber);
        }
        if (devProp.getProgramAnnouncementTitle() != null) {
            String announcementTitle = devProp.getProgramAnnouncementTitle().length() > 120 ? devProp.getProgramAnnouncementTitle().substring(0, 120) : devProp.getProgramAnnouncementTitle();
            rrsf424.setActivityTitle(announcementTitle);
        }
        rrsf424.setProjectTitle(devProp.getTitle());
        if (devProp.getProposalAbstracts() != null) {
            List proposalAbstractList = devProp.getProposalAbstracts();
            String state = "";
            for (ProposalAbstractContract proposalAbstract : proposalAbstractList) {
                if (!proposalAbstract.getAbstractType().getCode().equals("16")) continue;
                state = proposalAbstract.getAbstractDetails();
            }
            rrsf424.setLocation(state);
        }
        rrsf424.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf424.setCongressionalDistrict(this.getCongDistrict());
        rrsf424.setPDPIContactInfo(this.getPDPI());
        try {
            rrsf424.setEstimatedProjectFunding(this.getProjectFunding());
        }
        catch (S2SException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return rrSF424Document;
        }
        rrsf424.setStateReview(this.getStateReview());
        rrsf424.setTrustAgree(YesNoDataType.Y_YES);
        rrsf424.setAORInfo(this.getAORInfoType());
        for (NarrativeContract narrative : devProp.getNarratives()) {
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case 6: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    rrsf424.setPreApplicationAttachment(attachedFileDataType);
                    break;
                }
                case 59: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    rrsf424.setAdditionalCongressionalDistricts(attachedFileDataType);
                }
            }
        }
        rrsf424.setAORSignature(this.departmentalPerson.getFullName());
        rrsf424.setAORSignedDate(this.departmentalPerson.getSubmittedDate());
        rrSF424Document.setRRSF424(rrsf424);
        return rrSF424Document;
    }

    private RRSF424Document.RRSF424.EstimatedProjectFunding getProjectFunding() throws S2SException {
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        RRSF424Document.RRSF424.EstimatedProjectFunding funding = (RRSF424Document.RRSF424.EstimatedProjectFunding)RRSF424Document.RRSF424.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        boolean hasBudgetLineItem = false;
        if (budget != null) {
            ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
            if (budget.getModularBudgetFlag().booleanValue()) {
                List allModularAmounts = this.modularBudgetService.getModularBudgetAmounts((BudgetContract)budget);
                ScaleTwoDecimal fundsRequested = ScaleTwoDecimal.ZERO;
                ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
                for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                    BudgetModularContract modularAmounts = this.modularBudgetService.getModularBudgetForPeriod(allModularAmounts, budgetPeriod);
                    totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)modularAmounts.getTotalDirectCost());
                    for (BudgetModularIdcContract budgetModularIdc : modularAmounts.getBudgetModularIdcs()) {
                        fundsRequested = (ScaleTwoDecimal)fundsRequested.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)totalDirectCost);
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)fundsRequested);
            } else {
                totalCost = budget.getTotalCost();
            }
            ScaleTwoDecimal fedNonFedCost = totalCost;
            BigDecimal totalProjectIncome = BigDecimal.ZERO;
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)costSharingAmount);
            for (BudgetProjectIncomeContract budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            funding = (RRSF424Document.RRSF424.EstimatedProjectFunding)RRSF424Document.RRSF424.EstimatedProjectFunding.Factory.newInstance();
            funding.setTotalEstimatedAmount(totalCost.bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(totalProjectIncome);
        }
        return funding;
    }

    private RRSF424Document.RRSF424.ApplicantInfo getApplicationInfo() {
        UnitContract leadUnit;
        RRSF424Document.RRSF424.ApplicantInfo appInfo = (RRSF424Document.RRSF424.ApplicantInfo)RRSF424Document.RRSF424.ApplicantInfo.Factory.newInstance();
        String contactType = this.getContactType();
        if (contactType.equals("I")) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                appInfo.setContactPersonInfo(this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex()));
            }
        } else {
            DepartmentalPersonDto depPerson = this.getContactPerson(this.pdDoc);
            RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo)RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
            if (depPerson != null) {
                contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (StringUtils.isNotEmpty((CharSequence)depPerson.getFaxNumber())) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
            }
            appInfo.setContactPersonInfo(contactInfo);
        }
        OrganizationDataType orgType = (OrganizationDataType)OrganizationDataType.Factory.newInstance();
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        orgType.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            orgType.setDUNSID(organization.getDunsNumber());
        }
        if ((leadUnit = this.pdDoc.getDevelopmentProposal().getOwnedByUnit()) != null) {
            orgType.setDepartmentName(this.getDepartmentName(leadUnit));
            String divisionName = this.s2sDivisionService.getDivisionFromUnit(leadUnit.getUnitNumber());
            if (divisionName != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        appInfo.setOrganizationInfo(orgType);
        return appInfo;
    }

    private RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo getContactInfo(RolodexContract rolodex) {
        RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo)RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(rolodex));
        contactInfo.setPhone("");
        if (rolodex != null) {
            contactInfo.setPhone(rolodex.getPhoneNumber());
            if (StringUtils.isNotEmpty((CharSequence)rolodex.getFaxNumber())) {
                contactInfo.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getEmailAddress() != null) {
                contactInfo.setEmail(rolodex.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF424Document.RRSF424.StateReview getStateReview() {
        Map<String, String> eoStateReview = this.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        String stateReviewDate = null;
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.Y_YES;
            stateReviewDate = eoStateReview.get("reviewDate");
        } else if ("N".equals(strReview)) {
            String stateReviewData = eoStateReview.get("stateReviewData");
            if ("Not Covered".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if ("Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        RRSF424Document.RRSF424.StateReview stateReview = (RRSF424Document.RRSF424.StateReview)RRSF424Document.RRSF424.StateReview.Factory.newInstance();
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        if (stateReviewDate != null) {
            stateReview.setStateReviewDate(this.s2SDateTimeService.convertDateStringToCalendar(stateReviewDate));
        }
        return stateReview;
    }

    private RRSF424Document.RRSF424.ApplicationType getApplicationType() {
        RRSF424Document.RRSF424.ApplicationType applicationType = (RRSF424Document.RRSF424.ApplicationType)RRSF424Document.RRSF424.ApplicationType.Factory.newInstance();
        Map<String, String> submissionInfo = this.getSubmissionType(this.pdDoc);
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            ApplicationTypeCodeDataType.Enum applicationTypeCodeDataType = ApplicationTypeCodeDataType.Enum.forInt(Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode()));
            applicationType.setApplicationTypeCode(applicationTypeCodeDataType);
            if (submissionInfo.get("revisionCode") != null) {
                String revisionCode = submissionInfo.get("revisionCode");
                RevisionTypeCodeDataType.Enum revisionCodeApplication = RevisionTypeCodeDataType.Enum.forString(revisionCode);
                applicationType.setRevisionCode(revisionCodeApplication);
            }
            if (submissionInfo.get("revisionOtherDescription") != null) {
                String revisionCodeOtherDesc = submissionInfo.get("revisionOtherDescription");
                applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherDesc);
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
            this.setProposalApplicationType(proposalTypeCode, applicationType);
        }
        Object answer = null;
        String answerdetails = this.getAnswer(ANSWER_128, this.answerHeaders);
        if (answerdetails != null && !answerdetails.equals("No")) {
            answer = answerdetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            applicationType.setIsOtherAgencySubmission((YesNoDataType.Enum)((Object)answer));
        } else {
            applicationType.setIsOtherAgencySubmission(null);
        }
        if (answer != null && answer.equals((Object)YesNoDataType.Y_YES)) {
            applicationType.setOtherAgencySubmissionExplanation(this.getOtherAgencySubmissionExplanation());
        }
        return applicationType;
    }

    private void setProposalApplicationType(String proposalTypeCode, RRSF424Document.RRSF424.ApplicationType applicationType) {
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(1));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(5));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(3));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(2));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(4));
        }
    }

    private RRSF424Document.RRSF424.ProposedProjectPeriod getProjectPeriod() {
        RRSF424Document.RRSF424.ProposedProjectPeriod proposedProjectPeriod = (RRSF424Document.RRSF424.ProposedProjectPeriod)RRSF424Document.RRSF424.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF424Document.RRSF424.CongressionalDistrict getCongDistrict() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        ProposalSiteContract performOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        RRSF424Document.RRSF424.CongressionalDistrict congressionalDistrict = (RRSF424Document.RRSF424.CongressionalDistrict)RRSF424Document.RRSF424.CongressionalDistrict.Factory.newInstance();
        if (applicantOrganization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        if (performOrganization != null) {
            congressionalDistrict.setProjectCongressionalDistrict(performOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setProjectCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = (OrganizationContactPersonDataType)OrganizationContactPersonDataType.Factory.newInstance();
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            ProposalPersonContract PI = proposalPerson;
            ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
            PDPI2.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    PDPI2.setTitle(PI.getDirectoryTitle());
                }
            }
            if (PI.getHomeUnit() != null) {
                PDPI2.setDepartmentName(this.getDepartmentName(PI.getPerson()));
            } else {
                DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
                PDPI2.setDepartmentName(this.getDepartmentName(developmentProposal.getOwnedByUnit()));
            }
            this.setDivisionName(PDPI2, PI);
            if (applicantOrganization == null) continue;
            PDPI2.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return PDPI2;
    }

    private void setDivisionName(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        String divisionName = this.s2sDivisionService.getDivision(PI);
        if (divisionName != null) {
            PDPI2.setDivisionName(divisionName);
        }
    }

    private AORInfoType getAORInfoType() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        AORInfoType aorInfoType = (AORInfoType)AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.globLibV20Generator.getHumanNameDataType(this.departmentalPerson));
            if (this.departmentalPerson.getPrimaryTitle() != null) {
                aorInfoType.setTitle(StringUtils.substring((String)this.departmentalPerson.getPrimaryTitle(), (int)0, (int)45));
            } else {
                aorInfoType.setTitle("");
            }
            aorInfoType.setAddress(this.globLibV20Generator.getAddressDataType(this.departmentalPerson));
            aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
            if (StringUtils.isNotEmpty((CharSequence)this.departmentalPerson.getFaxNumber())) {
                aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
            }
            aorInfoType.setDepartmentName(this.getDepartmentName(this.departmentalPerson));
            aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
            this.setDivisionName(aorInfoType, this.departmentalPerson);
        }
        if (applicantOrganization != null) {
            aorInfoType.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return aorInfoType;
    }

    private void setDivisionName(AORInfoType aorInfoType, DepartmentalPersonDto departmentalPerson) {
        String divisionName = this.getS2sDivisionService().getDivision(departmentalPerson);
        if (divisionName != null) {
            aorInfoType.setDivisionName(divisionName);
        }
    }

    private RRSF424Document.RRSF424.ApplicantType getApplicantType() {
        ApplicantTypeCodeDataType.Enum applicantTypeCode;
        RRSF424Document.RRSF424.ApplicantType applicantType = (RRSF424Document.RRSF424.ApplicantType)RRSF424Document.RRSF424.ApplicantType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = (RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType)RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = (RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged)RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = (RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned)RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = ((OrganizationTypeContract)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0)).getOrganizationTypeList().getCode();
        }
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            case 100: {
                applicantTypeCode = ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                break;
            }
            case 101: {
                applicantTypeCode = ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                break;
            }
            case 102: {
                applicantTypeCode = ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                break;
            }
            case 103: {
                applicantTypeCode = ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                break;
            }
            case 104: {
                applicantTypeCode = ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                break;
            }
            case 105: {
                applicantTypeCode = ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                break;
            }
            case 106: {
                applicantTypeCode = ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                break;
            }
            case 107: {
                applicantTypeCode = ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        if (orgTypeCode == 3) {
            applicantType.setApplicantTypeCodeOtherExplanation("Federal Government");
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    @Override
    public RRSF424Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.departmentalPersonService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424();
    }

    @Override
    protected List<? extends AnswerHeaderContract> getAnswerHeaders() {
        return this.answerHeaders;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRSF424Document> factory() {
        return RRSF424Document.Factory;
    }
}

