/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget14V14.RRBudget14Document;
import gov.grants.apply.forms.rrSubawardBudget14V14.RRSubawardBudget14Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRSubAwardBudget1_4V1_4Generator")
public class RRSubAwardBudget1_4V1_4Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget14Document>
implements S2SFormGeneratorPdfFillable<RRSubawardBudget14Document> {
    private static final String RR_BUDGET1_4_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget_1_4-V1.4";
    private static final String RR_BUDGET1_4_LOCAL_NAME = "RR_Budget_1_4";
    @Value(value="http://apply.grants.gov/forms/RR_SubawardBudget_1_4-V1.4")
    private String namespace;
    @Value(value="RR_SubawardBudget_1_4")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget-V1.4.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SubawardBudget_1_4-V1.4.pdf")
    private Resource pdfForm;
    @Value(value="177")
    private int sortIndex;

    private RRSubawardBudget14Document getRRSubawardBudgetDocument() throws S2SException {
        RRSubawardBudget14Document rrSubawardBudgetDocument = (RRSubawardBudget14Document)RRSubawardBudget14Document.Factory.newInstance();
        RRSubawardBudget14Document.RRSubawardBudget14 rrSubawardBudget = (RRSubawardBudget14Document.RRSubawardBudget14)RRSubawardBudget14Document.RRSubawardBudget14.Factory.newInstance();
        RRSubawardBudget14Document.RRSubawardBudget14.BudgetAttachments budgetAttachments = (RRSubawardBudget14Document.RRSubawardBudget14.BudgetAttachments)RRSubawardBudget14Document.RRSubawardBudget14.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, RR_BUDGET1_4_NAMESPACE_URI, false);
        ArrayList<RRBudget14Document.RRBudget14> budgetList = new ArrayList<RRBudget14Document.RRBudget14>();
        rrSubawardBudget.setFormVersion(FormVersion.v1_4.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRBudget14Document rrBudgetDocument = this.getRRBudget10(budgetSubAwards);
            if (rrBudgetDocument == null) continue;
            RRBudget14Document.RRBudget14 rrBudget = rrBudgetDocument.getRRBudget14();
            switch (attCount) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList.add(0, rrBudget);
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList.add(1, rrBudget);
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList.add(2, rrBudget);
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList.add(3, rrBudget);
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList.add(4, rrBudget);
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList.add(5, rrBudget);
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList.add(6, rrBudget);
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList.add(7, rrBudget);
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList.add(8, rrBudget);
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList.add(9, rrBudget);
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setRRBudget14Array(budgetList.toArray(new RRBudget14Document.RRBudget14[0]));
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget14(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget14Document getRRBudget10(BudgetSubAwardsContract budgetSubAwards) throws S2SException {
        RRBudget14Document rrBudget;
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = this.stringToDom(subAwdXML);
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET1_4_NAMESPACE_URI, RR_BUDGET1_4_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        byte[] subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
        try {
            rrBudget = (RRBudget14Document)RRBudget14Document.Factory.parse((InputStream)new ByteArrayInputStream(subAwdNodeBytes));
        }
        catch (IOException | XmlException e) {
            throw new RuntimeException(e);
        }
        return rrBudget;
    }

    @Override
    public RRSubawardBudget14Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRSubawardBudget14Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRSubawardBudget14Document> factory() {
        return RRSubawardBudget14Document.Factory;
    }
}

