/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sflll20V20.AwardeeDataType;
import gov.grants.apply.forms.sflll20V20.LobbyingActivitiesDisclosure20Document;
import gov.grants.apply.forms.sflll20V20.ReportDataType;
import gov.grants.apply.forms.sflll20V20.ReportEntityDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SFLLLBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SFLLL2_0V2_0Generator")
public class SFLLL2_0V2_0Generator
extends SFLLLBaseGenerator<LobbyingActivitiesDisclosure20Document>
implements S2SFormGeneratorPdfFillable<LobbyingActivitiesDisclosure20Document> {
    private DepartmentalPersonDto aorInfo;
    @Value(value="http://apply.grants.gov/forms/SFLLL_2_0-V2.0")
    private String namespace;
    @Value(value="SFLLL2_0V2_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SFLLL_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SFLLL_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private LobbyingActivitiesDisclosure20Document getLobbyingActivitiesDisclosure() {
        LobbyingActivitiesDisclosure20Document lobbyinADDocument = (LobbyingActivitiesDisclosure20Document)LobbyingActivitiesDisclosure20Document.Factory.newInstance();
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20 lobbyingDisclosure = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.Factory.newInstance();
        lobbyingDisclosure.setFormVersion(FormVersion.v2_0.getVersion());
        lobbyingDisclosure.setFederalActionType(LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalActionType.GRANT);
        lobbyingDisclosure.setFederalActionStatus(LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalActionStatus.BID_OFFER);
        lobbyingDisclosure.setReportType(ReportDataType.INITIAL_FILING);
        lobbyingDisclosure.setReportEntity(this.getReportEntity());
        lobbyingDisclosure.setFederalAgencyDepartment("");
        SponsorContract sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            if (sponsor.getSponsorName() != null) {
                lobbyingDisclosure.setFederalAgencyDepartment(StringUtils.substring((String)sponsor.getSponsorName(), (int)0, (int)40));
            }
        } else {
            SponsorContract primeSponsor;
            String primeSponsorCode = this.pdDoc.getDevelopmentProposal().getPrimeSponsor().getSponsorCode();
            if (primeSponsorCode != null && (primeSponsor = this.pdDoc.getDevelopmentProposal().getPrimeSponsor()).getSponsorName() != null) {
                lobbyingDisclosure.setFederalAgencyDepartment(StringUtils.substring((String)primeSponsor.getSponsorName(), (int)0, (int)40));
            }
        }
        lobbyingDisclosure.setFederalProgramName(this.getFedProgramName());
        lobbyingDisclosure.setLobbyingRegistrant(this.getLobbyingRegistrant());
        lobbyingDisclosure.setIndividualsPerformingServices(this.getIndividualsPerformingServices());
        lobbyingDisclosure.setSignatureBlock(this.getSignatureBlock());
        lobbyinADDocument.setLobbyingActivitiesDisclosure20(lobbyingDisclosure);
        return lobbyinADDocument;
    }

    private LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.SignatureBlock getSignatureBlock() {
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.SignatureBlock signatureBlock = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.SignatureBlock)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.SignatureBlock.Factory.newInstance();
        signatureBlock.setName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            signatureBlock.setTitle(StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        if (this.aorInfo.getOfficePhone() != null) {
            signatureBlock.setTelephone(StringUtils.substring((String)this.aorInfo.getOfficePhone(), (int)0, (int)25));
        }
        signatureBlock.setSignature(this.aorInfo.getFullName());
        signatureBlock.setSignedDate(this.aorInfo.getSubmittedDate());
        return signatureBlock;
    }

    private LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant getLobbyingRegistrant() {
        RolodexContract rolodex;
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant lobbyingRegistrant = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant.Factory.newInstance();
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        RolodexContract rolodexContract = rolodex = organization != null && organization.getLobbyingRegistrant() != null ? this.rolodexService.getRolodex(organization.getLobbyingRegistrant()) : null;
        if (rolodex != null) {
            HumanNameDataType individualName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant.Address address = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant.Address)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.LobbyingRegistrant.Address.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                individualName.setFirstName(StringUtils.substring((String)rolodex.getFirstName(), (int)0, (int)35));
            }
            if (rolodex.getMiddleName() != null) {
                individualName.setMiddleName(StringUtils.substring((String)rolodex.getMiddleName(), (int)0, (int)25));
            }
            if (rolodex.getLastName() != null) {
                individualName.setLastName(StringUtils.substring((String)rolodex.getLastName(), (int)0, (int)60));
            }
            if (rolodex.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)rolodex.getAddressLine1(), (int)0, (int)55));
            }
            if (rolodex.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)rolodex.getAddressLine2(), (int)0, (int)55));
            }
            if (rolodex.getCity() != null) {
                address.setCity(StringUtils.substring((String)rolodex.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataTypeV3(rolodex.getCountryCode(), rolodex.getState()).ifPresent(address::setState);
            address.setZipPostalCode(rolodex.getPostalCode());
            lobbyingRegistrant.setIndividualName(individualName);
            lobbyingRegistrant.setAddress(address);
        } else {
            HumanNameDataType naName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            naName.setFirstName("N/A");
            naName.setLastName("N/A");
            lobbyingRegistrant.setIndividualName(naName);
        }
        return lobbyingRegistrant;
    }

    private LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices getIndividualsPerformingServices() {
        RolodexContract rolodex;
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices individualServices = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Factory.newInstance();
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual individual = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual.Factory.newInstance();
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        RolodexContract rolodexContract = rolodex = organization != null && organization.getLobbyingIndividual() != null ? this.rolodexService.getRolodex(organization.getLobbyingIndividual()) : null;
        if (rolodex != null) {
            HumanNameDataType name = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual.Address address = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual.Address)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual.Address.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                name.setFirstName(StringUtils.substring((String)rolodex.getFirstName(), (int)0, (int)35));
            }
            if (rolodex.getMiddleName() != null) {
                name.setMiddleName(StringUtils.substring((String)rolodex.getMiddleName(), (int)0, (int)25));
            }
            if (rolodex.getLastName() != null) {
                name.setLastName(StringUtils.substring((String)rolodex.getLastName(), (int)0, (int)60));
            }
            if (rolodex.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)rolodex.getAddressLine1(), (int)0, (int)55));
            }
            if (rolodex.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)rolodex.getAddressLine2(), (int)0, (int)55));
            }
            if (rolodex.getCity() != null) {
                address.setCity(StringUtils.substring((String)rolodex.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataTypeV3(rolodex.getCountryCode(), rolodex.getState()).ifPresent(address::setState);
            address.setZipPostalCode(rolodex.getPostalCode());
            individual.setName(name);
            individual.setAddress(address);
        } else {
            HumanNameDataType naName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            naName.setFirstName("N/A");
            naName.setLastName("N/A");
            individual.setName(naName);
        }
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual[] individualArray = new LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.IndividualsPerformingServices.Individual[]{individual};
        individualServices.setIndividualArray(individualArray);
        return individualServices;
    }

    private LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalProgramName getFedProgramName() {
        String cfdaNumber;
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalProgramName federalProgramName = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalProgramName)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.FederalProgramName.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            federalProgramName.setFederalProgramName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle(), (int)0, (int)120));
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            federalProgramName.setCFDANumber(cfdaNumber);
        }
        return federalProgramName;
    }

    private LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.ReportEntity getReportEntity() {
        LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.ReportEntity reportEntity = (LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.ReportEntity)LobbyingActivitiesDisclosure20Document.LobbyingActivitiesDisclosure20.ReportEntity.Factory.newInstance();
        reportEntity.setReportEntityType(ReportEntityDataType.PRIME);
        reportEntity.setReportEntityIsPrime(YesNoDataType.Y_YES);
        AwardeeDataType awardeeDataType = (AwardeeDataType)AwardeeDataType.Factory.newInstance();
        awardeeDataType.setEntityType(ReportEntityDataType.PRIME);
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            if (proposalSite.getLocationName() != null) {
                awardeeDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            }
            if (organization.getCongressionalDistrict() != null) {
                awardeeDataType.setCongressionalDistrict(StringUtils.substring((String)organization.getCongressionalDistrict(), (int)0, (int)6));
            }
        }
        AwardeeDataType.Address address = (AwardeeDataType.Address)AwardeeDataType.Address.Factory.newInstance();
        if (proposalSite != null) {
            if (proposalSite.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)proposalSite.getAddressLine1(), (int)0, (int)55));
            }
            if (proposalSite.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)proposalSite.getAddressLine2(), (int)0, (int)55));
            }
            if (proposalSite.getCity() != null) {
                address.setCity(StringUtils.substring((String)proposalSite.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataTypeV3(proposalSite.getCountryCode(), proposalSite.getState()).ifPresent(address::setState);
            address.setZipPostalCode(proposalSite.getPostalCode());
        }
        awardeeDataType.setAddress(address);
        reportEntity.setReportingEntity(awardeeDataType);
        return reportEntity;
    }

    @Override
    public LobbyingActivitiesDisclosure20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getLobbyingActivitiesDisclosure();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(LobbyingActivitiesDisclosure20Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<LobbyingActivitiesDisclosure20Document> factory() {
        return LobbyingActivitiesDisclosure20Document.Factory;
    }
}

