/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.ProjFieldCodeType;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0Generator")
public class SupplementaryCoverSheetforNEHGrantPrograms_3_0V3_0
extends S2SBaseFormGenerator<SupplementaryCoverSheetforNEHGrantPrograms30Document> {
    private static final int MAJOR_FIELD_OF_STUDY = 1;
    private static final int INSTITUTION_TYPE = 2;
    private static final int FEDERAL_MATCH = 3;
    private static final int NEH_DIVISION = 4;
    private static final int NEH_DIVISION_EXPLANATION = 5;
    private static final int FUNDING = 6;
    private static final int PRIMARY_PROJECT_DISCIPLINE = 7;
    private static final int SECONDARY_PROJECT_DISCIPLINE_EXISTS = 8;
    private static final int SECONDARY_PROJECT_DISCIPLINE = 9;
    private static final int TERTIARY_PROJECT_DISCIPLINE_EXISTS = 10;
    private static final int TERTIARY_PROJECT_DISCIPLINE = 11;
    @Value(value="http://apply.grants.gov/forms/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0")
    private String namespace;
    @Value(value="SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public SupplementaryCoverSheetforNEHGrantPrograms30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        ScaleTwoDecimal totalProject;
        ScaleTwoDecimal totalFromNEH;
        this.pdDoc = proposalDevelopmentDocument;
        SupplementaryCoverSheetforNEHGrantPrograms30Document document = (SupplementaryCoverSheetforNEHGrantPrograms30Document)SupplementaryCoverSheetforNEHGrantPrograms30Document.Factory.newInstance();
        SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30 cs = (SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30)SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.Factory.newInstance();
        SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ProjectFundingGroup projectFundingGroup = (SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ProjectFundingGroup)SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ProjectFundingGroup.Factory.newInstance();
        SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup applicationInfoGroup = (SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup)SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup.Factory.newInstance();
        cs.setFormVersion(FormVersion.v3_0.getVersion());
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        questionnaireAnswers.stream().filter(qa -> qa.getAnswer() != null).forEach(qa -> {
            String answer = qa.getAnswer();
            if (qa.getQuestionNumber() == 1) {
                cs.setPDMajorField(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.PDMajorField.Enum.forString(answer));
            } else if (qa.getQuestionNumber() == 2) {
                cs.setOrganizationType(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.OrganizationType.Enum.forString(answer));
            } else if (qa.getQuestionNumber() == 3) {
                projectFundingGroup.setReqMatchAmount(new BigDecimal(answer));
            } else if (qa.getQuestionNumber() == 4) {
                if (answer.equals(YnqConstant.YES.code())) {
                    applicationInfoGroup.setAdditionalFunding(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup.AdditionalFunding.YES);
                    questionnaireAnswers.stream().filter(subQa -> subQa.getAnswer() != null).filter(subQa -> subQa.getQuestionNumber() == 5).findFirst().ifPresent(subQa -> applicationInfoGroup.setAddFundingExplanation(subQa.getAnswer()));
                } else {
                    applicationInfoGroup.setAdditionalFunding(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup.AdditionalFunding.NO);
                }
            } else if (qa.getQuestionNumber() == 6) {
                if (answer.equals(YnqConstant.YES.code())) {
                    applicationInfoGroup.setTypeofApplication(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup.TypeofApplication.SUPPLEMENT);
                    if (StringUtils.isNotBlank((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getSponsorProposalNumber())) {
                        applicationInfoGroup.setSupGrantNumber(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorProposalNumber());
                    }
                } else {
                    applicationInfoGroup.setTypeofApplication(SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup.TypeofApplication.NEW);
                }
            } else if (qa.getQuestionNumber() == 7) {
                applicationInfoGroup.setProjFieldCode(ProjFieldCodeType.Enum.forString(answer));
            } else if (qa.getQuestionNumber() == 8) {
                if (answer.equals(YnqConstant.YES.code())) {
                    questionnaireAnswers.stream().filter(subQa -> subQa.getAnswer() != null).filter(subQa -> subQa.getQuestionNumber() == 9).findFirst().ifPresent(subQa -> applicationInfoGroup.setProjFieldCode2(ProjFieldCodeType.Enum.forString(subQa.getAnswer())));
                }
            } else if (qa.getQuestionNumber() == 10 && answer.equals(YnqConstant.YES.code())) {
                questionnaireAnswers.stream().filter(subQa -> subQa.getAnswer() != null).filter(subQa -> subQa.getQuestionNumber() == 11).findFirst().ifPresent(subQa -> applicationInfoGroup.setProjFieldCode3(ProjFieldCodeType.Enum.forString(subQa.getAnswer())));
            }
        });
        S2SBudgetDto budgetSummary = this.s2sBudgetInfoService.getBudgetInfo(this.pdDoc);
        if (budgetSummary.getCumTotalCosts() != null) {
            projectFundingGroup.setReqOutrightAmount(budgetSummary.getCumTotalCosts().bigDecimalValue());
        }
        if ((totalFromNEH = this.getTotalFromNeh(projectFundingGroup.getReqMatchAmount(), budgetSummary.getCumTotalCosts())) != null) {
            projectFundingGroup.setTotalFromNEH(totalFromNEH.bigDecimalValue());
        }
        if (budgetSummary.getCumTotalCostSharing() != null) {
            projectFundingGroup.setCostSharing(budgetSummary.getCumTotalCostSharing().bigDecimalValue());
        }
        if ((totalProject = this.getTotalProject(budgetSummary.getCumTotalCostSharing(), totalFromNEH)) != null) {
            projectFundingGroup.setTotalProjectCosts(totalProject.bigDecimalValue());
        }
        cs.setProjectFundingGroup(projectFundingGroup);
        cs.setApplicationInfoGroup(applicationInfoGroup);
        document.setSupplementaryCoverSheetforNEHGrantPrograms30(cs);
        return document;
    }

    private ScaleTwoDecimal getTotalProject(ScaleTwoDecimal cumTotalCostSharing, ScaleTwoDecimal totalFromNEH) {
        ScaleTwoDecimal totalProject = totalFromNEH != null && cumTotalCostSharing != null ? (ScaleTwoDecimal)totalFromNEH.add((AbstractDecimal)cumTotalCostSharing) : (totalFromNEH != null ? totalFromNEH : cumTotalCostSharing);
        return totalProject;
    }

    private ScaleTwoDecimal getTotalFromNeh(BigDecimal reqMatchAmount, ScaleTwoDecimal cumTotalCosts) {
        ScaleTwoDecimal totalFromNEH = cumTotalCosts != null && reqMatchAmount != null ? (ScaleTwoDecimal)cumTotalCosts.add((AbstractDecimal)new ScaleTwoDecimal(reqMatchAmount)) : (reqMatchAmount != null ? new ScaleTwoDecimal(reqMatchAmount) : cumTotalCosts);
        return totalFromNEH;
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return this.s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    @Override
    public DocumentFactory<SupplementaryCoverSheetforNEHGrantPrograms30Document> factory() {
        return SupplementaryCoverSheetforNEHGrantPrograms30Document.Factory;
    }
}

