/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.person;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.person.attr.CitizenshipTypeService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SProposalPersonService")
public class S2SProposalPersonServiceImpl
implements S2SProposalPersonService {
    @Autowired
    @Qualifier(value="citizenshipTypeService")
    private CitizenshipTypeService citizenshipTypeService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    @Override
    public List<ProposalPersonContract> getNKeyPersons(List<? extends ProposalPersonContract> proposalPersons, int n) {
        int size = proposalPersons.size();
        for (int i = size - 1; i > 0; --i) {
            ProposalPersonContract proposalPerson = proposalPersons.get(i);
            ProposalPersonContract previousProposalPerson = proposalPersons.get(i - 1);
            if (proposalPerson.getPersonId() != null && previousProposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(previousProposalPerson.getPersonId())) {
                proposalPersons.remove(i);
                continue;
            }
            if (proposalPerson.getRolodexId() == null || previousProposalPerson.getRolodexId() == null || !proposalPerson.getRolodexId().equals(previousProposalPerson.getRolodexId())) continue;
            proposalPersons.remove(i);
        }
        size = proposalPersons.size();
        ArrayList<ProposalPersonContract> firstNPersons = new ArrayList<ProposalPersonContract>();
        if (size > n) {
            size = n;
        }
        for (int i = 0; i < size; ++i) {
            firstNPersons.add(proposalPersons.get(i));
        }
        return firstNPersons;
    }

    @Override
    public ProposalPersonContract getPrincipalInvestigator(ProposalDevelopmentDocumentContract pdDoc) {
        ProposalPersonContract proposalPerson = null;
        if (pdDoc != null) {
            for (ProposalPersonContract person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!person.isPrincipalInvestigator()) continue;
                proposalPerson = person;
            }
        }
        return proposalPerson;
    }

    @Override
    public List<ProposalPersonContract> getCoInvestigators(ProposalDevelopmentDocumentContract pdDoc) {
        ArrayList<ProposalPersonContract> investigators = new ArrayList<ProposalPersonContract>();
        if (pdDoc != null) {
            for (ProposalPersonContract person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!person.isCoInvestigator() && !person.isMultiplePi()) continue;
                investigators.add(person);
            }
        }
        return investigators;
    }

    @Override
    public List<ProposalPersonContract> getKeyPersons(ProposalDevelopmentDocumentContract pdDoc) {
        ArrayList<ProposalPersonContract> keyPersons = new ArrayList<ProposalPersonContract>();
        if (pdDoc != null) {
            for (ProposalPersonContract person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!person.isKeyPerson()) continue;
                keyPersons.add(person);
            }
        }
        return keyPersons;
    }

    @Override
    public CitizenshipType getCitizenship(ProposalPersonContract proposalPerson) {
        return this.citizenshipTypeService.getPersonCitizenshipType(proposalPerson);
    }

    @Override
    public String getPersonUei(ProposalPersonContract proposalPerson) {
        Integer rolodexId = proposalPerson.getRolodexId();
        if (rolodexId == null) {
            return null;
        }
        RolodexContract rolodex = this.rolodexService.getRolodex(rolodexId);
        if (rolodex == null || rolodex.getOrganizationUei() == null || rolodex.getOrganizationUei().isEmpty()) {
            return null;
        }
        return rolodex.getOrganizationUei();
    }
}

