/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.impl.custom.arg.ArgValueLookupValuesFinder;
import org.kuali.coeus.common.util.Wrapper;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.util.KeyValue;

public interface CustomDataNotificationRenderer {
    default public Map<String, String> getCustomDataReplacementParameters() {
        CustomDataContainer customDataContainer = this.getCustomDataContainer();
        if (customDataContainer != null && customDataContainer.getCustomDataList() != null) {
            return customDataContainer.getCustomDataList().stream().map(cd -> {
                String value;
                boolean argValue;
                List<Wrapper<String>> listValue = cd.getDeserializedListValue();
                if (listValue != null) {
                    return CollectionUtils.entry(String.valueOf(cd.getCustomAttributeId()), listValue);
                }
                boolean bl = argValue = StringUtils.isNotBlank((CharSequence)cd.getCustomAttribute().getLookupClass()) && cd.getCustomAttribute().getLookupClass().equals(ArgValueLookup.class.getName());
                if (argValue) {
                    ArgValueLookupValuesFinder valuesFinder = new ArgValueLookupValuesFinder();
                    valuesFinder.setArgName(cd.getCustomAttribute().getLookupReturn());
                    valuesFinder.setAddBlankOption(false);
                    value = valuesFinder.getKeyValues().stream().filter(kvValue -> kvValue.getKey().equals(cd.getValue())).map(KeyValue::getValue).findAny().orElse(null);
                } else {
                    value = cd.getValue();
                }
                return CollectionUtils.entry(String.valueOf(cd.getCustomAttributeId()), value != null ? List.of(new Wrapper<String>(value)) : Collections.emptyList());
            }).filter(entry -> Objects.nonNull(entry.getValue())).map(entry -> CollectionUtils.entry("{SUPP_INFO_" + (String)entry.getKey() + "}", ((List)entry.getValue()).stream().map(Wrapper::getValue).collect(Collectors.joining(", ")))).collect(CollectionUtils.entriesToMapWithReplacing());
        }
        return Collections.emptyMap();
    }

    public CustomDataContainer getCustomDataContainer();
}

