/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sRequestConfigDto;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="s2sSubmissionDao")
public class S2sSubmissionDaoJdbcImpl
implements S2sSubmissionDao {
    protected static final String DEFAULT_S2S_CONNECTOR_SERVICE_NAME = "grantsGovConnectorService";
    private static final String SUBMISSION_REQUEST_INFO = "select distinct duns_number, connector_service_name from eps_prop_sites sites inner join organization org on sites.organization_id = org.organization_id left outer join s2s_opportunity opp on sites.proposal_number = opp.proposal_number left outer join s2s_providers provider on opp.provider = provider.code where sites.location_type_code = 1 and sites.proposal_number = ?";
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public Optional<S2sRequestConfigDto> getSubmissionRequestInfo(S2sAppSubmission submission) {
        try {
            S2sRequestConfigDto s2sRequestConfig = (S2sRequestConfigDto)this.jdbcOperations.queryForObject(SUBMISSION_REQUEST_INFO, new Object[]{submission.getProposalNumber()}, (rs, rowNum) -> new S2sRequestConfigDto(rs.getString("duns_number"), rs.getString("connector_service_name")));
            if (StringUtils.isBlank((CharSequence)s2sRequestConfig.getConnectorServiceName())) {
                return Optional.of(new S2sRequestConfigDto(s2sRequestConfig.getDunsNumber(), DEFAULT_S2S_CONNECTOR_SERVICE_NAME));
            }
            return Optional.of(s2sRequestConfig);
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }
}

