/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.springframework.web.servlet.DispatcherServlet;

public class ConditionalInitDispatcherServlet
extends DispatcherServlet {
    public static final String INIT_CONFIG_PROPERTY_NAME = "initConfigPropertyName";
    public static final String INIT_CONFIG_PROPERTY_VALUE = "initConfigPropertyValue";

    public void init(ServletConfig config) throws ServletException {
        if (this.doInit(config)) {
            super.init(config);
        } else {
            config.getServletContext().log("Not Initialized Spring FrameworkServlet '" + this.getServletName(config) + "'");
        }
    }

    private String getServletName(ServletConfig config) {
        return config != null ? config.getServletName() : null;
    }

    private boolean doInit(ServletConfig config) {
        String configProperty;
        String initConfigPropertyName = config.getInitParameter(INIT_CONFIG_PROPERTY_NAME);
        String initConfigPropertyValue = config.getInitParameter(INIT_CONFIG_PROPERTY_VALUE);
        boolean init = false;
        if (StringUtils.isNotBlank((CharSequence)initConfigPropertyName) && StringUtils.equals((CharSequence)initConfigPropertyValue, (CharSequence)(configProperty = this.getConfigPropertyValue(initConfigPropertyName)))) {
            init = true;
        }
        return init;
    }

    private String getConfigPropertyValue(String name) {
        return ConfigContext.getCurrentContextConfig().getProperty(name);
    }
}

