/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.kra.external.service.KcDtoServiceBase;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardAccountDtoServiceImpl
extends KcDtoServiceBase<AwardAccountDTO, Award> {
    private ParameterService parameterService;
    private InstitutionalProposalService institutionalProposalService;

    @Override
    public AwardAccountDTO buildDto(Award award) {
        AwardAccountDTO awardAccountDTO = new AwardAccountDTO();
        awardAccountDTO.setProposalFederalPassThroughAgencyNumber(award.getSponsorCode());
        awardAccountDTO.setGrantNumber(award.getSponsorAwardNumber());
        awardAccountDTO.setInstitutionalproposalId(this.getProposalId(award));
        awardAccountDTO.setAwardId(award.getAwardId());
        if (ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator())) {
            awardAccountDTO.setProjectDirector(award.getPrincipalInvestigator().getPersonId());
        } else {
            awardAccountDTO.setProjectDirector(null);
        }
        awardAccountDTO.setProposalNumber(award.getAwardNumber());
        awardAccountDTO.setSponsorCode(award.getSponsorCode());
        awardAccountDTO.setSponsorName(award.getSponsorName());
        awardAccountDTO.setFederalSponsor(this.isFederalSponsor(award));
        awardAccountDTO.setAwardTitle(award.getTitle());
        awardAccountDTO.setPrimeSponsorCode(award.getPrimeSponsorCode());
        if (ObjectUtils.isNotNull((Object)award.getPrimeSponsor())) {
            awardAccountDTO.setPrimeSponsorName(award.getPrimeSponsor().getSponsorName());
            awardAccountDTO.setPrimeSponsorTypeCode(award.getPrimeSponsor().getSponsorTypeCode());
        } else {
            awardAccountDTO.setPrimeSponsorTypeCode(null);
            awardAccountDTO.setPrimeSponsorName(null);
        }
        if (ObjectUtils.isNotNull((Object)award.getSponsor())) {
            awardAccountDTO.setSponsorTypeCode(award.getSponsor().getSponsorTypeCode());
        } else {
            awardAccountDTO.setSponsorTypeCode(null);
        }
        return awardAccountDTO;
    }

    protected Long getProposalId(Award award) {
        return this.getInstitutionalProposalService().getProposalId(award);
    }

    protected boolean isFederalSponsor(Award award) {
        return this.parameterService.getParameterValuesAsString(AwardDocument.class, "FEDERAL_SPONSOR_TYPE_CODE").stream().filter(StringUtils::isNotBlank).distinct().anyMatch(federalSponsorTypeCode -> this.isFederal(award.getSponsor(), (String)federalSponsorTypeCode) || this.isFederal(award.getPrimeSponsor(), (String)federalSponsorTypeCode));
    }

    protected boolean isFederal(Sponsor sponsor, String federalSponsorTypeCode) {
        if (ObjectUtils.isNotNull((Object)sponsor) && ObjectUtils.isNotNull((Object)sponsor.getSponsorTypeCode())) {
            return sponsor.getSponsorTypeCode().equals(federalSponsorTypeCode);
        }
        return false;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

