/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTotaler {
    protected Logger logger = LoggerFactory.getLogger(TableTotaler.class);
    public static final TableTotaler NULL = new TableTotaler();
    protected Map<Integer, Integer> firstRowForEachGroup = new HashMap<Integer, Integer>();
    protected int howManyGroups = 0;
    protected Integer currentRowNumber = 0;
    protected TableModel tableModel;
    List<Integer> openedColumns = new ArrayList<Integer>();
    TreeMap<Integer, String> groupingValuesByColumn = new TreeMap();
    List<Integer> closedColumns = new ArrayList<Integer>();
    public static final Integer WHOLE_TABLE = 0;

    public void init(TableModel model) {
        this.tableModel = model;
        this.firstRowForEachGroup = new HashMap<Integer, Integer>();
        for (HeaderCell c : model.getHeaderCellList()) {
            if (c.getGroup() <= 0) continue;
            this.firstRowForEachGroup.put(c.getGroup(), 0);
            ++this.howManyGroups;
        }
    }

    public void initRow(int currentViewIndex, int currentListIndex) {
        this.openedColumns.clear();
        this.closedColumns.clear();
        this.currentRowNumber = currentListIndex;
    }

    public int asColumn(int groupNumber) {
        return groupNumber;
    }

    public int asGroup(int columnNumber) {
        return columnNumber;
    }

    public void startGroup(String groupingValue, int groupNumber) {
        this.openedColumns.add(this.asColumn(groupNumber));
        this.groupingValuesByColumn.put(this.asColumn(groupNumber), groupingValue);
        this.firstRowForEachGroup.put(groupNumber, this.currentRowNumber);
    }

    public List<Integer> getOpenedColumns() {
        return new ArrayList<Integer>(this.openedColumns);
    }

    public List<Integer> getClosedColumns() {
        return this.closedColumns;
    }

    public void stopGroup(String value, int groupNumber) {
        this.closedColumns.add(this.asColumn(groupNumber));
    }

    public Object add(Column column, Object total, Object value) {
        if (value == null) {
            return total;
        }
        if (value instanceof Number) {
            Number oldTotal = 0.0;
            if (total != null) {
                oldTotal = (Number)total;
            }
            return oldTotal + ((Number)value).doubleValue();
        }
        throw new UnsupportedOperationException("Cannot add a value of " + String.valueOf(value) + " in column " + column.getHeaderCell().getTitle());
    }

    public String formatTotal(HeaderCell cell, Object total) {
        if (total == null) {
            total = "";
        }
        return total instanceof String ? (String)total : total.toString();
    }

    protected Object getTotalForList(List<Row> window, int columnNumber) {
        Object total = null;
        for (Row row : window) {
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
                Object value = null;
                try {
                    value = column.getValue(false);
                }
                catch (DecoratorException | ObjectLookupException e) {
                    this.logger.error("", (Throwable)((Object)e));
                }
                if (value == null || "".equals(value)) continue;
                total = this.add(column, total, value);
            }
        }
        return total;
    }

    public Object getTotalForColumn(int columnNumber, int groupNumber) {
        List<Row> fullList = this.tableModel.getRowListFull();
        Integer startRow = this.firstRowForEachGroup.get(groupNumber);
        Integer stopRow = this.currentRowNumber + 1;
        if (groupNumber == WHOLE_TABLE) {
            startRow = 0;
        }
        List<Row> window = fullList.subList(startRow, stopRow);
        return this.getTotalForList(window, columnNumber);
    }

    public String getGroupingValue(Integer columnNumber) {
        return this.groupingValuesByColumn.get(columnNumber);
    }

    public void reset() {
        this.closedColumns.clear();
        this.openedColumns.clear();
        this.groupingValuesByColumn.clear();
        this.currentRowNumber = 0;
        this.howManyGroups = 0;
        this.firstRowForEachGroup.clear();
    }
}

