/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ChecklistV11.PHS398ChecklistDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398ChecklistBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398ChecklistV1_1Generator")
public class PHS398ChecklistV1_1Generator
extends PHS398ChecklistBaseGenerator<PHS398ChecklistDocument> {
    private static final int FEDERAL_ID_MAX_LENGTH = 30;
    List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/PHS398_Checklist-V1.1")
    private String namespace;
    @Value(value="PHS398_Checklist-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_Checklist-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="230")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private PHS398ChecklistDocument getPHS398Checklist() {
        ProposalDevelopmentBudgetExtContract budget;
        PHS398ChecklistDocument phsChecklistDocument = (PHS398ChecklistDocument)PHS398ChecklistDocument.Factory.newInstance();
        PHS398ChecklistDocument.PHS398Checklist phsChecklist = (PHS398ChecklistDocument.PHS398Checklist)PHS398ChecklistDocument.PHS398Checklist.Factory.newInstance();
        phsChecklist.setFormVersion(FormVersion.v1_1.getVersion());
        PHS398ChecklistDocument.PHS398Checklist.ApplicationType.Enum applicationEnum = null;
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (this.pdDoc.getDevelopmentProposal().getProposalType() != null && Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode()) < 6) {
            applicationEnum = PHS398ChecklistDocument.PHS398Checklist.ApplicationType.Enum.forInt(Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode()));
        }
        phsChecklist.setApplicationType(applicationEnum);
        String federalId = this.getSubmissionInfoService().getFederalId(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (federalId != null) {
            phsChecklist.setFederalID(StringUtils.substring((String)federalId.trim(), (int)0, (int)30));
        }
        String pIChange = this.getAnswer(PROPOSAL_YNQ_QUESTION_114, this.answerHeaders);
        String pIChangeExplanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_115, this.answerHeaders);
        if (YnqConstant.YES.code().equals(pIChange)) {
            RolodexContract rolodex;
            HumanNameDataType formerPDName;
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (pIChangeExplanation != null && (formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex = this.rolodexService.getRolodex(Integer.valueOf(pIChangeExplanation)))) != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                phsChecklist.setFormerPDName(formerPDName);
            }
        } else {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
        String institutionChange = this.getAnswer(PROPOSAL_YNQ_QUESTION_116, this.answerHeaders);
        String institutionChangeExplanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_117, this.answerHeaders);
        if (YnqConstant.YES.code().equals(institutionChange)) {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (institutionChangeExplanation != null) {
                phsChecklist.setFormerInstitutionName(institutionChangeExplanation);
            }
        } else {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
        String renewalApplication = this.getAnswer(PROPOSAL_YNQ_QUESTION_118, this.answerHeaders);
        boolean hasSubQuestionExplanation = false;
        if (renewalApplication != null && !renewalApplication.equals("No")) {
            if (YnqConstant.YES.code().equals(renewalApplication)) {
                String inventionsConceived = this.getAnswer(PROPOSAL_YNQ_QUESTION_119, this.answerHeaders);
                if (YnqConstant.YES.code().equals(inventionsConceived)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    String reportedPreviously = this.getAnswer(PROPOSAL_YNQ_QUESTION_120, this.answerHeaders);
                    if (reportedPreviously != null && !reportedPreviously.equals("No")) {
                        if (YnqConstant.YES.code().equals(reportedPreviously)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.Y_YES);
                        } else {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                        }
                        hasSubQuestionExplanation = true;
                    }
                } else {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    if (hasSubQuestionExplanation) {
                        phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                    }
                }
            } else {
                phsChecklist.setIsInventionsAndPatents(YesNoDataType.N_NO);
                if (hasSubQuestionExplanation) {
                    phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                }
            }
        }
        if ((budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal())) != null && budget.getBudgetProjectIncomes().size() > 0) {
            this.setProjectIncome(phsChecklist, (BudgetContract)budget);
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 38 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHS398ChecklistDocument.PHS398Checklist.CertificationExplanation certExplanation = (PHS398ChecklistDocument.PHS398Checklist.CertificationExplanation)PHS398ChecklistDocument.PHS398Checklist.CertificationExplanation.Factory.newInstance();
            certExplanation.setCertifications(attachedFileDataType);
            phsChecklist.setCertificationExplanation(certExplanation);
        }
        phsChecklistDocument.setPHS398Checklist(phsChecklist);
        return phsChecklistDocument;
    }

    private void setProjectIncome(PHS398ChecklistDocument.PHS398Checklist phsChecklist, BudgetContract budget) {
        TreeMap<Integer, PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod>();
        for (BudgetProjectIncomeContract projectIncome : budget.getBudgetProjectIncomes()) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = projectIncome.getBudgetPeriodNumber();
            PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod incomeBudgPeriod = (PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = (PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod)PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber);
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(projectIncome.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = this.getProjectIncomeDescription(projectIncome);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        Collection incomeBudgetPeriodCollection = incomeBudgetPeriodMap.values();
        phsChecklist.setIncomeBudgetPeriodArray(incomeBudgetPeriodCollection.toArray(new PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod[0]));
    }

    protected String getProjectIncomeDescription(BudgetProjectIncomeContract projectIncome) {
        String description = null;
        if (projectIncome.getDescription() != null) {
            description = projectIncome.getDescription().length() > 150 ? projectIncome.getDescription().substring(0, 150) : projectIncome.getDescription();
        }
        return description;
    }

    @Override
    public PHS398ChecklistDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398Checklist();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398ChecklistDocument> factory() {
        return PHS398ChecklistDocument.Factory;
    }
}

