/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phsFellowshipSupplemental40V40.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental40V40.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental40V40.NonUSCitizenDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental40V40.PHSFellowshipSupplemental40Document;
import gov.grants.apply.forms.phsFellowshipSupplementalV10.CitizenshipDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398FellowshipSupplementalBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398FellowshipSupplementalV4_0Generator")
public class PHS398FellowshipSupplementalV4_0Generator
extends PHS398FellowshipSupplementalBaseGenerator<PHSFellowshipSupplemental40Document>
implements S2SFormGeneratorPdfFillable<PHSFellowshipSupplemental40Document> {
    private static final Logger LOG = LogManager.getLogger(PHS398FellowshipSupplementalV4_0Generator.class);
    private static final char DATE_SEPARATOR = '/';
    private static final int DEGREE_TYPE_SOUGHT = 99;
    private static final int OTHER_DBOTH = 100;
    private static final String SPONSOR_COSPONSOR = "134";
    private static final String LETTER_COLLAB_CONTRIB_CONSULT = "157";
    private static final String PHS_FELLOW_INSTITUTION_ENVIRON_COMMITMENT = "158";
    private static final String PHS_FELLOW_AUTH_KEY_BIO_CHEM_RESOURCES = "160";
    private static final int ARE_VERTEBRATE_ANIMALS_EUTHANISED = 146;
    private static final String INTRODUCTION_TO_APPLICATION = "97";
    private static final String SPECIFIC_AIMS = "98";
    private static final String RESEARCH_STRATEGY = "127";
    private static final String RESPECTIVE_CONTRIBUTIONS = "88";
    private static final String SELECTION_OF_SPONSOR_AND_INSTITUTION = "89";
    private static final String PROGRESS_REPORT_PUBLICATION_LIST = "103";
    private static final String RESPONSIBLE_CONDUCT_OF_RESEARCH = "90";
    private static final String CONCURRENT_SUPPORT = "91";
    private static final String VERTEBRATE_ANIMALS = "108";
    private static final String SELECT_AGENT_RESEARCH = "109";
    private static final String RESOURCE_SHARING_PLANS = "110";
    private static final int CONSISTENT_AVMA_GUIDELINES = 147;
    private static final int NO_AVMA_METHOD_SCIENTIFIC_JUSTIFICATION = 148;
    private static final int FIELD_OF_TRAINING = 200;
    private static final String FELLOWSHIP_BACKGROUND_AND_GOALS = "156";
    private static final String TEMPORARY_VISA_ALSO_APPLIED_FOR_PERMANENT_RESIDENT_STATUS = "Temporary Visa also applied for permanent resident status";
    private static final ScaleTwoDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01);
    @Value(value="http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_4_0-V4.0")
    private String namespace;
    @Value(value="PHS_Fellowship_Supplemental_4_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS_FellowshipSupplemental-V4.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS_Fellowship_Supplemental_4_0-V4.0.pdf")
    private Resource pdfForm;
    @Value(value="211")
    private int sortIndex;

    protected PHSFellowshipSupplemental40Document getPHSFellowshipSupplemental40() {
        PHSFellowshipSupplemental40Document phsFellowshipSupplementalDocument = (PHSFellowshipSupplemental40Document)PHSFellowshipSupplemental40Document.Factory.newInstance();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40 phsFellowshipSupplemental = phsFellowshipSupplementalDocument.addNewPHSFellowshipSupplemental40();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan researchTrainingPlan = phsFellowshipSupplemental.addNewResearchTrainingPlan();
        this.setNarrativeDataForResearchTrainingPlan(phsFellowshipSupplemental, researchTrainingPlan);
        this.setOtherResearchTrainingPlanVertebrate(phsFellowshipSupplemental);
        phsFellowshipSupplemental.setFormVersion(FormVersion.v4_0.getVersion());
        AttachmentGroupMin0Max100DataType appendix = this.getAppendix();
        if (appendix != null) {
            phsFellowshipSupplemental.setAppendix(appendix);
        }
        this.setQuestionnaireData(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    private void setOtherResearchTrainingPlanVertebrate(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40 phsFellowshipSupplemental) {
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan otherResearchTrainingPlan = phsFellowshipSupplemental.getOtherResearchTrainingPlan();
        if (otherResearchTrainingPlan == null) {
            otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
        }
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionId = question.getQuestionSeqId();
                if (answer == null) continue;
                switch (questionId) {
                    case 146: {
                        otherResearchTrainingPlan.setAreAnimalsEuthanized(this.getYesNoEnum(answer));
                        break;
                    }
                    case 147: {
                        otherResearchTrainingPlan.setAVMAConsistentIndicator(this.getYesNoEnum(answer));
                        break;
                    }
                    case 148: {
                        otherResearchTrainingPlan.setEuthanasiaMethodDescription(answer);
                    }
                }
            }
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null) continue;
            if (code.equalsIgnoreCase(VERTEBRATE_ANIMALS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.VertebrateAnimals)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                vertebrateAnimals.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                continue;
            }
            if (code.equalsIgnoreCase(SELECT_AGENT_RESEARCH)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.SelectAgentResearch selectAgentResearch = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.SelectAgentResearch)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                selectAgentResearch.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                continue;
            }
            if (code.equalsIgnoreCase(RESOURCE_SHARING_PLANS)) {
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.ResourceSharingPlan)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                resourceSharingPlan.setAttFile(attachedFileDataType);
                if (otherResearchTrainingPlan == null) {
                    otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
                }
                otherResearchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                continue;
            }
            if (!code.equalsIgnoreCase(PHS_FELLOW_AUTH_KEY_BIO_CHEM_RESOURCES)) continue;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources.Factory.newInstance();
            attachedFileDataType = this.addAttachedFileType(narrative);
            if (attachedFileDataType == null) continue;
            keyBiologicalAndOrChemicalResources.setAttFile(attachedFileDataType);
            if (otherResearchTrainingPlan == null) {
                otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
            }
            otherResearchTrainingPlan.setKeyBiologicalAndOrChemicalResources(keyBiologicalAndOrChemicalResources);
        }
    }

    private void setQuestionnaireData(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40 phsFellowshipSupplemental) {
        Object questionId;
        HashMap<Integer, String> hmBudgetQuestions = new HashMap<Integer, String>();
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan otherResearchTrainingPlan = phsFellowshipSupplemental.getOtherResearchTrainingPlan();
        if (otherResearchTrainingPlan == null) {
            otherResearchTrainingPlan = phsFellowshipSupplemental.addNewOtherResearchTrainingPlan();
        }
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(otherResearchTrainingPlan);
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation additionalInfoType = phsFellowshipSupplemental.addNewAdditionalInformation();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.GraduateDegreeSought)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.StemCells stemCellstype = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.StemCells)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.StemCells.Factory.newInstance();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvKirsch = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            block40: for (QuestionnaireQuestionContract questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                Integer questionNumber = questionnaireQuestion.getQuestionNumber();
                Integer parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                questionId = question.getQuestionSeqId();
                if (answer != null) {
                    switch ((Integer)questionId) {
                        case 5: {
                            stemCellstype.setIsHumanStemCellsInvolved(this.getYesNoEnum(answer));
                            break;
                        }
                        case 6: {
                            stemCellstype.setStemCellsIndicator(answer.equals(YnqConstant.NO.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                            break;
                        }
                        case 7: {
                            List<AnswerContract> answerList = this.getAnswers(questionnaireQuestion, answerHeader);
                            for (AnswerContract questionnaireAnswerBO : answerList) {
                                String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                                if (questionnaireSubAnswer == null) continue;
                                stemCellstype.addCellLines(questionnaireAnswerBO.getAnswer());
                            }
                            continue block40;
                        }
                        case 99: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString(answer));
                            break;
                        }
                        case 35: {
                            graduateDegreeSought.setDegreeDate(answer.substring(0, 2) + "/" + answer.substring(6, 10));
                            break;
                        }
                        case 16: {
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 18: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 19: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 21: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 100: {
                            if (!((Object)((Object)graduateDegreeSought.getDegreeType())).equals((Object)DegreeTypeDataType.OTH_OTHER)) continue block40;
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 17: {
                            graduateDegreeSought.setDegreeType(DegreeTypeDataType.DOTH_OTHER_DOCTORATE);
                            graduateDegreeSought.setOtherDegreeTypeText(answer);
                            break;
                        }
                        case 23: 
                        case 200: {
                            if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) continue block40;
                            FieldOfTrainingDataType.Enum fieldOfTraining = FieldOfTrainingDataType.Enum.forString(answer);
                            additionalInfoType.setFieldOfTraining(fieldOfTraining);
                            break;
                        }
                        case 24: {
                            additionalInfoType.setCurrentPriorNRSASupportIndicator(this.getYesNoEnum(answer));
                            break;
                        }
                        case 27: 
                        case 32: 
                        case 33: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 49: {
                            if ((Integer)questionId == 43) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 44;
                            }
                            if ((Integer)questionId == 49) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 45;
                            }
                            if ((Integer)questionId == 46) {
                                if (!answer.equals("N")) continue block40;
                                answer = "Unknown";
                                questionId = 27;
                            }
                            PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean cbKirschstein = new PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean();
                            cbKirschstein.setAnswer(answer);
                            cbKirschstein.setQuestionId((Integer)questionId);
                            cbKirschstein.setQuestionNumber(questionNumber);
                            cbKirschstein.setParentQuestionNumber(parentQuestionNumber);
                            cvKirsch.add(cbKirschstein);
                            break;
                        }
                        case 28: {
                            additionalInfoType.setChangeOfInstitution(this.getYesNoEnum(answer));
                            break;
                        }
                        case 29: {
                            additionalInfoType.setFormerInstitution(answer);
                            break;
                        }
                        case 36: {
                            hmBudgetQuestions.put(36, answer);
                            break;
                        }
                        case 37: {
                            hmBudgetQuestions.put(37, answer);
                            break;
                        }
                        case 41: {
                            hmBudgetQuestions.put(41, answer);
                            break;
                        }
                        case 38: {
                            hmBudgetQuestions.put(38, answer);
                            break;
                        }
                        case 51: {
                            hmBudgetQuestions.put(51, answer);
                            break;
                        }
                        case 40: {
                            hmBudgetQuestions.put(40, answer);
                            break;
                        }
                        case 50: {
                            hmBudgetQuestions.put(50, answer);
                            break;
                        }
                        case 48: {
                            hmBudgetQuestions.put(48, answer);
                            break;
                        }
                        case 47: {
                            hmBudgetQuestions.put(47, answer);
                            break;
                        }
                    }
                    continue;
                }
                if (answer != null) continue;
                switch ((Integer)questionId) {
                    case 200: {
                        additionalInfoType.setFieldOfTraining(null);
                        break;
                    }
                    case 5: {
                        stemCellstype.setIsHumanStemCellsInvolved(null);
                        break;
                    }
                    case 24: {
                        additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                        break;
                    }
                }
            }
        }
        if (stemCellstype != null) {
            additionalInfoType.setStemCells(stemCellstype);
        }
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInfoType.setGraduateDegreeSought(graduateDegreeSought);
        }
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvType = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvStart = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvEnd = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvLevel = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean> cvGrant = new ArrayList<PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean>();
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean2 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean3 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean4 = null;
        PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean5 = null;
        if (additionalInfoType.getCurrentPriorNRSASupportIndicator() != null) {
            if (((Object)((Object)additionalInfoType.getCurrentPriorNRSASupportIndicator())).equals((Object)YesNoDataType.Y_YES)) {
                cvKirsch.sort(BY_QUESTION_NUMBER);
                questionId = cvKirsch.iterator();
                while (questionId.hasNext()) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean aCvKirsch;
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean = aCvKirsch = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)questionId.next();
                    switch (kbBean.getQuestionId()) {
                        case 32: {
                            cvLevel.add(kbBean);
                            break;
                        }
                        case 33: {
                            cvType.add(kbBean);
                            break;
                        }
                        case 44: {
                            cvStart.add(kbBean);
                            break;
                        }
                        case 45: {
                            cvEnd.add(kbBean);
                            break;
                        }
                        case 27: {
                            cvGrant.add(kbBean);
                        }
                    }
                }
            }
            ArrayList<PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport>();
            int numberRepeats = cvLevel.size();
            if (numberRepeats > 0) {
                for (int j = 0; j < numberRepeats; ++j) {
                    PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean kbBean1 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvLevel.get(j);
                    if (cvType.size() - 1 >= j) {
                        kbBean2 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvType.get(j);
                    }
                    if (cvStart.size() - 1 >= j) {
                        kbBean3 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvStart.get(j);
                    }
                    if (cvEnd.size() - 1 >= j) {
                        kbBean4 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvEnd.get(j);
                    }
                    if (cvGrant.size() - 1 >= j) {
                        kbBean5 = (PHS398FellowshipSupplementalBaseGenerator.KirschsteinBean)cvGrant.get(j);
                    }
                    PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport nrsaSupportType = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
                    if (kbBean1 != null) {
                        nrsaSupportType.setLevel(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString(kbBean1.getAnswer()));
                    }
                    if (kbBean2 != null) {
                        nrsaSupportType.setType(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString(kbBean2.getAnswer()));
                    }
                    if (kbBean3 != null && !kbBean3.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setStartDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean3.getAnswer()));
                    }
                    if (kbBean4 != null && !kbBean4.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setEndDate(this.s2SDateTimeService.convertDateStringToCalendar(kbBean4.getAnswer()));
                    }
                    if (kbBean5 != null) {
                        nrsaSupportType.setGrantNumber(kbBean5.getAnswer());
                    }
                    currentPriorNRSASupportList.add(nrsaSupportType);
                }
            }
            additionalInfoType.setCurrentPriorNRSASupportArray(currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.CurrentPriorNRSASupport[0]));
        }
        phsFellowshipSupplemental.setBudget(this.createBudgetElements(hmBudgetQuestions));
        this.setAdditionalInformation(additionalInfoType);
    }

    protected PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget createBudgetElements(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget budget = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.Factory.newInstance();
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        this.getInstitutionalBaseSalary(budget, budgetMap);
        this.getFederalStipendRequested(budget);
        this.getSupplementationFromOtherSources(budget, budgetMap);
        this.setTuitionRequestedYears(budget);
        return budget;
    }

    protected void setTuitionRequestedYears(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget budget) {
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget == null) {
            return;
        }
        ScaleTwoDecimal tuitionTotal = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
            ScaleTwoDecimal tuition = ScaleTwoDecimal.ZERO;
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tuition = (ScaleTwoDecimal)tuition.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
            tuitionTotal = (ScaleTwoDecimal)tuitionTotal.add((AbstractDecimal)tuition);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tuition.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tuition.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tuition.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tuition.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tuition.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tuition.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tuitionTotal.bigDecimalValue());
        if (!tuitionTotal.equals((Object)ScaleTwoDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    protected void getSupplementationFromOtherSources(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget budget, Map<Integer, String> hmBudgetQuestions) {
        if (!hmBudgetQuestions.isEmpty() && hmBudgetQuestions.get(37) != null && hmBudgetQuestions.get(37).toUpperCase().equals("Y")) {
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.SupplementationFromOtherSources supplementationFromOtherSources = budget.addNewSupplementationFromOtherSources();
            if (hmBudgetQuestions.get(41) != null) {
                supplementationFromOtherSources.setSource(hmBudgetQuestions.get(41));
                supplementationFromOtherSources.setAmount(new BigDecimal(hmBudgetQuestions.get(38)));
                try {
                    supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(hmBudgetQuestions.get(51)));
                }
                catch (NumberFormatException ex) {
                    LOG.error((Object)ex);
                }
                supplementationFromOtherSources.setType(hmBudgetQuestions.get(40));
            }
        }
    }

    protected void getFederalStipendRequested(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget budget) {
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.FederalStipendRequested federalStipendRequested = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.FederalStipendRequested)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.FederalStipendRequested.Factory.newInstance();
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget != null) {
            ScaleTwoDecimal sumOfLineItemCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal numberOfMonths = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                    sumOfLineItemCost = (ScaleTwoDecimal)sumOfLineItemCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)budgetLineItem.getBudgetPersonnelDetailsList())) {
                        for (BudgetPersonnelDetailsContract details : budgetLineItem.getBudgetPersonnelDetailsList()) {
                            ScaleTwoDecimal detailsNumberOfMonths = details.getPercentEffort() != null ? (ScaleTwoDecimal)this.getNumberOfMonths(details.getStartDate(), details.getEndDate()).multiply((AbstractDecimal)((ScaleTwoDecimal)details.getPercentEffort().multiply((AbstractDecimal)POINT_ZERO_ONE))) : this.getNumberOfMonths(details.getStartDate(), details.getEndDate());
                            numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)detailsNumberOfMonths);
                        }
                        continue;
                    }
                    numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
                }
            }
            federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
            federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
            budget.setFederalStipendRequested(federalStipendRequested);
        }
    }

    protected void getInstitutionalBaseSalary(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget budget, Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.InstitutionalBaseSalary institutionalBaseSalary = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.InstitutionalBaseSalary)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.InstitutionalBaseSalary.Factory.newInstance();
        if (budgetMap.get(36) != null && budgetMap.get(36).equals(YnqConstant.YES.code())) {
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47)));
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString(budgetMap.get(48)));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50)));
            }
            budget.setInstitutionalBaseSalary(institutionalBaseSalary);
        }
    }

    protected void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40 phsFellowshipSupplemental, PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan researchTrainingPlan) {
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors sponsors = phsFellowshipSupplemental.addNewSponsors();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment institutionalEnvironment = phsFellowshipSupplemental.addNewInstitutionalEnvironment();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant fellowshipApplicant = phsFellowshipSupplemental.addNewFellowshipApplicant();
        PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction introduction = phsFellowshipSupplemental.addNewIntroduction();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null) continue;
            if (code.equalsIgnoreCase(INTRODUCTION_TO_APPLICATION)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction.IntroductionToApplication introductionToApplication = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction.IntroductionToApplication)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction.IntroductionToApplication.Factory.newInstance();
                introductionToApplication.setAttFile(attachedFileDataType);
                introduction.setIntroductionToApplication(introductionToApplication);
                continue;
            }
            if (code.equalsIgnoreCase(FELLOWSHIP_BACKGROUND_AND_GOALS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals backgroundandGoals = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals.Factory.newInstance();
                backgroundandGoals.setAttFile(attachedFileDataType);
                fellowshipApplicant.setBackgroundandGoals(backgroundandGoals);
                continue;
            }
            if (code.equalsIgnoreCase(SPECIFIC_AIMS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims specificAims = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims.Factory.newInstance();
                specificAims.setAttFile(attachedFileDataType);
                researchTrainingPlan.setSpecificAims(specificAims);
                continue;
            }
            if (code.equalsIgnoreCase(RESEARCH_STRATEGY)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy researchStrategy = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance();
                researchStrategy.setAttFile(attachedFileDataType);
                researchTrainingPlan.setResearchStrategy(researchStrategy);
                continue;
            }
            if (code.equalsIgnoreCase(RESPECTIVE_CONTRIBUTIONS)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution respectiveContribution = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution.Factory.newInstance();
                respectiveContribution.setAttFile(attachedFileDataType);
                researchTrainingPlan.setRespectiveContribution(respectiveContribution);
                continue;
            }
            if (code.equalsIgnoreCase(SELECTION_OF_SPONSOR_AND_INSTITUTION)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution sponsorAndInstitution = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution.Factory.newInstance();
                sponsorAndInstitution.setAttFile(attachedFileDataType);
                researchTrainingPlan.setSponsorandInstitution(sponsorAndInstitution);
                continue;
            }
            if (code.equalsIgnoreCase(PROGRESS_REPORT_PUBLICATION_LIST)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ProgressReportPublicationList)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                progressReportPublicationList.setAttFile(attachedFileDataType);
                researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                continue;
            }
            if (code.equalsIgnoreCase(RESPONSIBLE_CONDUCT_OF_RESEARCH)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch responsibleConductOfResearch = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch.Factory.newInstance();
                responsibleConductOfResearch.setAttFile(attachedFileDataType);
                researchTrainingPlan.setTrainingInResponsibleConductOfResearch(responsibleConductOfResearch);
                continue;
            }
            if (code.equalsIgnoreCase(SPONSOR_COSPONSOR)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.SponsorAndCoSponsorStatements sponsorCosponsorInfo = sponsors.addNewSponsorAndCoSponsorStatements();
                sponsorCosponsorInfo.setAttFile(attachedFileDataType);
                continue;
            }
            if (code.equalsIgnoreCase(LETTER_COLLAB_CONTRIB_CONSULT)) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.LettersOfSupport lettersOfSupport = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.LettersOfSupport)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.LettersOfSupport.Factory.newInstance();
                lettersOfSupport.setAttFile(attachedFileDataType);
                sponsors.setLettersOfSupport(lettersOfSupport);
                continue;
            }
            if (!code.equalsIgnoreCase(PHS_FELLOW_INSTITUTION_ENVIRON_COMMITMENT) || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment.InstitutionalEnvironmentCommitmenttoTraining institutionalEnvironmentCommitmenttoTraining = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment.InstitutionalEnvironmentCommitmenttoTraining)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment.InstitutionalEnvironmentCommitmenttoTraining.Factory.newInstance();
            institutionalEnvironmentCommitmenttoTraining.setAttFile(attachedFileDataType);
            institutionalEnvironment.setInstitutionalEnvironmentCommitmenttoTraining(institutionalEnvironmentCommitmenttoTraining);
        }
        this.setMandatoryAttachmentsOnResearchTrainingPlan(researchTrainingPlan);
        this.setMandatoryAttachmentsOnFellowshipApplicant(fellowshipApplicant);
    }

    private void setMandatoryAttachmentsOnFellowshipApplicant(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant fellowshipApplicant) {
        if (fellowshipApplicant.getBackgroundandGoals() == null) {
            fellowshipApplicant.setBackgroundandGoals((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals.Factory.newInstance());
        }
    }

    private void setMandatoryAttachmentsOnResearchTrainingPlan(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan researchTrainingPlan) {
        if (researchTrainingPlan.getSpecificAims() == null) {
            researchTrainingPlan.setSpecificAims((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims.Factory.newInstance());
        }
        if (researchTrainingPlan.getResearchStrategy() == null) {
            researchTrainingPlan.setResearchStrategy((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance());
        }
        if (researchTrainingPlan.getRespectiveContribution() == null) {
            researchTrainingPlan.setRespectiveContribution((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution.Factory.newInstance());
        }
        if (researchTrainingPlan.getSponsorandInstitution() == null) {
            researchTrainingPlan.setSponsorandInstitution((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution.Factory.newInstance());
        }
        if (researchTrainingPlan.getTrainingInResponsibleConductOfResearch() == null) {
            researchTrainingPlan.setTrainingInResponsibleConductOfResearch((PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch.Factory.newInstance());
        }
    }

    protected void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (!"2".equals(propSpecialReview.getSpecialReviewType().getCode())) continue;
            researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
        }
    }

    private void setAdditionalInformation(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation additionalInformation) {
        this.setCitizenshipAndAlternatePhoneNumber(additionalInformation);
        this.setAdditionalInformationConcurrentSupport(additionalInformation);
    }

    private void setCitizenshipAndAlternatePhoneNumber(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation additionalInformation) {
        ProposalPersonContract principalInvestigator = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            CitizenshipType citizenShip;
            if (!proposalPerson.isPrincipalInvestigator() || (citizenShip = this.s2SProposalPersonService.getCitizenship(proposalPerson)) == null || !StringUtils.isNotBlank((CharSequence)citizenShip.getCitizenShip())) continue;
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.N_NO);
                additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_TEMPORARY_U_S_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.N_NO);
                additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_PERMANENT_U_S_RESIDENT_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                additionalInformation.setUSCitizen(YesNoDataType.Y_YES);
                continue;
            }
            if (!citizenShip.getCitizenShip().trim().equals(TEMPORARY_VISA_ALSO_APPLIED_FOR_PERMANENT_RESIDENT_STATUS)) continue;
            additionalInformation.setUSCitizen(YesNoDataType.N_NO);
            additionalInformation.setNonUSCitizen(NonUSCitizenDataType.WITH_A_TEMPORARY_U_S_VISA);
            additionalInformation.setPermanentResidentByAwardIndicator(YesNoDataType.Y_YES);
        }
        if (additionalInformation.getUSCitizen() == null && additionalInformation.getNonUSCitizen() == null) {
            additionalInformation.setUSCitizen(YesNoDataType.N_NO);
            additionalInformation.setNonUSCitizen(null);
        }
        if (principalInvestigator != null && StringUtils.isNotEmpty((CharSequence)principalInvestigator.getMobilePhoneNumber())) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
    }

    private void setAdditionalInformationConcurrentSupport(PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation additionalInformation) {
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            String code = narrative.getNarrativeType().getCode();
            if (code == null || !code.equalsIgnoreCase(CONCURRENT_SUPPORT) || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = (PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.ConcurrentSupportDescription)PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
            concurrentSupportDescription.setAttFile(attachedFileDataType);
            additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
            additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
        }
    }

    @Override
    public PHSFellowshipSupplemental40Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHSFellowshipSupplemental40();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHSFellowshipSupplemental40Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation additionalInformation;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment institutionalEnvironment;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.InstitutionalEnvironment.InstitutionalEnvironmentCommitmenttoTraining institutionalEnvironmentCommitmenttoTraining;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant fellowshipApplicant;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.FellowshipApplicant.BackgroundandGoals backgroundandGoals;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction introduction;
            PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Introduction.IntroductionToApplication introductionToApplication;
            if (form.getPHSFellowshipSupplemental40().getIntroduction() != null && (introductionToApplication = (introduction = form.getPHSFellowshipSupplemental40().getIntroduction()).getIntroductionToApplication()) != null && introductionToApplication.getAttFile() != null && a.getContentId().equals(introductionToApplication.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile0", a);
            }
            if (form.getPHSFellowshipSupplemental40().getFellowshipApplicant() != null && (backgroundandGoals = (fellowshipApplicant = form.getPHSFellowshipSupplemental40().getFellowshipApplicant()).getBackgroundandGoals()) != null && backgroundandGoals.getAttFile() != null && a.getContentId().equals(backgroundandGoals.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile0", a);
            }
            if (form.getPHSFellowshipSupplemental40().getResearchTrainingPlan() != null) {
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan researchTrainingPlan = form.getPHSFellowshipSupplemental40().getResearchTrainingPlan();
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SpecificAims specificAims = researchTrainingPlan.getSpecificAims();
                if (specificAims != null && specificAims.getAttFile() != null && a.getContentId().equals(specificAims.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile1", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ResearchStrategy researchStrategy = researchTrainingPlan.getResearchStrategy();
                if (researchStrategy != null && researchStrategy.getAttFile() != null && a.getContentId().equals(researchStrategy.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile2", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.RespectiveContribution respectiveContribution = researchTrainingPlan.getRespectiveContribution();
                if (respectiveContribution != null && respectiveContribution.getAttFile() != null && a.getContentId().equals(respectiveContribution.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile3", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.SponsorandInstitution sponsorandInstitution = researchTrainingPlan.getSponsorandInstitution();
                if (sponsorandInstitution != null && sponsorandInstitution.getAttFile() != null && a.getContentId().equals(sponsorandInstitution.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile4", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = researchTrainingPlan.getProgressReportPublicationList();
                if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile1", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.ResearchTrainingPlan.TrainingInResponsibleConductOfResearch trainingInResponsibleConductOfResearch = researchTrainingPlan.getTrainingInResponsibleConductOfResearch();
                if (trainingInResponsibleConductOfResearch != null && trainingInResponsibleConductOfResearch.getAttFile() != null && a.getContentId().equals(trainingInResponsibleConductOfResearch.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.mandatoryFile5", a);
                }
            }
            if (form.getPHSFellowshipSupplemental40().getSponsors() != null) {
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors sponsors = form.getPHSFellowshipSupplemental40().getSponsors();
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.SponsorAndCoSponsorStatements sponsorAndCoSponsorStatements = sponsors.getSponsorAndCoSponsorStatements();
                if (sponsorAndCoSponsorStatements != null && sponsorAndCoSponsorStatements.getAttFile() != null && a.getContentId().equals(sponsorAndCoSponsorStatements.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile2", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.Sponsors.LettersOfSupport lettersOfSupport = sponsors.getLettersOfSupport();
                if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile3", a);
                }
            }
            if (form.getPHSFellowshipSupplemental40().getInstitutionalEnvironment() != null && (institutionalEnvironmentCommitmenttoTraining = (institutionalEnvironment = form.getPHSFellowshipSupplemental40().getInstitutionalEnvironment()).getInstitutionalEnvironmentCommitmenttoTraining()) != null && institutionalEnvironmentCommitmenttoTraining.getAttFile() != null && a.getContentId().equals(institutionalEnvironmentCommitmenttoTraining.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile4", a);
            }
            if (form.getPHSFellowshipSupplemental40().getOtherResearchTrainingPlan() != null) {
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan otherResearchTrainingPlan = form.getPHSFellowshipSupplemental40().getOtherResearchTrainingPlan();
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = otherResearchTrainingPlan.getVertebrateAnimals();
                if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P1.optionalFile5", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.SelectAgentResearch selectAgentResearch = otherResearchTrainingPlan.getSelectAgentResearch();
                if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P2.optionalFile0", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = otherResearchTrainingPlan.getResourceSharingPlan();
                if (resourceSharingPlan != null && resourceSharingPlan.getAttFile() != null && a.getContentId().equals(resourceSharingPlan.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P2.optionalFile1", a);
                }
                PHSFellowshipSupplemental40Document.PHSFellowshipSupplemental40.OtherResearchTrainingPlan.KeyBiologicalAndOrChemicalResources keyBiologicalAndOrChemicalResources = otherResearchTrainingPlan.getKeyBiologicalAndOrChemicalResources();
                if (keyBiologicalAndOrChemicalResources != null && keyBiologicalAndOrChemicalResources.getAttFile() != null && a.getContentId().equals(keyBiologicalAndOrChemicalResources.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P2.optionalFile2", a);
                }
            }
            if (form.getPHSFellowshipSupplemental40().getAdditionalInformation() != null && (concurrentSupportDescription = (additionalInformation = form.getPHSFellowshipSupplemental40().getAdditionalInformation()).getConcurrentSupportDescription()) != null && concurrentSupportDescription.getAttFile() != null && a.getContentId().equals(concurrentSupportDescription.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P2.optionalFile3", a);
            }
            if (form.getPHSFellowshipSupplemental40().getAppendix() != null && form.getPHSFellowshipSupplemental40().getAppendix().getAttachedFileList() != null) {
                List<AttachedFileDataType> atts = form.getPHSFellowshipSupplemental40().getAppendix().getAttachedFileList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("PHS_Fellowship_Supplemental_4_0_P2.optionalFile_4_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHSFellowshipSupplemental40Document> factory() {
        return PHSFellowshipSupplemental40Document.Factory;
    }
}

