/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ModularBudget12V12.PHS398ModularBudget12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398ModularBudgetBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398ModularBudgetV1_2Generator")
public class PHS398ModularBudgetV1_2Generator
extends PHS398ModularBudgetBaseGenerator<PHS398ModularBudget12Document>
implements S2SFormGeneratorPdfFillable<PHS398ModularBudget12Document> {
    private ScaleTwoDecimal cumulativeConsortiumFandA = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeDirectCostLessConsortiumFandA = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedDirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedDirectIndirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedIndirectCost = ScaleTwoDecimal.ZERO;
    @Value(value="http://apply.grants.gov/forms/PHS398_ModularBudget_1_2-V1.2")
    private String namespace;
    @Value(value="PHS398_ModularBudget_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ModularBudget-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_ModularBudget_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="190")
    private int sortIndex;

    private PHS398ModularBudget12Document getPHS398ModularBudget() {
        PHS398ModularBudget12Document modularBudgetDocument = (PHS398ModularBudget12Document)PHS398ModularBudget12Document.Factory.newInstance();
        PHS398ModularBudget12Document.PHS398ModularBudget12 modularBudget = (PHS398ModularBudget12Document.PHS398ModularBudget12)PHS398ModularBudget12Document.PHS398ModularBudget12.Factory.newInstance();
        modularBudget.setFormVersion(FormVersion.v1_2.getVersion());
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            modularBudget.setPeriodsArray(this.getPeriods((BudgetContract)budget));
            modularBudget.setCummulativeBudgetInfo(this.getCummBudget());
        }
        modularBudgetDocument.setPHS398ModularBudget12(modularBudget);
        return modularBudgetDocument;
    }

    private PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo getCummBudget() {
        PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo cummulativeBudgetInfo = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.Factory.newInstance();
        PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.EntirePeriodTotalCost entireCost = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.EntirePeriodTotalCost)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.EntirePeriodTotalCost.Factory.newInstance();
        entireCost.setCumulativeDirectCostLessConsortiumFandA(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
        PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        if (!this.cumulativeTotalFundsRequestedDirectIndirectCosts.toString().equals("0")) {
            entireCost.setCumulativeDirectCostLessConsortiumFandA(this.cumulativeDirectCostLessConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectCosts(this.cumulativeTotalFundsRequestedDirectCosts.bigDecimalValue());
            entireCost.setCumulativeConsortiumFandA(this.cumulativeConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(this.cumulativeTotalFundsRequestedDirectIndirectCosts.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedIndirectCost(this.cumulativeTotalFundsRequestedIndirectCost.bigDecimalValue());
            budgetJustifications = this.getBudgetJustifications();
            if (budgetJustifications.getAdditionalNarrativeJustification() != null || budgetJustifications.getConsortiumJustification() != null || budgetJustifications.getPersonnelJustification() != null) {
                cummulativeBudgetInfo.setBudgetJustifications(budgetJustifications);
            }
        }
        cummulativeBudgetInfo.setEntirePeriodTotalCost(entireCost);
        return cummulativeBudgetInfo;
    }

    private PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications getBudgetJustifications() {
        PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null) continue;
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) == 35) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification personnelJustification = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification.Factory.newInstance();
                personnelJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setPersonnelJustification(personnelJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) == 36) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification consortiumJustification = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification.Factory.newInstance();
                consortiumJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setConsortiumJustification(consortiumJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) != 37 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification narrativeJustification = (PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification)PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification.Factory.newInstance();
            narrativeJustification.setAttFile(attachedFileDataType);
            budgetJustifications.setAdditionalNarrativeJustification(narrativeJustification);
        }
        return budgetJustifications;
    }

    private PHS398ModularBudget12Document.PHS398ModularBudget12.Periods[] getPeriods(BudgetContract budget) {
        ArrayList<PHS398ModularBudget12Document.PHS398ModularBudget12.Periods> periods = new ArrayList<PHS398ModularBudget12Document.PHS398ModularBudget12.Periods>();
        List modularAmounts = this.getModularBudgetService().getModularBudgetAmounts(budget);
        for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() > BudgetPeriodNum.P5.getNum()) continue;
            PHS398ModularBudget12Document.PHS398ModularBudget12.Periods period = (PHS398ModularBudget12Document.PHS398ModularBudget12.Periods)PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.Factory.newInstance();
            PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.DirectCost directCost = (PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.DirectCost)PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.DirectCost.Factory.newInstance();
            PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost indirectCost = (PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost)PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.Factory.newInstance();
            ScaleTwoDecimal consortiumFandA = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal directCostLessConsortiumFandA = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal totalDirectCosts = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal bdCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal bdBaseCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal bdRate = ScaleTwoDecimal.ZERO;
            String costType = null;
            if (budgetPeriod.getStartDate() != null) {
                period.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
            }
            if (budgetPeriod.getEndDate() != null) {
                period.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
            }
            directCost.setDirectCostLessConsortiumFandA(BigDecimal.ZERO);
            directCost.setTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
            period.setTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
            BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
            if (budgetModular != null) {
                ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
                period.setTotalFundsRequestedDirectIndirectCosts(totalCost.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
                if (budgetModular.getConsortiumFna() != null) {
                    consortiumFandA = budgetModular.getConsortiumFna();
                    directCost.setConsortiumFandA(consortiumFandA.bigDecimalValue());
                    this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
                }
                if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                    directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                    directCost.setDirectCostLessConsortiumFandA(directCostLessConsortiumFandA.bigDecimalValue());
                    this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
                }
                if (budgetModular.getTotalDirectCost() != null) {
                    totalDirectCosts = budgetModular.getTotalDirectCost();
                    directCost.setTotalFundsRequestedDirectCosts(totalDirectCosts.bigDecimalValue());
                    this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
                }
                ArrayList<PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems> indirectCostItemsList = new ArrayList<PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems>();
                for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                    PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems indirectCostItems = (PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems)PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems.Factory.newInstance();
                    if (budgetModularIdc.getFundsRequested() != null) {
                        bdCost = budgetModularIdc.getFundsRequested();
                        indirectCostItems.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                        bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                    }
                    if (budgetModularIdc.getIdcBase() != null) {
                        bdBaseCost = budgetModularIdc.getIdcBase();
                        indirectCostItems.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                    }
                    if (budgetModularIdc.getIdcRate() != null) {
                        bdRate = budgetModularIdc.getIdcRate();
                        indirectCostItems.setIndirectCostRate(bdRate.bigDecimalValue());
                    }
                    if (budgetModularIdc.getDescription() != null) {
                        costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                        indirectCostItems.setIndirectCostTypeDescription(costType);
                    }
                    indirectCostItemsList.add(indirectCostItems);
                }
                PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems[] indirectCostItemsArray = indirectCostItemsList.toArray(new PHS398ModularBudget12Document.PHS398ModularBudget12.Periods.IndirectCost.IndirectCostItems[0]);
                indirectCost.setIndirectCostItemsArray(indirectCostItemsArray);
            }
            period.setDirectCost(directCost);
            OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
            if (organization != null) {
                RolodexContract rolodex;
                if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                    indirectCost.setCognizantFederalAgency(this.getCognizantFederalAgency(rolodex));
                }
                if (organization.getIndirectCostRateAgreement() != null) {
                    indirectCost.setIndirectCostAgreementDate(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
                }
            }
            indirectCost.setTotalFundsRequestedIndirectCost(bdTotalIndirectCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
            period.setIndirectCost(indirectCost);
            periods.add(period);
        }
        return periods.toArray(new PHS398ModularBudget12Document.PHS398ModularBudget12.Periods[0]);
    }

    @Override
    public PHS398ModularBudget12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398ModularBudget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398ModularBudget12Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo cummulativeBudgetInfo = form.getPHS398ModularBudget12().getCummulativeBudgetInfo();
            if (cummulativeBudgetInfo != null && cummulativeBudgetInfo.getBudgetJustifications() != null) {
                PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification personnelJustification = cummulativeBudgetInfo.getBudgetJustifications().getPersonnelJustification();
                if (personnelJustification != null && personnelJustification.getAttFile() != null && a.getContentId().equals(personnelJustification.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS398_ModularBudget_1_2_P1.optionalFile0", a);
                }
                PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification consortiumJustification = cummulativeBudgetInfo.getBudgetJustifications().getConsortiumJustification();
                if (consortiumJustification != null && consortiumJustification.getAttFile() != null && a.getContentId().equals(consortiumJustification.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS398_ModularBudget_1_2_P1.optionalFile1", a);
                }
                PHS398ModularBudget12Document.PHS398ModularBudget12.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification additionalNarrativeJustification = cummulativeBudgetInfo.getBudgetJustifications().getAdditionalNarrativeJustification();
                if (additionalNarrativeJustification != null && additionalNarrativeJustification.getAttFile() != null && a.getContentId().equals(additionalNarrativeJustification.getAttFile().getFileLocation().getHref())) {
                    return CollectionUtils.entry("PHS398_ModularBudget_1_2_P1.optionalFile2", a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHS398ModularBudget12Document> factory() {
        return PHS398ModularBudget12Document.Factory;
    }
}

