/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrOtherProjectInfo12V12.RROtherProjectInfo12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.RROtherProjectInfoBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RROtherProjectInfoV1_2Generator")
public class RROtherProjectInfoV1_2Generator
extends RROtherProjectInfoBaseGenerator<RROtherProjectInfo12Document> {
    private static final Integer HISTORIC_DESTIONATION_YNQ = 125;
    List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/RR_OtherProjectInfo_1_2-V1.2")
    private String namespace;
    @Value(value="RR_OtherProjectInfo_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_OtherProjectInfo-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="140")
    private int sortIndex;

    private RROtherProjectInfo12Document getRROtherProjectInfo() {
        RROtherProjectInfo12Document rrOtherProjectInfoDocument = (RROtherProjectInfo12Document)RROtherProjectInfo12Document.Factory.newInstance();
        RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo = (RROtherProjectInfo12Document.RROtherProjectInfo12)RROtherProjectInfo12Document.RROtherProjectInfo12.Factory.newInstance();
        rrOtherProjectInfo.setFormVersion(FormVersion.v1_2.getVersion());
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        this.setHumanSubjAndVertebrateAnimals(rrOtherProjectInfo, organization);
        this.setProprietaryInformationIndicator(rrOtherProjectInfo);
        this.setEnvironmentalImpactDetails(rrOtherProjectInfo);
        this.setHistoricDestionation(rrOtherProjectInfo);
        this.setInternationalActivities(rrOtherProjectInfo);
        this.setAttachments(rrOtherProjectInfo);
        rrOtherProjectInfoDocument.setRROtherProjectInfo12(rrOtherProjectInfo);
        return rrOtherProjectInfoDocument;
    }

    private void setHistoricDestionation(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        String historicDestinationAnswer = this.getAnswer(HISTORIC_DESTIONATION_YNQ, this.answerHeaders);
        if (historicDestinationAnswer != null && !historicDestinationAnswer.equals("No")) {
            YesNoDataType.Enum answer = this.getAnswer(HISTORIC_DESTIONATION_YNQ, this.answerHeaders).equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            String answerExplanation = this.getChildQuestionAnswer(HISTORIC_DESTIONATION_YNQ, EXPLANATION, this.answerHeaders);
            rrOtherProjectInfo.setHistoricDesignation(answer);
            if (answerExplanation != null) {
                if (answerExplanation.trim().length() > 55) {
                    rrOtherProjectInfo.setHistoricDesignationExplanation(answerExplanation.trim().substring(0, 55));
                } else {
                    rrOtherProjectInfo.setHistoricDesignationExplanation(answerExplanation.trim());
                }
            } else if (YnqConstant.YES.code().equals(historicDestinationAnswer)) {
                rrOtherProjectInfo.setHistoricDesignationExplanation(answerExplanation);
            }
        } else {
            rrOtherProjectInfo.setHistoricDesignation(null);
        }
    }

    private void setProprietaryInformationIndicator(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        YesNoDataType.Enum answer = null;
        String propertyInformationAnswer = this.getAnswer(PROPRIETARY_INFORMATION_INDICATOR, this.answerHeaders);
        if (propertyInformationAnswer != null && !propertyInformationAnswer.equals("No")) {
            answer = YnqConstant.YES.code().equals(propertyInformationAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            rrOtherProjectInfo.setProprietaryInformationIndicator(answer);
        } else {
            rrOtherProjectInfo.setProprietaryInformationIndicator(null);
        }
    }

    private void setEnvironmentalImpactDetails(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact environmentalImpact = (RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact)RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact.Factory.newInstance();
        this.setEnvironmentalImpactIndicatorAndExplanation(environmentalImpact);
        this.setEnvironmentalExemption(environmentalImpact);
        rrOtherProjectInfo.setEnvironmentalImpact(environmentalImpact);
    }

    private void setEnvironmentalImpactIndicatorAndExplanation(RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact environmentalImpact) {
        String answerExplanation = null;
        String environmentalImpactAnswer = this.getAnswer(ENVIRONMENTAL_IMPACT_YNQ, this.answerHeaders);
        if (environmentalImpactAnswer != null && !environmentalImpactAnswer.equals("No")) {
            YesNoDataType.Enum answer = YnqConstant.YES.code().equals(environmentalImpactAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_IMPACT_YNQ, EXPLANATION, this.answerHeaders);
            environmentalImpact.setEnvironmentalImpactIndicator(answer);
            if (answerExplanation != null) {
                if (answerExplanation.trim().length() > 55) {
                    environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation.trim().substring(0, 55));
                } else {
                    environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation.trim());
                }
            } else if (YnqConstant.YES.code().equals(environmentalImpactAnswer)) {
                environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation);
            }
        } else {
            environmentalImpact.setEnvironmentalImpactIndicator(null);
        }
    }

    private void setHumanSubjAndVertebrateAnimals(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo, OrganizationContract organization) {
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract proposalSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (proposalSpecialReview.getSpecialReviewType() == null) continue;
            if ("1".equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
                this.setHumaSubjectSupplementDetails(rrOtherProjectInfo, organization, proposalSpecialReview);
                continue;
            }
            if (!"2".equals(proposalSpecialReview.getSpecialReviewType().getCode())) continue;
            this.setVertebrateAnimalsSupplementDetails(rrOtherProjectInfo, organization, proposalSpecialReview);
        }
    }

    private void setEnvironmentalExemption(RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact environmentalImpact) {
        YesNoDataType.Enum answer = null;
        String answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, EXPLANATION, this.answerHeaders);
        String ynqAnswer = this.getAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, this.answerHeaders);
        answer = YnqConstant.YES.code().equals(ynqAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact.EnvironmentalExemption environmentalExemption = (RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact.EnvironmentalExemption)RROtherProjectInfo12Document.RROtherProjectInfo12.EnvironmentalImpact.EnvironmentalExemption.Factory.newInstance();
        if (ynqAnswer != null && !ynqAnswer.equals("No")) {
            if (!YnqConstant.NA.code().equals(ynqAnswer)) {
                environmentalExemption.setEnvironmentalExemptionIndicator(answer);
                if (answerExplanation != null) {
                    if (answerExplanation.trim().length() > 55) {
                        environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation.trim().substring(0, 55));
                    } else {
                        environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation.trim());
                    }
                } else if (YnqConstant.YES.code().equals(ynqAnswer)) {
                    environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation);
                }
                environmentalImpact.setEnvironmentalExemption(environmentalExemption);
            }
        } else {
            environmentalExemption.setEnvironmentalExemptionIndicator(null);
        }
    }

    private void setInternationalActivities(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        RROtherProjectInfo12Document.RROtherProjectInfo12.InternationalActivities internationalActivities = (RROtherProjectInfo12Document.RROtherProjectInfo12.InternationalActivities)RROtherProjectInfo12Document.RROtherProjectInfo12.InternationalActivities.Factory.newInstance();
        YesNoDataType.Enum answer = null;
        String internationalActivitiesAnswer = this.getAnswer(INTERNATIONAL_ACTIVITIES_YNQ, this.answerHeaders);
        if (internationalActivitiesAnswer != null && !internationalActivitiesAnswer.equals("No")) {
            answer = YnqConstant.YES.code().equals(internationalActivitiesAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            String answerExplanation = this.getAnswer(INTERNATIONAL_ACTIVITIES_EXPL, this.answerHeaders);
            internationalActivities.setInternationalActivitiesIndicator(answer);
            if (answerExplanation != null) {
                if (answerExplanation.trim().length() > 55) {
                    internationalActivities.setActivitiesPartnershipsCountries(answerExplanation.trim().substring(0, 55));
                } else {
                    internationalActivities.setActivitiesPartnershipsCountries(answerExplanation.trim());
                }
                if (this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders) != null) {
                    internationalActivities.setInternationalActivitiesExplanation(this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders));
                }
            } else if (YnqConstant.YES.code().equals(internationalActivitiesAnswer)) {
                internationalActivities.setActivitiesPartnershipsCountries(answerExplanation);
            }
        } else {
            internationalActivities.setInternationalActivitiesIndicator(null);
        }
        rrOtherProjectInfo.setInternationalActivities(internationalActivities);
    }

    private void setVertebrateAnimalsSupplementDetails(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo, OrganizationContract organization, ProposalSpecialReviewContract proposalSpecialReview) {
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.Y_YES);
        RROtherProjectInfo12Document.RROtherProjectInfo12.VertebrateAnimalsSupplement vertebrateAnimalsSupplement = (RROtherProjectInfo12Document.RROtherProjectInfo12.VertebrateAnimalsSupplement)RROtherProjectInfo12Document.RROtherProjectInfo12.VertebrateAnimalsSupplement.Factory.newInstance();
        this.setVertebrateAnimalsIACUCReviewDetails(proposalSpecialReview, vertebrateAnimalsSupplement);
        if (organization != null && organization.getAnimalWelfareAssurance() != null) {
            vertebrateAnimalsSupplement.setAssuranceNumber(organization.getAnimalWelfareAssurance());
        }
        rrOtherProjectInfo.setVertebrateAnimalsSupplement(vertebrateAnimalsSupplement);
    }

    private void setHumaSubjectSupplementDetails(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo, OrganizationContract organization, ProposalSpecialReviewContract proposalSpecialReview) {
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.Y_YES);
        RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement humanSubjectsSupplement = (RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement)RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.Factory.newInstance();
        RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers = (RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers)RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers.Factory.newInstance();
        if (proposalSpecialReview.getApprovalType() != null) {
            this.setExemptions(proposalSpecialReview, humanSubjectsSupplement, exemptionNumbers);
            this.setHumanSubjectIRBReviewIndicator(proposalSpecialReview, humanSubjectsSupplement);
        }
        if (organization != null && organization.getHumanSubAssurance() != null) {
            humanSubjectsSupplement.setHumanSubjectAssuranceNumber(organization.getHumanSubAssurance().substring(3));
        }
        if (humanSubjectsSupplement != null) {
            rrOtherProjectInfo.setHumanSubjectsSupplement(humanSubjectsSupplement);
        }
    }

    private void setVertebrateAnimalsIACUCReviewDetails(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo12Document.RROtherProjectInfo12.VertebrateAnimalsSupplement vertebrateAnimalsSupplement) {
        if ("1".equals(proposalSpecialReview.getApprovalType().getCode())) {
            vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.Y_YES);
        } else {
            vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.N_NO);
            if (proposalSpecialReview.getApprovalDate() != null) {
                vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCApprovalDateReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
            }
        }
    }

    private void setExemptions(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement humanSubjectsSupplement, RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers) {
        if (Integer.parseInt(proposalSpecialReview.getApprovalType().getCode()) == 4) {
            if (proposalSpecialReview.getSpecialReviewExemptions() != null) {
                exemptionNumbers.setExemptionNumberArray((RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[])proposalSpecialReview.getSpecialReviewExemptions().stream().filter(Objects::nonNull).map(e -> e.getExemptionType().getCode()).map(Integer::parseInt).filter(c -> c > 0 && c < 7).map(RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum::forInt).toArray(RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[]::new));
                humanSubjectsSupplement.setExemptionNumbers(exemptionNumbers);
            }
            humanSubjectsSupplement.setExemptFedReg(YesNoDataType.Y_YES);
        } else {
            humanSubjectsSupplement.setExemptFedReg(YesNoDataType.N_NO);
        }
    }

    private void setHumanSubjectIRBReviewIndicator(ProposalSpecialReviewContract proposalSpecialReview, RROtherProjectInfo12Document.RROtherProjectInfo12.HumanSubjectsSupplement humanSubjectsSupplement) {
        if ("1".equals(proposalSpecialReview.getApprovalType().getCode()) || "3".equals(proposalSpecialReview.getApprovalType().getCode())) {
            humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.Y_YES);
        } else {
            humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.N_NO);
            if (proposalSpecialReview.getApprovalDate() != null) {
                humanSubjectsSupplement.setHumanSubjectIRBReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
            }
        }
    }

    private void setAttachments(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        Boolean isOtherAttachmentsExists = false;
        RROtherProjectInfo12Document.RROtherProjectInfo12.ProjectNarrativeAttachments projectNarrativeAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.ProjectNarrativeAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.ProjectNarrativeAttachments.Factory.newInstance();
        RROtherProjectInfo12Document.RROtherProjectInfo12.AbstractAttachments abstractAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.AbstractAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.AbstractAttachments.Factory.newInstance();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null) continue;
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case 3: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfo12Document.RROtherProjectInfo12.EquipmentAttachments equipmentAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.EquipmentAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.EquipmentAttachments.Factory.newInstance();
                    equipmentAttachments.setEquipmentAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setEquipmentAttachments(equipmentAttachments);
                    break;
                }
                case 2: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfo12Document.RROtherProjectInfo12.FacilitiesAttachments facilitiesAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.FacilitiesAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.FacilitiesAttachments.Factory.newInstance();
                    facilitiesAttachments.setFacilitiesAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setFacilitiesAttachments(facilitiesAttachments);
                    break;
                }
                case 1: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    projectNarrativeAttachments.setProjectNarrativeAttachment(attachedFileDataType);
                    break;
                }
                case 4: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfo12Document.RROtherProjectInfo12.BibliographyAttachments bibliographyAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.BibliographyAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.BibliographyAttachments.Factory.newInstance();
                    bibliographyAttachments.setBibliographyAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setBibliographyAttachments(bibliographyAttachments);
                    break;
                }
                case 5: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    abstractAttachments.setAbstractAttachment(attachedFileDataType);
                    break;
                }
                case 8: 
                case 15: {
                    isOtherAttachmentsExists = true;
                }
            }
        }
        rrOtherProjectInfo.setProjectNarrativeAttachments(projectNarrativeAttachments);
        rrOtherProjectInfo.setAbstractAttachments(abstractAttachments);
        if (isOtherAttachmentsExists.booleanValue()) {
            this.setOtherAttachments(rrOtherProjectInfo);
        }
    }

    private void setOtherAttachments(RROtherProjectInfo12Document.RROtherProjectInfo12 rrOtherProjectInfo) {
        RROtherProjectInfo12Document.RROtherProjectInfo12.OtherAttachments otherAttachments = (RROtherProjectInfo12Document.RROtherProjectInfo12.OtherAttachments)RROtherProjectInfo12Document.RROtherProjectInfo12.OtherAttachments.Factory.newInstance();
        otherAttachments.setOtherAttachmentArray(this.getAttachedFileDataTypes());
        rrOtherProjectInfo.setOtherAttachments(otherAttachments);
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        for (NarrativeContract narrative : developmentProposal.getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 8 && Integer.parseInt(narrative.getNarrativeType().getCode()) != 15 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public RROtherProjectInfo12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRROtherProjectInfo();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RROtherProjectInfo12Document> factory() {
        return RROtherProjectInfo12Document.Factory;
    }
}

