/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrPersonalDataV11.DirectorType;
import gov.grants.apply.forms.rrPersonalDataV11.RRPersonalDataDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRPersonalDataBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRPersonalDataV1_1Generator")
public class RRPersonalDataV1_1Generator
extends RRPersonalDataBaseGenerator<RRPersonalDataDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_PersonalData-V1.1")
    private String namespace;
    @Value(value="RR_PersonalData-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_PersonalData-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_PersonalData-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="157")
    private int sortIndex;

    private RRPersonalDataDocument getRRPersonalData() {
        RRPersonalDataDocument rrPersonalDataDocument = (RRPersonalDataDocument)RRPersonalDataDocument.Factory.newInstance();
        RRPersonalDataDocument.RRPersonalData rrPersonalData = (RRPersonalDataDocument.RRPersonalData)RRPersonalDataDocument.RRPersonalData.Factory.newInstance();
        rrPersonalData.setFormVersion(FormVersion.v1_1.getVersion());
        rrPersonalData.setProjectDirector(this.getProjectDirectorType());
        rrPersonalData.setCoProjectDirectorArray(this.getCoProjectDirectoryType());
        rrPersonalDataDocument.setRRPersonalData(rrPersonalData);
        return rrPersonalDataDocument;
    }

    private DirectorType getProjectDirectorType() {
        DirectorType directorType = (DirectorType)DirectorType.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            directorType.setName(this.globLibV20Generator.getHumanNameDataType(PI));
        }
        return directorType;
    }

    private DirectorType[] getCoProjectDirectoryType() {
        ArrayList<DirectorType> directorTypeList = new ArrayList<DirectorType>();
        if (this.pdDoc.getDevelopmentProposal().getProposalPersons() != null) {
            ProposalPersonContract CoPI2 = null;
            for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
                DirectorType coDirectorType = (DirectorType)DirectorType.Factory.newInstance();
                if (proposalPerson.getProposalPersonRoleId() == null || !"COI".equals(proposalPerson.getProposalPersonRoleId())) continue;
                CoPI2 = proposalPerson;
                coDirectorType.setName(this.globLibV20Generator.getHumanNameDataType(CoPI2));
                directorTypeList.add(coDirectorType);
            }
        }
        return directorTypeList.toArray(new DirectorType[0]);
    }

    @Override
    public RRPersonalDataDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRPersonalData();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRPersonalDataDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRPersonalDataDocument> factory() {
        return RRPersonalDataDocument.Factory;
    }
}

