/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.document;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.kns.bo.GlobalBusinessObject;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.bo.MultiDocumentAttachment;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectSerializerService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.KRADUtils;

@Deprecated
public class MaintenanceDocumentBase
extends org.kuali.rice.krad.maintenance.MaintenanceDocumentBase
implements MaintenanceDocument {
    private static final Logger LOG = LogManager.getLogger(MaintenanceDocumentBase.class);
    public static final String ATTACHMENT = "attachment";
    public static final String ATTACHMENTS = "attachments";
    @Transient
    protected transient FormFile fileAttachment;

    public MaintenanceDocumentBase() {
    }

    public MaintenanceDocumentBase(String documentTypeName) {
        super(documentTypeName);
    }

    @Override
    public Object getDocumentBusinessObject() {
        return super.getDocumentDataObject();
    }

    @Override
    public boolean isOldBusinessObjectInDocument() {
        boolean isOldBusinessObjectInExistence = this.getOldMaintainableObject() == null || this.getOldMaintainableObject().getBusinessObject() == null ? false : this.getOldMaintainableObject().isOldBusinessObjectInDocument();
        return isOldBusinessObjectInExistence;
    }

    @Override
    public Maintainable getNewMaintainableObject() {
        return (Maintainable)this.newMaintainableObject;
    }

    @Override
    public Maintainable getOldMaintainableObject() {
        return (Maintainable)this.oldMaintainableObject;
    }

    public FormFile getFileAttachment() {
        return this.fileAttachment;
    }

    public void setFileAttachment(FormFile fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    protected void refreshAttachment() {
        if (KRADUtils.isNull((Object)this.attachment)) {
            boolean isProxy;
            this.refreshReferenceObject(ATTACHMENT);
            boolean bl = isProxy = this.attachment != null && ProxyHelper.isProxy((Object)this.attachment);
            if (isProxy && ProxyHelper.getRealObject((Object)this.attachment) == null) {
                this.attachment = null;
            }
        }
    }

    protected void refreshAttachmentList() {
        if (KRADUtils.isNull((Object)this.attachments)) {
            boolean isProxy;
            this.refreshReferenceObject(ATTACHMENTS);
            boolean bl = isProxy = this.attachments != null && ProxyHelper.isProxy((Object)this.attachments);
            if (isProxy && ProxyHelper.getRealObject((Object)this.attachments) == null) {
                this.attachments = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateDocumentAttachment() {
        this.refreshAttachment();
        if (this.fileAttachment != null && StringUtils.isNotEmpty((String)this.fileAttachment.getFileName()) && this.isAttachmentPropertyNameRootLevel()) {
            if (this.attachment == null) {
                this.attachment = new DocumentAttachment();
            }
            try {
                byte[] fileContents = this.fileAttachment.getFileData();
                if (fileContents.length <= 0) return;
                this.attachment.setFileName(this.fileAttachment.getFileName());
                this.attachment.setContentType(this.fileAttachment.getContentType());
                this.attachment.setAttachmentContent(this.fileAttachment.getFileData());
                this.attachment.setObjectId(UUID.randomUUID().toString());
                PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
                boAttachment.setAttachmentContent(null);
                this.attachment.setDocumentNumber(this.getDocumentNumber());
                return;
            }
            catch (IOException e) {
                LOG.error("Error while populating the Document Attachment", (Throwable)e);
                throw new RuntimeException("Could not populate DocumentAttachment object", e);
            }
        } else {
            PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
            if (this.attachment != null || boAttachment == null || boAttachment.getAttachmentContent() == null) return;
            DocumentAttachment newAttachment = new DocumentAttachment();
            newAttachment.setDocumentNumber(this.getDocumentNumber());
            newAttachment.setAttachmentContent(boAttachment.getAttachmentContent());
            newAttachment.setContentType(boAttachment.getContentType());
            newAttachment.setFileName(boAttachment.getFileName());
            if (newAttachment.getObjectId() == null) {
                newAttachment.setObjectId(UUID.randomUUID().toString());
            }
            if (newAttachment.getVersionNumber() == null) {
                newAttachment.setVersionNumber(Long.valueOf(1L));
            }
            boAttachment.setAttachmentContent(null);
            this.attachment = newAttachment;
        }
    }

    public void populateAttachmentForBO() {
        PersistableAttachment boAttachment;
        this.refreshAttachment();
        Object dataObject = this.newMaintainableObject.getDataObject();
        if (StringUtils.isNotBlank((String)this.getAttachmentPropertyName()) && dataObject instanceof PersistableAttachment) {
            try {
                FormFile attachmentFromBusinessObject;
                String attachmentFormPropertyName;
                if (this.isAttachmentPropertyNameRootLevel()) {
                    attachmentFormPropertyName = this.getAttachmentPropertyName();
                    boAttachment = (PersistableAttachment)dataObject;
                } else {
                    boAttachment = null;
                    attachmentFormPropertyName = null;
                }
                if (boAttachment != null && attachmentFormPropertyName != null && (attachmentFromBusinessObject = (FormFile)PropertyUtils.getNestedProperty((Object)boAttachment, (String)attachmentFormPropertyName)) != null) {
                    boAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                    boAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Not able to get the attachment " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("Not able to get the attachment " + e.getMessage(), e);
            }
        }
        if (dataObject instanceof PersistableAttachment && ((PersistableAttachment)dataObject).getFileName() == null && this.attachment != null) {
            boAttachment = (PersistableAttachment)dataObject;
            if (this.attachment.getFileName() != null) {
                boAttachment.setAttachmentContent(null);
                boAttachment.setFileName(this.attachment.getFileName());
                boAttachment.setContentType(this.attachment.getContentType());
            }
        }
    }

    public void populateAttachmentBeforeSave() {
        PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
        if (this.attachment != null && this.attachment.getAttachmentContent() != null) {
            boAttachment.setAttachmentContent(this.attachment.getAttachmentContent());
        } else {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(null);
            boAttachment.setContentType(null);
        }
    }

    public void populateBoAttachmentListBeforeSave() {
        String key;
        PersistableAttachmentList boAttachments = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (CollectionUtils.isEmpty((Collection)this.attachments)) {
            return;
        }
        HashMap<CallSite, MultiDocumentAttachment> files = new HashMap<CallSite, MultiDocumentAttachment>();
        for (MultiDocumentAttachment multiAttach : this.attachments) {
            key = multiAttach.getFileName() + "|" + multiAttach.getContentType();
            files.put((CallSite)((Object)key), multiAttach);
        }
        if (CollectionUtils.isNotEmpty((Collection)boAttachments.getAttachments())) {
            for (PersistableAttachment attach : boAttachments.getAttachments()) {
                key = attach.getFileName() + "|" + attach.getContentType();
                if (!files.containsKey(key)) continue;
                attach.setAttachmentContent(((MultiDocumentAttachment)files.get(key)).getAttachmentContent());
                files.remove(key);
            }
        }
    }

    public void populateAttachmentListForBO() {
        this.refreshAttachmentList();
        Object dataObject = this.newMaintainableObject.getDataObject();
        if (StringUtils.isNotBlank((String)this.getAttachmentListPropertyName()) && dataObject instanceof PersistableAttachmentList) {
            try {
                PersistableAttachmentList boAttachmentList;
                String attachmentListFormPropertyName;
                if (this.isAttachmentListPropertyNameRootLevel()) {
                    attachmentListFormPropertyName = this.getAttachmentListPropertyName();
                    boAttachmentList = (PersistableAttachmentList)dataObject;
                } else {
                    boAttachmentList = null;
                    attachmentListFormPropertyName = null;
                }
                if (boAttachmentList != null && attachmentListFormPropertyName != null) {
                    for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                        FormFile attachmentFromBusinessObject = (FormFile)PropertyUtils.getNestedProperty((Object)persistableAttachment, (String)attachmentListFormPropertyName);
                        if (attachmentFromBusinessObject == null || !StringUtils.isNotBlank((String)attachmentFromBusinessObject.getFileName())) continue;
                        persistableAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                        persistableAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Not able to get the attachment list" + e.getMessage(), (Throwable)e);
                throw new RuntimeException("Not able to get the attachment list" + e.getMessage(), e);
            }
        }
        if (dataObject instanceof PersistableAttachmentList && CollectionUtils.isNotEmpty((Collection)((PersistableAttachmentList)dataObject).getAttachments())) {
            List att = ((PersistableAttachmentList)dataObject).getAttachments();
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            att.forEach(a -> {
                MultiDocumentAttachment multiDocumentAttachment = new MultiDocumentAttachment();
                multiDocumentAttachment.setContentType(a.getContentType());
                multiDocumentAttachment.setFileName(a.getFileName());
            });
        }
    }

    public void populateDocumentAttachmentList() {
        this.refreshAttachmentList();
        Object dataObject = this.newMaintainableObject.getDataObject();
        if (dataObject instanceof PersistableAttachmentList && CollectionUtils.isNotEmpty((Collection)((PersistableAttachmentList)dataObject).getAttachments()) && this.isAttachmentListPropertyNameRootLevel()) {
            try {
                HashMap<CallSite, MultiDocumentAttachment> files = new HashMap<CallSite, MultiDocumentAttachment>();
                for (MultiDocumentAttachment multiAttach : this.attachments) {
                    String key = multiAttach.getFileName() + "|" + multiAttach.getContentType();
                    files.put((CallSite)((Object)key), multiAttach);
                }
                this.attachments = new ArrayList();
                PersistableAttachmentList boAttachmentList = (PersistableAttachmentList)dataObject;
                for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                    String existingKey = persistableAttachment.getFileName() + "|" + persistableAttachment.getContentType();
                    FormFile attachmentFromBusinessObject = (FormFile)PropertyUtils.getNestedProperty((Object)persistableAttachment, (String)this.getAttachmentListPropertyName());
                    if (attachmentFromBusinessObject != null) {
                        MultiDocumentAttachment attach;
                        String newKey = attachmentFromBusinessObject.getFileName() + "|" + attachmentFromBusinessObject.getContentType();
                        if (files.containsKey(newKey)) {
                            attach = (MultiDocumentAttachment)files.get(newKey);
                            attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                            this.attachments.add(attach);
                            files.remove(newKey);
                            continue;
                        }
                        attach = new MultiDocumentAttachment();
                        attach.setFileName(attachmentFromBusinessObject.getFileName());
                        attach.setContentType(attachmentFromBusinessObject.getContentType());
                        attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                        attach.setDocumentNumber(this.getDocumentNumber());
                        attach.setObjectId(UUID.randomUUID().toString());
                        this.attachments.add(attach);
                        continue;
                    }
                    if (files.containsKey(existingKey)) {
                        this.attachments.add((MultiDocumentAttachment)files.get(existingKey));
                        files.remove(existingKey);
                        continue;
                    }
                    if (persistableAttachment.getFileName() == null || persistableAttachment.getAttachmentContent() == null) continue;
                    MultiDocumentAttachment attach = new MultiDocumentAttachment();
                    attach.setFileName(persistableAttachment.getFileName());
                    attach.setContentType(persistableAttachment.getContentType());
                    attach.setAttachmentContent(persistableAttachment.getAttachmentContent());
                    attach.setDocumentNumber(this.getDocumentNumber());
                    attach.setObjectId(UUID.randomUUID().toString());
                    persistableAttachment.setAttachmentContent(null);
                    this.attachments.add(attach);
                }
            }
            catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Not able to get the attachment list" + e.getMessage(), (Throwable)e);
                throw new RuntimeException("Not able to get the attachment list" + e.getMessage(), e);
            }
        }
    }

    protected BusinessObjectSerializerService getBusinessObjectSerializerService() {
        return KRADServiceLocator.getBusinessObjectSerializerService();
    }

    public void postProcessSave(DocumentEvent event) {
        Object bo = this.getNewMaintainableObject().getDataObject();
        if (bo instanceof GlobalBusinessObject) {
            bo = KRADServiceLocatorWeb.getLegacyDataAdapter().save(bo);
            this.getNewMaintainableObject().setDataObject(bo);
        }
        if (!(event instanceof SaveDocumentEvent)) {
            this.getMaintenanceDocumentService().deleteLocks(this.getDocumentNumber());
            this.getMaintenanceDocumentService().storeLocks(this.getNewMaintainableObject().generateMaintenanceLocks());
        }
    }
}

