/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.group;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.group.GroupContract;
import org.w3c.dom.Element;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="GroupType", propOrder={"id", "namespaceCode", "name", "description", "kimTypeId", "attributes", "active", "versionNumber", "objectId", "_futureElements"})
public final class Group
extends AbstractDataTransferObject
implements GroupContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="kimTypeId", required=true)
    private final String kimTypeId;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Group() {
        this.id = null;
        this.namespaceCode = null;
        this.name = null;
        this.description = null;
        this.kimTypeId = null;
        this.attributes = null;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
    }

    public Group(Builder builder) {
        this.id = builder.getId();
        this.namespaceCode = builder.getNamespaceCode();
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.kimTypeId = builder.getKimTypeId();
        this.attributes = builder.getAttributes() != null ? builder.getAttributes() : Collections.emptyMap();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static class Builder
    implements GroupContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String namespaceCode;
        private String name;
        private String description;
        private String kimTypeId;
        private Map<String, String> attributes = Collections.emptyMap();
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder(String namespaceCode, String name, String kimTypeId) {
            this.setNamespaceCode(namespaceCode);
            this.setName(name);
            this.setKimTypeId(kimTypeId);
        }

        public static Builder create(String namespaceCode, String name, String kimTypeId) {
            return new Builder(namespaceCode, name, kimTypeId);
        }

        public static Builder create(GroupContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("GroupContract is null");
            }
            Builder builder = new Builder(contract.getNamespaceCode(), contract.getName(), contract.getKimTypeId());
            builder.setId(contract.getId());
            builder.setDescription(contract.getDescription());
            if (contract.getAttributes() != null) {
                builder.setAttributes(contract.getAttributes());
            }
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isEmpty((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is empty");
            }
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("name is empty");
            }
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String getKimTypeId() {
            return this.kimTypeId;
        }

        public void setKimTypeId(String kimTypeId) {
            if (StringUtils.isEmpty((String)kimTypeId)) {
                throw new IllegalArgumentException("kimTypeId is empty");
            }
            this.kimTypeId = kimTypeId;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = Collections.unmodifiableMap(Maps.newHashMap(attributes));
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public Group build() {
            return new Group(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/GroupType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String ATTRIBUTES = "attributes";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "group";
        static final String TYPE_NAME = "GroupType";

        Constants() {
        }
    }
}

