/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.rule;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleQueryResults;
import org.kuali.rice.kew.api.rule.RuleReportCriteria;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateContract;
import org.kuali.rice.kew.api.rule.RuleTemplateQueryResults;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.krad.data.DataObjectService;

public class RuleServiceImpl
implements RuleService {
    private static final Logger LOG = LogManager.getLogger(RuleServiceImpl.class);
    private DataObjectService dataObjectService;

    public Rule getRule(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck("id", id);
        RuleBaseValues rbv = (RuleBaseValues)((Object)this.getDataObjectService().find(RuleBaseValues.class, (Object)id));
        if (rbv == null) {
            throw new RiceIllegalStateException("Rule with specified id: " + id + " does not exist");
        }
        return RuleBaseValues.to(rbv);
    }

    public Rule getRuleByName(String name) {
        this.incomingParamCheck("name", name);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build());
        if (results.getResults().isEmpty()) {
            throw new RiceIllegalStateException("Rule with specified name: " + name + " does not exist");
        }
        if (results.getResults().size() > 1) {
            throw new RiceIllegalStateException("Found more than one current rule with specified name " + name);
        }
        return RuleBaseValues.to((RuleBaseValues)((Object)results.getResults().get(0)));
    }

    public List<Rule> getRulesByTemplateId(@WebParam(name="templateId") String templateId) throws RiceIllegalArgumentException {
        this.incomingParamCheck("templateId", templateId);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"ruleTemplateId", (Object)templateId), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(RuleBaseValues.class, builder.build());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (RuleBaseValues bo : results.getResults()) {
            rules.add(Rule.Builder.create((RuleContract)bo).build());
        }
        return rules;
    }

    public List<Rule> getRulesByTemplateNameAndDocumentTypeName(String templateName, String documentTypeName) {
        return this.getRulesByTemplateNameAndDocumentTypeNameAndEffectiveDate(templateName, documentTypeName, null);
    }

    public List<Rule> getRulesByTemplateNameAndDocumentTypeNameAndEffectiveDate(String templateName, String documentTypeName, DateTime effectiveDate) throws RiceIllegalArgumentException {
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"ruleTemplate.name", (Object)templateName));
        DocumentTypeService documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        DocumentType dt = documentTypeService.getDocumentTypeByName(documentTypeName);
        ArrayList<String> documentTypeAncestryNames = new ArrayList<String>();
        while (dt != null) {
            documentTypeAncestryNames.add(dt.getName());
            dt = dt.getParentId() == null ? null : documentTypeService.getDocumentTypeById(dt.getParentId());
        }
        predicates.add(PredicateFactory.in((String)"docTypeName", (Object[])documentTypeAncestryNames.toArray(new String[documentTypeAncestryNames.size()])));
        DateTime currentTime = new DateTime();
        predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"fromDateValue"), PredicateFactory.lessThanOrEqual((String)"fromDateValue", (Object)currentTime)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"toDateValue"), PredicateFactory.greaterThan((String)"toDateValue", (Object)currentTime)})}));
        predicates.add(PredicateFactory.equal((String)"active", (Object)Boolean.TRUE));
        predicates.add(PredicateFactory.equal((String)"delegateRule", (Object)Boolean.FALSE));
        predicates.add(PredicateFactory.equal((String)"templateRuleInd", (Object)Boolean.FALSE));
        if (effectiveDate != null) {
            predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"activationDate"), PredicateFactory.lessThanOrEqual((String)"activationDate", (Object)effectiveDate)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"deactivationDate"), PredicateFactory.greaterThan((String)"deactivationDate", (Object)effectiveDate)})}));
        } else {
            predicates.add(PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE));
        }
        Predicate p = PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]));
        query.setPredicates(new Predicate[]{p});
        return KewApiServiceLocator.getRuleService().findRules(query.build()).getResults();
    }

    public RuleQueryResults findRules(QueryByCriteria queryByCriteria) {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        QueryResults results = this.dataObjectService.findMatching(RuleBaseValues.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        RuleQueryResults.Builder builder = RuleQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Rule.Builder> ims = new ArrayList<Rule.Builder>();
        for (RuleBaseValues bo : results.getResults()) {
            ims.add(Rule.Builder.create((RuleContract)RuleBaseValues.to(bo)));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public List<Rule> ruleReport(RuleReportCriteria ruleReportCriteria) {
        this.incomingParamCheck(ruleReportCriteria, "ruleReportCriteria");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing rule report [responsibleUser=" + ruleReportCriteria.getResponsiblePrincipalId() + ", responsibleWorkgroup=" + ruleReportCriteria.getResponsibleGroupId() + "]");
        }
        List<RuleBaseValues> rulesFound = KEWServiceLocator.getRuleService().searchByTemplate(ruleReportCriteria.getDocumentTypeName(), ruleReportCriteria.getRuleTemplateName(), ruleReportCriteria.getRuleDescription(), ruleReportCriteria.getResponsibleGroupId(), ruleReportCriteria.getResponsiblePrincipalId(), ruleReportCriteria.isConsiderGroupMembership(), ruleReportCriteria.isIncludeDelegations(), ruleReportCriteria.isActive(), ruleReportCriteria.getRuleExtensions(), ruleReportCriteria.getActionRequestCodes());
        ArrayList<Rule> returnableRules = new ArrayList<Rule>(rulesFound.size());
        for (RuleBaseValues rule : rulesFound) {
            returnableRules.add(RuleBaseValues.to(rule));
        }
        return returnableRules;
    }

    public RuleTemplate getRuleTemplate(@WebParam(name="id") String id) {
        this.incomingParamCheck("id", id);
        RuleTemplateBo template = (RuleTemplateBo)((Object)this.dataObjectService.find(RuleTemplateBo.class, (Object)id));
        if (template == null) {
            throw new RiceIllegalStateException("RuleTemplate with specified id: " + id + " does not exist");
        }
        return RuleTemplateBo.to(template);
    }

    public RuleTemplate getRuleTemplateByName(@WebParam(name="name") String name) {
        this.incomingParamCheck("name", name);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name)});
        QueryResults results = this.dataObjectService.findMatching(RuleTemplateBo.class, builder.build());
        if (results.getResults().isEmpty()) {
            throw new RiceIllegalStateException("Rule Template with specified name: " + name + " does not exist");
        }
        if (results.getResults().size() > 1) {
            throw new RiceIllegalStateException("Found more than one rule template with specified name " + name);
        }
        return RuleTemplateBo.to((RuleTemplateBo)((Object)results.getResults().get(0)));
    }

    public RuleTemplateQueryResults findRuleTemplates(@WebParam(name="query") QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        QueryResults results = this.dataObjectService.findMatching(RuleTemplateBo.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        RuleTemplateQueryResults.Builder builder = RuleTemplateQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<RuleTemplate.Builder> ims = new ArrayList<RuleTemplate.Builder>();
        for (RuleTemplateBo bo : results.getResults()) {
            ims.add(RuleTemplate.Builder.create((RuleTemplateContract)RuleTemplateBo.to(bo)));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public RuleResponsibility getRuleResponsibility(String responsibilityId) {
        this.incomingParamCheck("responsibilityId", responsibilityId);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"responsibilityId", (Object)responsibilityId)});
        QueryResults results = this.dataObjectService.findMatching(RuleResponsibilityBo.class, builder.build());
        if (results.getResults().isEmpty()) {
            throw new RiceIllegalStateException("RuleResponsibility with specified id: " + responsibilityId + " does not exist");
        }
        if (results.getResults().size() > 1) {
            throw new RiceIllegalStateException("Found more than one rule responsibility with responsibility id: " + responsibilityId);
        }
        return RuleResponsibilityBo.to((RuleResponsibilityBo)((Object)results.getResults().get(0)));
    }

    public List<RuleDelegation> getRuleDelegationsByResponsibiltityId(@WebParam(name="id") String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck("id", id);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"responsibilityId", (Object)id), PredicateFactory.equal((String)"delegationRule.currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.dataObjectService.findMatching(RuleDelegationBo.class, builder.build());
        ArrayList<RuleDelegation> ruleDelegations = new ArrayList<RuleDelegation>();
        for (RuleDelegationBo bo : results.getResults()) {
            ruleDelegations.add(RuleDelegationBo.to(bo));
        }
        return ruleDelegations;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

