/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;

public class CommonsLoggerImpl
implements Logger {
    private String name;
    private transient Log log;

    public CommonsLoggerImpl(String string) {
        this.name = string;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = LogFactory.getLog((String)this.name);
        }
        return this.log;
    }

    @Override
    public boolean isEnabledFor(int n) {
        Log log = this.getLog();
        switch (n) {
            case 1: {
                return log.isDebugEnabled();
            }
            case 2: {
                return log.isInfoEnabled();
            }
            case 3: {
                return log.isWarnEnabled();
            }
            case 4: {
                return log.isErrorEnabled();
            }
            case 5: {
                return log.isFatalEnabled();
            }
        }
        return false;
    }

    @Override
    public void debug(Object object) {
        this.getLog().debug(object);
    }

    @Override
    public void info(Object object) {
        this.getLog().info(object);
    }

    @Override
    public void warn(Object object) {
        this.getLog().warn(object);
    }

    @Override
    public void error(Object object) {
        this.getLog().error(object);
    }

    @Override
    public void fatal(Object object) {
        this.getLog().fatal(object);
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        this.getLog().debug(object, throwable);
    }

    @Override
    public void info(Object object, Throwable throwable) {
        this.getLog().info(object, throwable);
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.getLog().warn(object, throwable);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.getLog().error(object, throwable);
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.getLog().fatal(object, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void safeDebug(String string, Object object) {
        if (this.getLog().isDebugEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().debug((Object)(string + " : " + string2));
        }
    }

    @Override
    public void safeDebug(String string, Object object, Throwable throwable) {
        if (this.getLog().isDebugEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().debug((Object)(string + " : " + string2), throwable);
        }
    }

    @Override
    public void safeInfo(String string, Object object) {
        if (this.getLog().isInfoEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().info((Object)(string + " : " + string2));
        }
    }

    @Override
    public void safeInfo(String string, Object object, Throwable throwable) {
        if (this.getLog().isInfoEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().info((Object)(string + " : " + string2), throwable);
        }
    }

    @Override
    public void safeWarn(String string, Object object) {
        if (this.getLog().isWarnEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().warn((Object)(string + " : " + string2));
        }
    }

    @Override
    public void safeWarn(String string, Object object, Throwable throwable) {
        if (this.getLog().isWarnEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().warn((Object)(string + " : " + string2), throwable);
        }
    }

    @Override
    public void safeError(String string, Object object) {
        if (this.getLog().isErrorEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().error((Object)(string + " : " + string2));
        }
    }

    @Override
    public void safeError(String string, Object object, Throwable throwable) {
        if (this.getLog().isErrorEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().error((Object)(string + " : " + string2), throwable);
        }
    }

    @Override
    public void safeFatal(String string, Object object) {
        if (this.getLog().isFatalEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().fatal((Object)(string + " : " + string2));
        }
    }

    @Override
    public void safeFatal(String string, Object object, Throwable throwable) {
        if (this.getLog().isFatalEnabled()) {
            String string2 = this.safeToString(object);
            this.getLog().fatal((Object)(string + " : " + string2), throwable);
        }
    }

    private String safeToString(Object object) {
        String string = null;
        if (object != null) {
            try {
                string = object.toString();
            }
            catch (Throwable throwable) {
                string = "BAD toString() impl for " + object.getClass().getName();
            }
        }
        return string;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
    }
}

