/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.auth.task.GenericTaskAuthorizer;
import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizer;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizerGroup;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="taskAuthorizationService")
public class TaskAuthorizationServiceImpl
implements TaskAuthorizationService,
InitializingBean {
    private static final Logger LOG = LogManager.getLogger(TaskAuthorizationServiceImpl.class);
    @Value(value="#{taskAuthorizerGroupNames}")
    private Set<String> taskAuthorizerGroupNames = new HashSet<String>();
    private List<TaskAuthorizerGroup> taskAuthorizerGroups = new ArrayList<TaskAuthorizerGroup>();

    @Override
    @Transactional
    public boolean isAuthorized(String userId, Task task) {
        boolean isAuthorized = true;
        String groupName = task.getGroupName();
        for (TaskAuthorizerGroup taskAuthorizerGroup : this.getTaskAuthorizerGroups()) {
            TaskAuthorizer taskAuthorizer;
            if (!StringUtils.equals((CharSequence)taskAuthorizerGroup.getGroupName(), (CharSequence)groupName)) continue;
            if (task.getGenericTaskName() == null || "".equals(task.getGenericTaskName().trim())) {
                taskAuthorizer = taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName());
            } else if (taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName()) instanceof GenericTaskAuthorizer) {
                taskAuthorizer = taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName());
                ((GenericTaskAuthorizer)((Object)taskAuthorizer)).setGenericTaskName(task.getGenericTaskName());
            } else {
                taskAuthorizer = null;
                LOG.error("An unexpected GenericProtocolAuthorizer was found, " + String.valueOf(taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName()).getClass()));
            }
            if (taskAuthorizer == null) break;
            isAuthorized = taskAuthorizer.isAuthorized(userId, task);
            break;
        }
        return isAuthorized;
    }

    public List<TaskAuthorizerGroup> getTaskAuthorizerGroups() {
        if (this.taskAuthorizerGroups.size() != this.taskAuthorizerGroupNames.size()) {
            for (String taskAuthorizerGroupName : this.taskAuthorizerGroupNames) {
                TaskAuthorizerGroup group = (TaskAuthorizerGroup)GlobalResourceLoader.getService((String)taskAuthorizerGroupName);
                if (group == null || this.contains(this.taskAuthorizerGroups, group)) continue;
                this.taskAuthorizerGroups.add(group);
            }
        }
        return this.taskAuthorizerGroups;
    }

    private boolean contains(Collection<TaskAuthorizerGroup> groups, TaskAuthorizerGroup grp) {
        for (TaskAuthorizerGroup group : groups) {
            if (!group.getGroupName().equals(grp.getGroupName())) continue;
            return true;
        }
        return false;
    }

    public void setTaskAuthorizerGroups(List<TaskAuthorizerGroup> taskAuthorizerGroups) {
        this.taskAuthorizerGroups = taskAuthorizerGroups;
    }

    public Set<String> getTaskAuthorizerGroupNames() {
        return this.taskAuthorizerGroupNames;
    }

    public void setTaskAuthorizerGroupNames(Set<String> taskAuthorizerGroupNames) {
        this.taskAuthorizerGroupNames = taskAuthorizerGroupNames;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskAuthorizerGroupNames == null || this.taskAuthorizerGroupNames.isEmpty()) {
            throw new IllegalStateException("taskAuthorizerGroupNames not set");
        }
    }
}

