/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.kualibuild;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.graphql.GraphqlRequest;
import org.kuali.coeus.sys.framework.kualibuild.KualiBuildApiService;
import org.kuali.coeus.sys.framework.kualibuild.KualiBuildException;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildActionDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildDuplicateDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGroupDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildInitializeWorkflowDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildRoleDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildSubmitDocumentRequest;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUpdateDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUserDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildWithdrawSubmissionDto;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuilAddUserToActionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildActionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildAppResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildDiscardDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildDocumentConnectionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildDuplicateDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildGraphqlResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildGroupsConnectionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildInitializeWorkflowResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildOperatorDto;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildRolesConnectionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildSubmitDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildUpdateDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildUpgradeDocumentResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildUsersConnectionResponse;
import org.kuali.coeus.sys.impl.kualibuild.KualiBuildWithdrawSubmissionResponse;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

@Service(value="kualiBuildApiService")
public class KualiBuildApiServiceImpl
implements KualiBuildApiService,
InitializingBean {
    public static final String API_ENDPOINT = "/app/api/v0/graphql";
    private static final Logger LOG = LogManager.getLogger(KualiBuildApiServiceImpl.class);
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;
    private String endpointUri;

    public void afterPropertiesSet() throws Exception {
        this.endpointUri = this.getKualiBuildUrl() + API_ENDPOINT;
    }

    @Override
    public String getKualiBuildUrl() {
        return this.configurationService.getPropertyValueAsString("kuali.build.base.url");
    }

    @Override
    public List<KualiBuildRoleDto> getUnitRoles(String unitName) {
        if (StringUtils.isBlank((CharSequence)unitName)) {
            throw new IllegalArgumentException("unitName must not be blank");
        }
        GraphqlRequest query = new GraphqlRequest.Builder("query getUnitRoles($unitName: String) {\n  rolesConnection(args: {\n    query: $unitName\n    limit: 50\n  }) {\n    edges {\n      node {\n        id\n        name\n        members {\n          id\n          displayName\n        }\n      }\n    }\n  }\n}\n").variable("unitName", unitName).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)query);
        }
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildRolesConnectionResponse.class, new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)response);
        }
        return ((KualiBuildRolesConnectionResponse)this.verifyResponse(response)).getRoles();
    }

    @Override
    public List<KualiBuildGroupDto> groupForName(String unitName) {
        if (StringUtils.isBlank((CharSequence)unitName)) {
            throw new IllegalArgumentException("unitName must not be blank");
        }
        GraphqlRequest query = new GraphqlRequest.Builder("query groupForName($unitName: String) {\n  groupsConnection(args: { query: $unitName }) {\n    edges {\n      node {\n        id\n        name\n      }\n    }\n  }\n}\n").variable("unitName", unitName).variable("unitName", unitName).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)query);
        }
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildGroupsConnectionResponse.class, new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)response);
        }
        return ((KualiBuildGroupsConnectionResponse)this.verifyResponse(response)).getGroups();
    }

    @Override
    public KualiBuildActionDto actionForId(String actionId) {
        if (StringUtils.isBlank((CharSequence)actionId)) {
            throw new IllegalArgumentException("actionId must not be blank");
        }
        GraphqlRequest query = new GraphqlRequest.Builder("query action ($actionId: String!) {\n  action (actionId: $actionId) {\n    id\n    handlerUrl\n  }\n}\n").variable("actionId", actionId).build();
        LOG.debug("{}", (Object)query);
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildActionResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildActionDto)((KualiBuildActionResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildAppDto appForId(@NotNull String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("appId must not be blank");
        }
        GraphqlRequest query = new GraphqlRequest.Builder("fragment LeafGadgetFragment on Gadget {\n  id\n  type\n  label\n  details\n  customFormKey {\n    enabled\n    value\n  }\n}\nfragment GadgetFragment on Gadget {\n    ...LeafGadgetFragment\n    childrenTemplate {\n        ...LeafGadgetFragment\n        childrenTemplate {\n            ...LeafGadgetFragment\n        }\n    }\n}\nquery appForId($appId: ID) {\n    app(id:$appId) {\n        id\n        name\n        formContainer {\n            id\n            schema {\n              ...GadgetFragment\n            }\n        }\n    }\n}\n").variable("appId", appId).build();
        LOG.debug("{}", (Object)query);
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildAppResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildAppDto)((KualiBuildAppResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public String discardDocument(@NotNull String documentId) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("documentId must not be blank");
        }
        Map<String, String> args = Collections.singletonMap("id", documentId);
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation discardDocument($args: DiscardDocumentInput!) {\n    discardDocument(args: $args)\n}\n").variable("args", args).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildDiscardDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (String)((KualiBuildDiscardDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildDocumentDto retrieveDocumentForUpgradeCheck(@NotNull String documentId) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("documentId must not be blank");
        }
        GraphqlRequest query = new GraphqlRequest.Builder("query documentForUpgradeCheck($id: ID!) {\n  document(id: $id) {\n  status\n    form {\n      id\n    }\n    dataset {\n      formVersion {\n        id\n      }\n    }\n  }\n}\n").variable("id", documentId).build();
        LOG.debug("{}", (Object)query);
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildDocumentDto)((KualiBuildDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public List<KualiBuildDocumentDto> documentsCreatedWith(@NotNull String appId, @NotNull String field, @NotNull String value) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("appId must not be blank");
        }
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new IllegalArgumentException("field must not be blank");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        KualiBuildOperatorDto fields = new KualiBuildOperatorDto();
        fields.setField("integration.__createdWith." + field);
        fields.setValue(value);
        fields.setType("IS");
        GraphqlRequest query = new GraphqlRequest.Builder("fragment LeafGadgetFragment on Gadget {\n  id\n  type\n  label\n  details\n  customFormKey {\n    enabled\n    value\n  }\n}\nfragment GadgetFragment on Gadget {\n    ...LeafGadgetFragment\n    childrenTemplate {\n        ...LeafGadgetFragment\n        childrenTemplate {\n            ...LeafGadgetFragment\n        }\n    }\n}\nquery documentConnection($appId: ID!, $fields: Operator!) {\n  app(id: $appId) {\n    documentConnection(args: { fields: $fields }) {\n      edges {\n        node {\n          id\n          status\n          data\n          meta\n          form {\n            id\n            schema {\n              ...GadgetFragment\n            }\n          }\n        }\n      }\n    }\n  }\n}\n").variable("appId", appId).variable("fields", fields).build();
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildDocumentConnectionResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return ((KualiBuildDocumentConnectionResponse)this.verifyResponse(response)).getDocuments();
    }

    @Override
    public KualiBuildInitializeWorkflowDto initializeWorkflow(@NotNull String appId, @NotNull Map<String, Object> createdWithData, String timeZone) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("appId must not be blank");
        }
        if (createdWithData == null) {
            throw new IllegalArgumentException("createdWithData must not be null");
        }
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("id", appId);
        input.put("createdWithData", createdWithData);
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            input.put("timeZone", timeZone);
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation initializeWorkflow($args: InitializeWorkflowInput!) {\n    initializeWorkflow(args: $args) {\n        actionId\n        documentId\n    }\n}\n").variable("args", input).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildInitializeWorkflowResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildInitializeWorkflowDto)((KualiBuildInitializeWorkflowResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public String submitDocument(@NotNull KualiBuildSubmitDocumentRequest submitDocumentRequest) {
        if (submitDocumentRequest == null) {
            throw new IllegalArgumentException("submitDocumentRequest must not be null");
        }
        if (StringUtils.isBlank((CharSequence)submitDocumentRequest.getDocumentId())) {
            throw new IllegalArgumentException("submitDocumentRequest.documentId must not be blank");
        }
        if (StringUtils.isBlank((CharSequence)submitDocumentRequest.getActionId())) {
            throw new IllegalArgumentException("submitDocumentRequest.actionId must not be blank");
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation submitDocument($actionId: ID!, $comment: String, $data: JSON, $id: ID!, $status: String) {\n    submitDocument(actionId: $actionId, comment: $comment, data: $data, id: $id, status: $status)\n}\n").variables(submitDocumentRequest.toVariables()).build();
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildSubmitDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (String)((KualiBuildSubmitDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildUpdateDocumentDto updateDocument(@NotNull String documentId, @NotNull Map<String, Object> data) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("documentId must not be blank");
        }
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("data must not be empty");
        }
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("id", documentId);
        update.put("data", data);
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation updateDocument($args: UpdateDocumentInput!) {\n    updateDocument(args: $args) {\n        id\n        status\n    }\n}\n").variable("args", update).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildUpdateDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildUpdateDocumentDto)((KualiBuildUpdateDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildDuplicateDocumentDto upgradeDocument(String documentId) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("documentId must not be blank");
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation upgradeDocument($id: ID!) {\n  upgradeDocument(id: $id) {\n    __typename\n    ... on Redirect {\n      url\n    }\n    ... on Error {\n      reason\n    }\n  }\n}\n").variable("id", documentId).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildUpgradeDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildDuplicateDocumentDto)((KualiBuildUpgradeDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildActionDto addUserToAction(@NotNull String actionId, @NotNull String userId) {
        if (StringUtils.isBlank((CharSequence)actionId)) {
            throw new IllegalArgumentException("actionId must not be blank");
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new IllegalArgumentException("userId must not be blank");
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation addUserToAction($actionId:ID!, $userId:ID!) {\n  addUserToAction(actionId:$actionId, userId:$userId) {\n    id\n    handlerUrl\n  }\n}\n").variable("actionId", actionId).variable("userId", userId).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuilAddUserToActionResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildActionDto)((KualiBuilAddUserToActionResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public Optional<KualiBuildUserDto> userForUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("username must not be blank");
        }
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("skip", 0);
        input.put("query", username);
        GraphqlRequest query = new GraphqlRequest.Builder("query usersConnection($args: UserArgsInput!) {\n  usersConnection(args: $args) {\n    edges {\n      node {\n        id\n        username\n      }\n    }\n  }\n}\n").variable("args", input).build();
        HttpEntity request = new HttpEntity((Object)query, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildUsersConnectionResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return ((KualiBuildUsersConnectionResponse)this.verifyResponse(response)).getUsers().stream().filter(u -> u.getUsername().equals(username)).findFirst();
    }

    @Override
    public KualiBuildDuplicateDocumentDto duplicateDocument(String documentId, String timeZone) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException(documentId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("id", documentId);
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            variables.put("timezone", timeZone);
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation duplicateDocument($id: ID!, $timezone: String!) {\n    duplicateDocument(id: $id, timezone: $timezone) {\n      __typename\n      ... on Redirect {\n        url\n        newActionId\n        newDocumentId\n      }\n      ... on Error {\n        reason\n      }\n    }\n}\n").variables(variables).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildDuplicateDocumentResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildDuplicateDocumentDto)((KualiBuildDuplicateDocumentResponse)this.verifyResponse(response)).getPayload();
    }

    @Override
    public KualiBuildWithdrawSubmissionDto withdrawSubmission(String documentId, String timeZone) {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException(documentId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("id", documentId);
        if (StringUtils.isNotBlank((CharSequence)timeZone)) {
            variables.put("timezone", timeZone);
        }
        GraphqlRequest mutation = new GraphqlRequest.Builder("mutation withdrawSubmission($id: ID!, $timezone: String!) {\n    withdrawSubmission(args: { id: $id, timezone: $timezone }) {\n      __typename\n      ... on Success {\n        success\n      }\n      ... on Error {\n        reason\n      }\n    }\n}\n").variables(variables).build();
        LOG.debug("{}", (Object)mutation);
        HttpEntity request = new HttpEntity((Object)mutation, (MultiValueMap)this.getAuthHeaders());
        ResponseEntity response = this.restOperations.postForEntity(this.endpointUri, (Object)request, KualiBuildWithdrawSubmissionResponse.class, new Object[0]);
        LOG.debug("{}", (Object)response);
        return (KualiBuildWithdrawSubmissionDto)((KualiBuildWithdrawSubmissionResponse)this.verifyResponse(response)).getPayload();
    }

    @NotNull
    protected <T extends KualiBuildGraphqlResponse<?>> T verifyResponse(ResponseEntity<T> response) {
        if (response == null) {
            throw new KualiBuildException("Response is null");
        }
        KualiBuildGraphqlResponse body = (KualiBuildGraphqlResponse)response.getBody();
        if (body == null) {
            throw new KualiBuildException("Response body is null");
        }
        if (!body.getErrors().isEmpty()) {
            throw new KualiBuildException(body.getErrors().stream().map(KualiBuildGraphqlResponse.Error::getMessage).collect(Collectors.joining("\n")));
        }
        return (T)body;
    }

    protected HttpHeaders getAuthHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.jwtService.createKualiBuildApiToken());
        LOG.debug("{}", (Object)headers.get((Object)"Authorization"));
        return headers;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }
}

