/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.fiscalyear.FiscalYearMonthService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalFandA;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

class FandARatesDataFeedCommand
extends ProposalDataFeedCommandBase {
    private static final String UNRECOVERED_FANDA_COMMENT_PATTERN = "Added Unrecovered F & A from Proposal Number %s";
    private static final String FANDA_COMMENT_PATTERN = "Added F & A from Proposal Number %s";
    private FiscalYearMonthService fiscalYearMonthService;

    public FandARatesDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            int copyCount = 0;
            if (!this.isLifecyleRatesFlowthruEnabled()) {
                List<InstitutionalProposalUnrecoveredFandA> fAndAs = this.proposal.getInstitutionalProposalUnrecoveredFandAs();
                for (InstitutionalProposalUnrecoveredFandA ipUnrecoveredFandA : fAndAs) {
                    this.award.add(this.copyUnrecoveredFandA(ipUnrecoveredFandA));
                    ++copyCount;
                }
                if (copyCount > 0) {
                    this.addFandARateComment(this.proposal);
                }
            } else {
                this.award.setAwardFandaRate(new ArrayList<AwardFandaRate>());
                List<InstitutionalProposalFandA> fAndAs = this.proposal.getInstitutionalProposalFandAs();
                for (InstitutionalProposalFandA ipFandA : fAndAs) {
                    this.award.add(this.copyFandA(ipFandA));
                    ++copyCount;
                }
                if (copyCount > 0) {
                    String newComment = String.format(FANDA_COMMENT_PATTERN, this.proposal.getProposalNumber());
                    this.appendComments(this.findOrCreateCommentOfSpecifiedType(new AwardCommentFactory().createFandaRateComment()), newComment);
                }
            }
        }
    }

    protected boolean isLifecyleRatesFlowthruEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IP", "All", "Enable_Lifecycle_Rates_Flowthru");
    }

    private void addFandARateComment(InstitutionalProposal proposal) {
        String newComment = String.format(UNRECOVERED_FANDA_COMMENT_PATTERN, proposal.getProposalNumber());
        this.appendComments(this.findOrCreateCommentOfSpecifiedType(new AwardCommentFactory().createFandaRateComment()), newComment);
    }

    private String convertOnCampusBooleanToString(boolean onCampusFlag) {
        return onCampusFlag ? "N" : "F";
    }

    protected ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }

    private AwardFandaRate copyUnrecoveredFandA(InstitutionalProposalUnrecoveredFandA ipUnrecoveredFandA) {
        AwardFandaRate awardFandA = new AwardFandaRate();
        awardFandA.setApplicableFandaRate(ipUnrecoveredFandA.getApplicableIndirectcostRate());
        awardFandA.setFandaRateTypeCode(ipUnrecoveredFandA.getIndirectcostRateTypeCode() == null ? null : ipUnrecoveredFandA.getIndirectcostRateTypeCode().toString());
        awardFandA.setFiscalYear(ipUnrecoveredFandA.getFiscalYear());
        awardFandA.setOnCampusFlag(this.convertOnCampusBooleanToString(ipUnrecoveredFandA.getOnCampusFlag()));
        awardFandA.setUnderrecoveryOfIndirectCost(ipUnrecoveredFandA.getAmount());
        Integer fiscalYear = Integer.parseInt(ipUnrecoveredFandA.getFiscalYear());
        awardFandA.setStartDate(new Date(this.getFiscalYearMonthService().getFiscalYearStartDate(fiscalYear).getTimeInMillis()));
        awardFandA.setEndDate(new Date(this.getFiscalYearMonthService().getFiscalYearEndDate(fiscalYear).getTimeInMillis()));
        awardFandA.setSourceAccount(ipUnrecoveredFandA.getSourceAccount());
        return awardFandA;
    }

    private AwardFandaRate copyFandA(InstitutionalProposalFandA ipFandA) {
        AwardFandaRate awardFandA = new AwardFandaRate();
        awardFandA.setApplicableFandaRate(ipFandA.getApplicableRate());
        awardFandA.setFandaRateTypeCode(ipFandA.getRateTypeCode());
        awardFandA.setFiscalYear(ipFandA.getFiscalYear());
        awardFandA.setOnCampusFlag(this.convertOnCampusBooleanToString(ipFandA.getOnOffCampusFlag()));
        awardFandA.setUnderrecoveryOfIndirectCost(ipFandA.getAmount());
        Integer fiscalYear = Integer.parseInt(ipFandA.getFiscalYear());
        Date startDate = ipFandA.getStartDate() != null ? ipFandA.getStartDate() : new Date(this.getFiscalYearMonthService().getFiscalYearStartDate(fiscalYear).getTimeInMillis());
        awardFandA.setStartDate(startDate);
        awardFandA.setEndDate(new Date(this.getFiscalYearMonthService().getFiscalYearEndDate(fiscalYear).getTimeInMillis()));
        return awardFandA;
    }

    protected FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = KcServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }
}

