/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class BootstrapFilterChain
implements FilterChain {
    private final List<Filter> filters = new LinkedList<Filter>();
    private final FilterChain target;
    private Iterator<Filter> filterIterator;
    private ClassLoader originalClassLoader;

    public BootstrapFilterChain(FilterChain target, ClassLoader originalClassLoader) {
        this.target = target;
        this.originalClassLoader = originalClassLoader;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.filterIterator == null) {
            this.filterIterator = this.filters.iterator();
        }
        if (this.filterIterator.hasNext()) {
            this.filterIterator.next().doFilter(request, response, (FilterChain)this);
        } else {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            this.target.doFilter(request, response);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public boolean containsFilter(Filter filter) {
        return this.filters.contains(filter);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }
}

