/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared;

import java.io.Serializable;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;

public class StateHolderIdGenerator<K extends Serializable> {
    private static final Object DEAD_SENTINEL = new Sentinel();
    volatile int lastUsedId;
    private final StateHolder<K, Integer> forwardMap;
    private final StateHolder<Integer, Serializable> reverseMap;

    public StateHolderIdGenerator(StateRepository repository, Class<K> keyClazz) {
        this.forwardMap = repository.getPersistentStateHolder("forward-map", keyClazz, Integer.class, c -> true, null);
        this.reverseMap = repository.getPersistentStateHolder("reverse-map", Integer.class, Serializable.class, c -> true, null);
    }

    public int map(K key) {
        Integer existing = (Integer)this.forwardMap.get(key);
        if (existing == null) {
            int candidate = this.lastUsedId + 1;
            while (true) {
                Serializable mappedKey;
                if ((mappedKey = (Serializable)this.reverseMap.putIfAbsent((Object)candidate, key)) == null || mappedKey.equals(key)) {
                    existing = (Integer)this.forwardMap.putIfAbsent(key, (Object)candidate);
                    if (existing == null || existing.equals(candidate)) {
                        this.lastUsedId = candidate;
                        return this.lastUsedId;
                    }
                    this.reverseMap.remove((Object)candidate, key);
                    this.setLastUsedId(existing);
                    return existing;
                }
                ++candidate;
            }
        }
        this.setLastUsedId(existing);
        return existing;
    }

    private synchronized void setLastUsedId(Integer existing) {
        this.lastUsedId = Integer.max(existing, this.lastUsedId);
    }

    public void clear(K key, int id) {
        if (!this.forwardMap.remove(key, (Object)id) || !this.reverseMap.remove((Object)id, key)) {
            throw new IllegalStateException();
        }
    }

    public void purge(K alias) {
        int id = (Integer)this.forwardMap.get(alias);
        this.reverseMap.remove((Object)id, alias);
        this.reverseMap.putIfAbsent((Object)id, (Object)((Serializable)DEAD_SENTINEL));
        this.forwardMap.remove(alias, (Object)id);
    }

    static final class Sentinel
    implements Serializable {
        private static final long serialVersionUID = 1L;

        Sentinel() {
        }
    }
}

