<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:HumanSubjectStudy_3_0="http://apply.grants.gov/forms/HumanSubjectStudy_3_0-V3.0"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
                xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
    <xsl:param name="studyNumber"/>
    <xsl:param name="govTrackingNumber"/>
    <xsl:param name="opportunityID"/>
    <xsl:param name="receivedDateTime"/>
    <xsl:param name="isPostSubmission"/>

    <xsl:variable name="studyTitle" select="HumanSubjectStudy_3_0:StudyTitle"/>

    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="rest"
                                       page-height="11in" page-width="8.5in" margin-left="0.6in"
                                       margin-right="0.6in">
                    <fo:region-body margin-top="0.5in" margin-bottom="0.6in"/>
                    <fo:region-before region-name="header"/>
                    <fo:region-after region-name="footer" extent="0.6in"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="all-pages">
                    <fo:repeatable-page-master-alternatives>
                        <fo:conditional-page-master-reference
                                master-reference="rest" page-position="rest"/>
                    </fo:repeatable-page-master-alternatives>
                </fo:page-sequence-master>
            </fo:layout-master-set>

            <!-- Study -->
            <fo:page-sequence master-reference="rest" format="1">

                <fo:static-content flow-name="footer">
                    <fo:table width="100%" space-before.optimum="0pt"
                              space-after.optimum="0pt" table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell hyphenate="true" language="en"
                                               padding-start="0pt" padding-end="0pt" padding-before="1pt"
                                               padding-after="1pt" display-align="before" text-align="left"
                                               border-style="solid" border-width="0pt" border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Tracking Number:
                                            <xsl:value-of select="$govTrackingNumber"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell hyphenate="true" language="en"
                                               line-height="9pt" padding-start="0pt" padding-end="0pt"
                                               padding-before="1pt" padding-after="20pt" display-align="before"
                                               text-align="right" border-style="solid" border-width="0pt"
                                               border-color="white">
                                    <fo:block>
                                        <fo:inline font-size="8px">
                                            Funding Opportunity Number:
                                            <xsl:value-of select="$opportunityID"/>
                                        </fo:inline>
                                        <fo:inline font-size="8px">
                                            Received Date:
                                            <xsl:value-of select="$receivedDateTime"/>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <xsl:call-template name="humanSubjectStudiesSection2"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <!-- PHS Human Subjects and Clinical Trials Information -> Study -> Section 2 -->
    <xsl:template name="humanSubjectStudiesSection2">
        <fo:block>
            <xsl:for-each select="//HumanSubjectStudy_3_0:HumanSubjectStudy_3_0">
                <fo:block>
                    <fo:table width="100%" table-layout="fixed"
                              left="100pt" font-size="9px">
                        <fo:table-column column-width="5%"/>
                        <fo:table-column column-width="15%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>

                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="6">
                                    <fo:block padding="10pt" font-weight="bold">
                                        <fo:inline font-size="10px" padding="2pt">
                                            <xsl:text>Section 2 - Study Population Characteristics</xsl:text>
                                            <xsl:if test="$studyNumber > 0">(Study <xsl:value-of select="$studyNumber"/>)
                                            </xsl:if>
                                        </fo:inline>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>

                            <!--  2.1 Conditions or Focus of Study -->
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="number-columns-spanned" select="6"/>
                                    <xsl:with-param name="label_text">
                                        2.1. Conditions or Focus of Study
                                    </xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>

                            <xsl:for-each select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:StudyConditions">
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="1"
                                                   padding-start="18pt"
                                                   padding-before="3pt" padding-after="6pt" font-size="4px" font-family="ZapfDingbats">
                                        <fo:block>&#x274D;</fo:block>
                                    </fo:table-cell>
                                    <xsl:call-template name="text-field">
                                        <xsl:with-param name="number-columns-spanned" select="5"/>
                                        <xsl:with-param name="field_value" select="."/>
                                    </xsl:call-template>
                                </fo:table-row>
                            </xsl:for-each>

                            <!-- 2.2 Eligibility Criteria -->
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.2. Eligibility Criteria
                                    </xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="textarea-textwith-tabs-newline">
                                    <xsl:with-param name="padding-start" select="18"/>
                                    <xsl:with-param name="number-columns-spanned" select="6"/>
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:EligibilityCriteria"/>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.3. Age Limits
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="nested_field">
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.3.a. Inclusion of Individuals Across the Lifespan
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:InclusionOfIndividualsAcrossLifespan/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.4. Inclusion of Women and Minorities
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:InclusionOfWomenAndMinorities/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.5. Recruitment and Retention Plan
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:RecruitmentAndRetentionPlan/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.6. Recruitment Status
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:RecruitmentStatus"/>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.7. Study Timeline
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:call-template name="text-field">
                                    <xsl:with-param name="field_value"
                                                    select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:StudyTimeline/HumanSubjectStudy_3_0:attFile/att:FileName"/>
                                </xsl:call-template>
                            </fo:table-row>
                            <xsl:if test="$isPostSubmission !='Y'">
                                <fo:table-row>
                                    <xsl:call-template name="label">
                                        <xsl:with-param name="label_text">
                                            2.8. Enrollment of First Participant
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:call-template name="formatDate">
                                        <xsl:with-param name="field_value"
                                                        select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:FirstSubjectEnrollment/HumanSubjectStudy_3_0:EnrollmentDate"/>
                                    </xsl:call-template>
                                    <xsl:call-template name="text-field1">
                                        <xsl:with-param name="field_value"
                                                        select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:FirstSubjectEnrollment/HumanSubjectStudy_3_0:AnticipatedActual"/>
                                    </xsl:call-template>
                                </fo:table-row>
                            </xsl:if>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
                <fo:block page-break-before="always">
                    <fo:table width="100%" table-layout="fixed"
                              left="100pt" font-size="9px">
                        <fo:table-column column-width="5%"/>
                        <fo:table-column column-width="15%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>
                        <fo:table-column column-width="20%"/>

                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <xsl:call-template name="label">
                                    <xsl:with-param name="label_text">
                                        2.9. Inclusion Enrollment Reports
                                    </xsl:with-param>
                                </xsl:call-template>
                            </fo:table-row>

                            <fo:table-row>
                                <xsl:call-template name="ier_summary">
                                </xsl:call-template>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:block>
            </xsl:for-each>
        </fo:block>
    </xsl:template>
    <!-- End of Section 1 -->


    <!-- Utility Templates -->
    <xsl:template name="ier_summary">
        <fo:table-cell number-columns-spanned="6"
                       padding-start="3pt" padding-end="3pt" padding-before="1pt"
                       padding-after="6pt" font-size="9px" font-family="arialuni">
            <fo:block>
                <fo:table width="100%" table-layout="fixed" border-style="solid"
                          border-width="1pt" border-color="black">
                    <fo:table-column column-width="20%"/>
                    <fo:table-column column-width="25%"/>
                    <fo:table-column column-width="55%"/>

                    <fo:table-body>
                        <fo:table-row>
                            <xsl:call-template name="table_header_cell">
                                <xsl:with-param name="label_text">IER ID#</xsl:with-param>
                            </xsl:call-template>
                            <xsl:call-template name="table_header_cell">
                                <xsl:with-param name="label_text">Enrollment Location Type</xsl:with-param>
                            </xsl:call-template>
                            <xsl:call-template name="table_header_cell">
                                <xsl:with-param name="label_text">Enrollment Location</xsl:with-param>
                            </xsl:call-template>
                        </fo:table-row>
                        <xsl:choose>
                            <xsl:when test="count(HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:InclusionEnrollmentReport) > 0">
                                <xsl:for-each select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:InclusionEnrollmentReport">
                                    <xsl:variable name="nodeCount" select="position()"/>
                                    <xsl:variable name="ierid" select="HumanSubjectStudy_3_0:IER_id"/>
                                    <fo:table-row>
                                        <xsl:choose>
                                            <xsl:when test="$isPostSubmission !='Y'">
                                                <xsl:call-template name="table_body_cell_underline">
                                                    <xsl:with-param name="label_text"
                                                                    select="concat('Study ', (concat($studyNumber, concat(', IER ', $nodeCount))))"/>
                                                </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:choose>
                                                    <xsl:when test="$ierid > 0">
                                                        <xsl:call-template name="table_body_cell">
                                                            <xsl:with-param name="label_text" select="concat('IER ',HumanSubjectStudy_3_0:IER_id)"/>
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:call-template name="table_body_cell">
                                                            <xsl:with-param name="label_text" select="concat('IER ', $nodeCount)"/>
                                                        </xsl:call-template>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:call-template name="table_body_cell">
                                            <xsl:with-param name="label_text" select="HumanSubjectStudy_3_0:EnrollmentLocationType"/>
                                        </xsl:call-template>
                                        <xsl:call-template name="table_body_cell_tabs_newline">
                                            <xsl:with-param name="label_text" select="HumanSubjectStudy_3_0:EnrollmentLocations"/>
                                        </xsl:call-template>
                                    </fo:table-row>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="3"
                                                   padding="3pt" border-style="solid" border-width="1pt" border-color="black" text-align="left"
                                                   font-family="arialuni">
                                        <fo:block>The study does not have any IERs
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </xsl:otherwise>
                        </xsl:choose>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="table_header_cell">
        <xsl:param name="label_text"/>
        <fo:table-cell padding="3pt" border-style="solid"
                       border-width="1pt" border-color="black" background-color="#EEEEEE">
            <fo:block>
                <fo:inline font-weight="bold">
                    <xsl:value-of select="$label_text"/>
                </fo:inline>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="table_body_cell">
        <xsl:param name="label_text"/>
        <fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
            <fo:block>
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="table_body_cell_underline">
        <xsl:param name="label_text"/>
        <fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
            <fo:block>
                <fo:inline border-bottom="solid 0.3mm">
                    <xsl:value-of select="$label_text"/>
                </fo:inline>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!--  Create label with display text, ${label_text} -->
    <xsl:template name="label">
        <xsl:param name="number-columns-spanned" select="3"/>
        <xsl:param name="label_text"/>
        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       padding-start="3pt" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt" font-family="arialuni">
            <fo:block>
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="bold_label">
        <xsl:param name="number-columns-spanned" select="3"/>
        <xsl:param name="label_text"/>
        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       padding-start="3pt" padding-end="3pt"
                       padding-before="6pt" padding-after="6pt" font-weight="bold">
            <fo:block>
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!-- A generic field value area: $field_value will be displayed in the cell -->
    <xsl:template name="text-field">
        <xsl:param name="padding-start" select="3"/>
        <xsl:param name="field_value"/>
        <xsl:param name="number-columns-spanned" select="3"/>

        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt" font-family="arialuni">
            <fo:block>
                <xsl:value-of select="$field_value"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!-- A nested table with 4 columns -->
    <xsl:template name="nested_field">
        <fo:table-cell number-columns-spanned="3"
                       padding-start="3pt" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt" font-family="arialuni">
            <fo:block>
                <fo:table width="100%" table-layout="fixed">
                    <fo:table-column column-width="15%"/>
                    <fo:table-column column-width="35%"/>
                    <fo:table-column column-width="15%"/>
                    <fo:table-column column-width="35%"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell>
                                <fo:block>Min Age:</fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block>
                                    <xsl:value-of
                                            select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:AgeLimits/HumanSubjectStudy_3_0:MinimumAge"/>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block>Max Age:</fo:block>
                            </fo:table-cell>
                            <fo:table-cell>
                                <fo:block>
                                    <xsl:value-of
                                            select="HumanSubjectStudy_3_0:StudyPopulationCharacteristics/HumanSubjectStudy_3_0:AgeLimits/HumanSubjectStudy_3_0:MaximumAge"/>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <xsl:template name="formatDate">
        <xsl:param name="padding-start" select="3"/>
        <xsl:param name="field_value"/>
        <xsl:param name="number-columns-spanned" select="1"/>

        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt" font-family="arialuni">
            <fo:block>
                <xsl:if test="$field_value != ''">
                    <xsl:value-of select="format-number(substring($field_value,6,2), '00')"/>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="format-number(substring($field_value,9,2), '00')"/>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="format-number(substring($field_value,1,4), '0000')"/>
                </xsl:if>
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    <xsl:template name="text-field1">
        <xsl:param name="padding-start" select="3"/>
        <xsl:param name="field_value"/>
        <xsl:param name="number-columns-spanned" select="2"/>

        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt" font-family="arialuni">
            <fo:block>
                <xsl:value-of select="$field_value"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!-- Template for textarea to preserve white space, new line character and tabs, ${label_text} -->
    <xsl:template name="textarea-label">
        <xsl:param name="padding-start" select="0"/>
        <xsl:param name="number-columns-spanned"/>
        <xsl:param name="field_value"/>
        <fo:table-cell number-columns-spanned="{$number-columns-spanned}"
                       text-align="left" padding-start="{$padding-start}" padding-end="3pt"
                       padding-before="1pt" padding-after="6pt">
            <fo:block font-family="arialuni" font-size="9px" linefeed-treatment="preserve" white-space-collapse="false" wrap-option="wrap"
                      white-space-treatment="preserve">
                <xsl:value-of select="$field_value"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!--  template to replace tabs with 5 spaces and to preserve new line characters-->
    <xsl:template name="textarea-textwith-tabs-newline">
        <xsl:param name="field_value" select="."/>
        <xsl:param name="padding-start" select="0"/>
        <xsl:param name="number-columns-spanned"/>
        <xsl:param name="text" select="$field_value"/>

        <xsl:variable name="tabspaces" select="'     '"/>
        <xsl:variable name="tabText" select="'&#x09;'"/>
        <xsl:variable name="tabIndex" select="string-length(substring-before($field_value, $tabText))"/>
        <xsl:choose>
            <xsl:when test="$tabIndex > 0">
                <xsl:variable name="newLabeltext1">
                    <xsl:call-template name="replace-all-string-template">
                        <xsl:with-param name="text" select="$text"/>
                        <xsl:with-param name="replace" select="$tabText"/>
                        <xsl:with-param name="with" select="$tabspaces"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:call-template name="textarea-label">
                    <xsl:with-param name="field_value" select="$newLabeltext1"/>
                    <xsl:with-param name="number-columns-spanned" select="$number-columns-spanned"/>
                    <xsl:with-param name="padding-start" select="$padding-start"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="textarea-label">
                    <xsl:with-param name="field_value" select="$field_value"/>
                    <xsl:with-param name="number-columns-spanned" select="$number-columns-spanned"/>
                    <xsl:with-param name="padding-start" select="$padding-start"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Replace all String  
        text         : main string
        replace : the string fragment to be replaced
        with    :  the replacement string -->
    <xsl:template name="replace-all-string-template">
        <xsl:param name="text"/>
        <xsl:param name="replace"/>
        <xsl:param name="with"/>
        <xsl:choose>
            <xsl:when test="contains($text,$replace)">
                <xsl:value-of select="substring-before($text,$replace)"/>
                <xsl:value-of select="$with"/>
                <xsl:call-template name="replace-all-string-template">
                    <xsl:with-param name="text" select="substring-after($text,$replace)"/>
                    <xsl:with-param name="replace" select="$replace"/>
                    <xsl:with-param name="with" select="$with"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Preserves new line character inside table cell -->
    <xsl:template name="table_body_cell_newline">
        <xsl:param name="label_text"/>
        <fo:table-cell padding="3pt" hyphenate="true" border-style="solid" border-width="1pt" border-color="black" page-break-inside="avoid">
            <fo:block font-family="arialuni" font-size="9px" linefeed-treatment="preserve" white-space-collapse="false" wrap-option="wrap"
                      white-space-treatment="preserve">
                <xsl:value-of select="$label_text"/>
            </fo:block>
        </fo:table-cell>
    </xsl:template>

    <!--  template to replace tabs with 5 spaces and to preserve new line characters-->
    <xsl:template name="table_body_cell_tabs_newline">
        <xsl:param name="label_text" select="."/>
        <xsl:param name="text" select="$label_text"/>

        <xsl:variable name="tabspaces" select="'     '"/>
        <xsl:variable name="tabText" select="'&#x09;'"/>
        <xsl:variable name="tabIndex" select="string-length(substring-before($label_text, $tabText))"/>
        <xsl:choose>
            <xsl:when test="$tabIndex > 0">
                <xsl:variable name="newLabeltext1">
                    <xsl:call-template name="replace-all-string-template">
                        <xsl:with-param name="text" select="$text"/>
                        <xsl:with-param name="replace" select="$tabText"/>
                        <xsl:with-param name="with" select="$tabspaces"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:call-template name="table_body_cell_newline">
                    <xsl:with-param name="label_text" select="$newLabeltext1"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="table_body_cell_newline">
                    <xsl:with-param name="label_text" select="$label_text"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
