-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

create table s2s_app_submission_01152019 as select * from s2s_app_submission;

-- if an AGENCY_TRACKING_ID is present then it must have a terminal status of Agency Tracking Number Assigned
update s2s_app_submission set status = 'Agency Tracking Number Assigned' where AGENCY_TRACKING_ID is not null;

-- enum name to official status value
update s2s_app_submission set status = 'Receiving' where upper(status) = upper('RECEIVING');
update s2s_app_submission set status = 'Received' where upper(status) = upper('RECEIVED');
update s2s_app_submission set status = 'Processing' where upper(status) = upper('PROCESSING');
update s2s_app_submission set status = 'Validated' where upper(status) = upper('VALIDATED');
update s2s_app_submission set status = 'Rejected with Errors' where upper(status) = upper('REJECTED_WITH_ERRORS');
update s2s_app_submission set status = 'Download Preparation' where upper(status) = upper('DOWNLOAD_PREPARATION');
update s2s_app_submission set status = 'Received by Agency' where upper(status) = upper('RECEIVED_BY_AGENCY');
update s2s_app_submission set status = 'Agency Tracking Number Assigned' where upper(status) = upper('AGENCY_TRACKING_NUMBER_ASSIGNED');

-- unknown and custom status to official status value
update s2s_app_submission set status = 'Receiving' where upper(status) = upper('S2SReceiving');
update s2s_app_submission set status = 'Received' where upper(status) = upper('S2SReceived');
update s2s_app_submission set status = 'Received' where upper(status) = upper('QUEUED');
update s2s_app_submission set status = 'Processing' where upper(status) = upper('AcceptingProcess');
update s2s_app_submission set status = 'Validated' where upper(status) = upper('Processed');
update s2s_app_submission set status = 'Rejected with Errors' where upper(status) = upper('REJECTION');

-- unknown and custom status to custom status
update s2s_app_submission set status = 'Submitted to S2S' where upper(status) = upper('Submitted to Grants.Gov');
update s2s_app_submission set status = 'Submitted to S2S' where upper(status) = upper('Grants.Gov Submission in Process');

