/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.ojb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public class BaseOjbConfigurer
extends BaseLifecycle
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(BaseOjbConfigurer.class);
    public static final String RICE_OJB_PROPERTIES_PARAM = "rice.custom.ojb.properties";
    public static final String OJB_PROPERTIES_PROP = "OJB.properties";
    protected String[] jcdAliases;
    protected String metadataLocation;
    protected List<String> additionalMetadataLocations;

    public BaseOjbConfigurer() {
    }

    public BaseOjbConfigurer(String moduleName) {
        this.metadataLocation = "classpath:org/kuali/rice/" + moduleName.toLowerCase() + "/config/OJB-repository-" + moduleName.toLowerCase() + ".xml";
        this.jcdAliases = new String[]{moduleName.toLowerCase() + "DataSource"};
    }

    public BaseOjbConfigurer(String[] jcdAliases, String metadataLocation) {
        this.jcdAliases = jcdAliases;
        this.metadataLocation = metadataLocation;
    }

    public void start() throws Exception {
        String currentValue = System.getProperty(OJB_PROPERTIES_PROP);
        try {
            System.setProperty(OJB_PROPERTIES_PROP, this.getOjbPropertiesLocation());
            MetadataManager mm = MetadataManager.getInstance();
            this.establishConnectionMetaData(mm);
            this.establishRepositoryMetaData(mm);
        }
        finally {
            if (currentValue == null) {
                System.getProperties().remove(OJB_PROPERTIES_PROP);
            } else {
                System.setProperty(OJB_PROPERTIES_PROP, currentValue);
            }
        }
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected String getOjbPropertiesLocation() {
        String ojbPropertiesLocation = ConfigContext.getCurrentContextConfig().getProperty(RICE_OJB_PROPERTIES_PARAM);
        return ojbPropertiesLocation;
    }

    protected void establishConnectionMetaData(MetadataManager mm) throws Exception {
        String connMetadata = this.getMetadataLocation();
        if (StringUtils.isBlank((String)connMetadata)) {
            LOG.info("No OJB connection metadata loaded.");
            return;
        }
        if (!this.isConnectionAlreadyConfigured(mm)) {
            LOG.info("Loading OJB Connection Metadata from " + connMetadata);
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
            InputStream is = resourceLoader.getResource(connMetadata).getInputStream();
            is = this.preprocessConnectionMetadata(is);
            ConnectionRepository cr = mm.readConnectionRepository(is);
            mm.mergeConnectionRepository(cr);
            try {
                is.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close stream to file " + connMetadata, (Throwable)e);
            }
        } else {
            LOG.info("OJB Connections already configured for jcd aliases '" + StringUtils.join((Object[])this.getJcdAliases(), (String)", ") + "', skipping Metadata merge.");
        }
    }

    protected InputStream preprocessConnectionMetadata(InputStream inputStream) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(inputStream));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList connectionDescriptors = (NodeList)xpath.evaluate("/descriptor-repository/jdbc-connection-descriptor", document, XPathConstants.NODESET);
        for (int index = 0; index < connectionDescriptors.getLength(); ++index) {
            Element descriptor = (Element)connectionDescriptors.item(index);
            String currentPlatform = descriptor.getAttribute("platform");
            if (!StringUtils.isBlank((String)currentPlatform)) continue;
            String ojbPlatform = ConfigContext.getCurrentContextConfig().getProperty("datasource.ojb.platform");
            if (StringUtils.isEmpty((String)ojbPlatform)) {
                throw new ConfigurationException("Could not configure OJB, the 'datasource.ojb.platform' configuration property was not set.");
            }
            LOG.info("Setting OJB connection descriptor database platform to '" + ojbPlatform + "'");
            descriptor.setAttribute("platform", ojbPlatform);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult(new BufferedOutputStream(baos)));
        return new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
    }

    protected boolean isConnectionAlreadyConfigured(MetadataManager mm) {
        List descriptors = mm.connectionRepository().getAllDescriptor();
        for (JdbcConnectionDescriptor descriptor : descriptors) {
            for (String jcdAlias : this.getJcdAliases()) {
                if (!descriptor.getJcdAlias().equals(jcdAlias)) continue;
                return true;
            }
        }
        return false;
    }

    protected InputStream preprocessRepositoryMetadata(InputStream inputStream) throws Exception {
        return inputStream;
    }

    protected void establishRepositoryMetaData(MetadataManager mm) throws Exception {
        String repoMetadata = this.getMetadataLocation();
        if (StringUtils.isBlank((String)repoMetadata)) {
            LOG.info("No OJB repository metadata loaded.");
            return;
        }
        LOG.info("Loading OJB Metadata from " + repoMetadata);
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        InputStream is = resourceLoader.getResource(repoMetadata).getInputStream();
        is = this.preprocessRepositoryMetadata(is);
        DescriptorRepository dr = mm.readDescriptorRepository(is);
        mm.mergeDescriptorRepository(dr);
        try {
            is.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close stream to file " + repoMetadata, (Throwable)e);
        }
        if (this.additionalMetadataLocations != null) {
            for (String metadataLocation : this.additionalMetadataLocations) {
                LOG.info("Loading OJB Metadata from " + metadataLocation);
                InputStream is2 = resourceLoader.getResource(metadataLocation).getInputStream();
                is2 = this.preprocessRepositoryMetadata(is2);
                DescriptorRepository dr2 = mm.readDescriptorRepository(is2);
                mm.mergeDescriptorRepository(dr2);
                try {
                    is2.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close stream to file " + metadataLocation, (Throwable)e);
                }
            }
        }
    }

    protected String[] getJcdAliases() {
        return this.jcdAliases;
    }

    protected String getMetadataLocation() {
        return this.metadataLocation;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void setJcdAliases(String[] jcdAliases) {
        this.jcdAliases = jcdAliases;
    }

    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
    }

    public List<String> getAdditionalMetadataLocations() {
        return this.additionalMetadataLocations;
    }

    public void setAdditionalMetadataLocations(List<String> additionalMetadataLocations) {
        this.additionalMetadataLocations = additionalMetadataLocations;
    }
}

